/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.websocket;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.error.BaseErrorCode;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.utils.UserAgent;
import com.inet.http.websocket.WebSocketConnectionListener;
import com.inet.http.websocket.WebSocketEvent;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketServlet;
import com.inet.http.websocket.WebsocketConnection;
import com.inet.id.GUID;
import com.inet.lib.io.FastBufferedInputStream;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.Session;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@InternalApi
public class WebSocketEventHandler {
    public static final String PATH = "/websocket";
    private static WebSocketEventHandler a;
    private String b;
    private Map<String, WebSocketEvent<?>> c;
    private Map<String, WebsocketConnection> d = new ConcurrentHashMap<String, WebsocketConnection>();
    private a e;
    private WebSocketConnectionListener[] f = new WebSocketConnectionListener[0];

    public WebSocketEventHandler(@Nonnull String path) {
        this.b = path;
        this.e = new a(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static WebSocketEventHandler getInstance() {
        WebSocketEventHandler webSocketEventHandler = a;
        if (webSocketEventHandler != null) return webSocketEventHandler;
        Class<WebSocketEventHandler> clazz = WebSocketEventHandler.class;
        synchronized (WebSocketEventHandler.class) {
            webSocketEventHandler = a;
            if (webSocketEventHandler != null) return webSocketEventHandler;
            a = webSocketEventHandler = new WebSocketEventHandler(PATH);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return webSocketEventHandler;
        }
    }

    public void sendEvent(String pollingID, Supplier<WebSocketEventData> eventFactory) {
        WebsocketConnection websocketConnection = this.d.get(pollingID);
        if (websocketConnection == null) {
            return;
        }
        HttpSession httpSession = websocketConnection.getActiveHttpSession();
        if (httpSession == null) {
            this.connectionClosed(pollingID, websocketConnection);
            return;
        }
        LoginProcessor loginProcessor = LoginManager.getLoginProcessor(httpSession);
        GUID gUID = loginProcessor != null ? loginProcessor.getUserAccountID() : null;
        try (UserAccountScope userAccountScope = new UserAccountScope(gUID, loginProcessor);){
            WebSocketEventHandler.a(websocketConnection, eventFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(@Nonnull WebsocketConnection websocketConnection, @Nonnull Supplier<WebSocketEventData> supplier) {
        Locale locale = ClientLocale.getThreadLocale();
        TimeZone timeZone = ClientTimezone.getTimeZone();
        try {
            websocketConnection.setSessionLocale();
            websocketConnection.setSessionTimeZone();
            WebSocketEventData webSocketEventData = supplier.get();
            if (webSocketEventData == null) {
                return;
            }
            websocketConnection.sendEvent(webSocketEventData.getEvent(), webSocketEventData.getData());
        }
        finally {
            ClientLocale.setThreadLocale(locale);
            ClientTimezone.setTimeZone(timeZone);
        }
    }

    public void sendEvent(GUID accountID, Supplier<WebSocketEventData> eventFactory) {
        for (WebsocketConnection websocketConnection : this.getConnectionsForUser(accountID)) {
            HttpSession httpSession = websocketConnection.getActiveHttpSession();
            if (httpSession == null) {
                this.connectionClosed(websocketConnection.getPollingID(), websocketConnection);
                continue;
            }
            LoginProcessor loginProcessor = LoginManager.getLoginProcessor(httpSession);
            if (loginProcessor == null) continue;
            try (UserAccountScope userAccountScope = new UserAccountScope(accountID, loginProcessor);){
                WebSocketEventHandler.a(websocketConnection, eventFactory);
            }
        }
    }

    @Nonnull
    public List<WebsocketConnection> getConnectionsForUser(@Nonnull GUID accountID) {
        ArrayList<WebsocketConnection> arrayList = new ArrayList<WebsocketConnection>();
        HashSet<WebsocketConnection> hashSet = new HashSet<WebsocketConnection>(this.d.values());
        for (WebsocketConnection websocketConnection : hashSet) {
            GUID gUID;
            LoginProcessor loginProcessor;
            HttpSession httpSession = websocketConnection.getActiveHttpSession();
            if (httpSession == null || (loginProcessor = LoginManager.getLoginProcessor(httpSession)) == null || (gUID = loginProcessor.getUserAccountID()) == null || !gUID.equals(accountID)) continue;
            arrayList.add(websocketConnection);
        }
        return arrayList;
    }

    @Nonnull
    public Set<GUID> getAllConnectedUserIDs() {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        for (WebsocketConnection websocketConnection : this.d.values()) {
            GUID gUID;
            LoginProcessor loginProcessor;
            HttpSession httpSession = websocketConnection.getActiveHttpSession();
            if (httpSession == null || (loginProcessor = LoginManager.getLoginProcessor(httpSession)) == null || (gUID = loginProcessor.getUserAccountID()) == null) continue;
            hashSet.add(gUID);
        }
        return hashSet;
    }

    @Nonnull
    public String getPath() {
        return this.b;
    }

    private WebSocketEvent<?> a(String string) {
        if (this.c == null) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            List<WebSocketEvent> list = ServerPluginManager.getInstance().get(WebSocketEvent.class);
            for (WebSocketEvent webSocketEvent : list) {
                concurrentHashMap.put(webSocketEvent.getEventName(), webSocketEvent);
            }
            this.c = concurrentHashMap;
        }
        return this.c.get(string);
    }

    public void handleEvent(Reader input, WebsocketConnection websocketConnection) throws IOException {
        if (input != null) {
            String string = null;
            try (EncodedReader encodedReader = new EncodedReader(input);){
                Session session;
                WebSocketEventData webSocketEventData = new Json().fromJson((Reader)encodedReader, WebSocketEventData.class, (JsonTypeResolver)this.e);
                string = webSocketEventData.getEvent();
                if (WebSocketServlet.LOGGER.isInfo() && websocketConnection != null && (session = websocketConnection.getSession()) != null) {
                    URI uRI = session.getRequestURI();
                    HttpSession httpSession = websocketConnection.getActiveHttpSession();
                    String string2 = String.valueOf(httpSession.getAttribute("RemoteAddr")) + " \"WSIN " + string + "@" + uRI.getPath() + " " + uRI.getScheme().toUpperCase() + "/" + websocketConnection.getSession().getProtocolVersion() + "\" -1 -1 \"" + websocketConnection.getPollingID() + "\" \"" + String.valueOf(httpSession.getAttribute("user-agent")) + "\"";
                    WebSocketServlet.LOGGER.info(string2);
                }
                if ((session = this.a(string)) == null) {
                    WebSocketServlet.LOGGER.error("Available event handlers: " + String.valueOf(this.c == null ? "null" : this.c.keySet()));
                    throw new IllegalArgumentException("No event handler found for websocket event '" + string + "'.");
                }
                this.a(websocketConnection, (WebSocketEvent)session, webSocketEventData.getData());
            }
            catch (Throwable throwable) {
                if (UserAgent.isBot()) {
                    WebSocketServlet.LOGGER.debug(throwable);
                } else {
                    if (string != null) {
                        WebSocketServlet.LOGGER.error("Error handling event '" + string + "'");
                    }
                    WebSocketServlet.LOGGER.error(throwable);
                }
                if (websocketConnection != null) {
                    websocketConnection.sendEvent("error", StringFunctions.getUserFriendlyErrorMessage(throwable));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(InputStream input, WebsocketConnection websocketConnection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        websocketConnection.a(input);
        try {
            WebSocketEvent<?> webSocketEvent;
            Object object;
            Object object2;
            block14: while (true) {
                int n2 = input.read();
                switch (n2) {
                    case -1: {
                        throw new EOFException(stringBuilder.toString());
                    }
                    case 10: {
                        break block14;
                    }
                    default: {
                        stringBuilder.append((char)n2);
                        if (stringBuilder.length() <= 255) continue block14;
                        throw new IllegalArgumentException("No event handler found for websocket event '" + String.valueOf(stringBuilder) + "'.");
                    }
                }
                break;
            }
            if (WebSocketServlet.LOGGER.isInfo()) {
                URI uRI = websocketConnection.getSession().getRequestURI();
                object2 = websocketConnection.getActiveHttpSession();
                object = String.valueOf(object2.getAttribute("RemoteAddr")) + " \"WSIN " + String.valueOf(stringBuilder) + "@" + uRI.getPath() + " " + uRI.getScheme().toUpperCase() + "/" + websocketConnection.getSession().getProtocolVersion() + "\" -1 -1 \"" + websocketConnection.getPollingID() + "\" \"" + String.valueOf(object2.getAttribute("user-agent")) + "\"";
                WebSocketServlet.LOGGER.info(object);
            }
            if ((webSocketEvent = this.a(stringBuilder.toString())) == null) {
                if (ServerPluginManager.IS_SERVLET_API) {
                    throw new IllegalArgumentException("No event handler found for websocket event '" + String.valueOf(stringBuilder) + "'.");
                }
                throw new IllegalArgumentException("WebSocket API is missing");
            }
            object = webSocketEvent.a();
            if (object == InputStream.class) {
                object2 = input;
            } else if (object == Void.class) {
                object2 = null;
            } else {
                FastBufferedInputStream fastBufferedInputStream = new FastBufferedInputStream(input);
                try (EncodedReader encodedReader = new EncodedReader(fastBufferedInputStream);){
                    object2 = new Json().fromJson((Reader)encodedReader, (Type)object);
                    if (ServerPluginManager.DEBUG && fastBufferedInputStream.available() > 0) {
                        int n3;
                        LogManager.getApplicationLogger().error(String.valueOf(websocketConnection.getSession().getRequestURI()) + " - " + stringBuilder.toString());
                        StringBuilder stringBuilder2 = new StringBuilder();
                        while ((n3 = encodedReader.read()) >= 0) {
                            stringBuilder2.append((char)n3);
                        }
                        LogManager.getApplicationLogger().error(fastBufferedInputStream.available() + " " + stringBuilder2.length() + " " + String.valueOf(stringBuilder2));
                    }
                }
            }
            this.a(websocketConnection, webSocketEvent, object2);
        }
        catch (Throwable throwable) {
            if (stringBuilder.length() > 0) {
                WebSocketServlet.LOGGER.error("Error handling event '" + String.valueOf(stringBuilder) + "'");
            }
            WebSocketServlet.LOGGER.error(throwable);
            websocketConnection.sendEvent("error", StringFunctions.getUserFriendlyErrorMessage(throwable));
            return;
        }
        finally {
            websocketConnection.b(input);
        }
    }

    private <IN> void a(WebsocketConnection websocketConnection, WebSocketEvent<IN> webSocketEvent, Object object) throws IOException {
        try {
            webSocketEvent.handle(this, websocketConnection, webSocketEvent.getPayload(object));
        }
        catch (AccessDeniedException accessDeniedException) {
            int n2 = accessDeniedException.getErrorCode();
            if (n2 == BaseErrorCode.UserLoginRequired.getErrorCodeNumber() || n2 == BaseErrorCode.UserNotLoggedIn.getErrorCodeNumber()) {
                websocketConnection.sendEvent("authenticationrequired", null);
            }
            websocketConnection.sendEvent("error", accessDeniedException.getMessage());
        }
    }

    public WebsocketConnection getConnection(String pollingID) {
        return this.d.get(pollingID);
    }

    public void connectionOpened(String pollingID, WebsocketConnection connection) {
        WebsocketConnection websocketConnection = this.d.put(pollingID, connection);
        ArrayList<WebSocketEventData> arrayList = null;
        if (websocketConnection != null) {
            this.connectionClosed(pollingID, websocketConnection);
            arrayList = websocketConnection.a();
        }
        for (WebSocketConnectionListener webSocketConnectionListener : this.f) {
            try {
                webSocketConnectionListener.connectionOpened(pollingID);
            }
            catch (Throwable throwable) {
                WebSocketServlet.LOGGER.error(throwable);
            }
        }
        if (arrayList != null) {
            ArrayList<WebSocketEventData> arrayList2 = new ArrayList<WebSocketEventData>(arrayList);
            arrayList.clear();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                WebSocketEventData webSocketEventData = (WebSocketEventData)iterator.next();
                connection.sendEvent(webSocketEventData.getEvent(), webSocketEventData.getData());
            }
        }
    }

    public void connectionClosed(String pollingID, WebsocketConnection connection) {
        for (WebSocketConnectionListener webSocketConnectionListener : this.f) {
            try {
                webSocketConnectionListener.connectionClosed(pollingID);
            }
            catch (Throwable throwable) {
                WebSocketServlet.LOGGER.error(throwable);
            }
        }
        if (connection == null) {
            connection = this.d.remove(pollingID);
        } else {
            WebsocketConnection websocketConnection = this.d.get(pollingID);
            if (connection.equals(websocketConnection)) {
                this.d.remove(pollingID);
            }
        }
        if (connection != null) {
            connection.b();
        }
    }

    public synchronized void addConnectionListener(WebSocketConnectionListener listener) {
        WebSocketConnectionListener[] webSocketConnectionListenerArray = Arrays.copyOf(this.f, this.f.length + 1);
        webSocketConnectionListenerArray[this.f.length] = listener;
        this.f = webSocketConnectionListenerArray;
    }

    @Nonnull
    public List<WebsocketConnection> getAllConnections() {
        return new ArrayList<WebsocketConnection>(this.d.values());
    }

    private static class a
    extends JsonTypeResolver {
        private WebSocketEventHandler b;

        public a(WebSocketEventHandler webSocketEventHandler) {
            this.b = webSocketEventHandler;
        }

        @Override
        protected Type getGenericType(Object obj, Field field) {
            String string;
            WebSocketEvent<?> webSocketEvent;
            if (field.getDeclaringClass() == WebSocketEventData.class && field.getName().endsWith("data") && (webSocketEvent = this.b.a(string = ((WebSocketEventData)obj).getEvent())) != null) {
                return webSocketEvent.a();
            }
            return super.getGenericType(obj, field);
        }
    }
}

