/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class FieldTypeSelect<VALUE>
extends FieldType<VALUE>
implements HasSelectOptions {
    private final HasSelectOptions a;

    public FieldTypeSelect(String key, Supplier<String> displayname, HasSelectOptions selectOptions) {
        super(key, displayname);
        this.a = selectOptions;
    }

    @Override
    public SearchTag createSearchTag(Supplier<String> displayname, @Nonnull FieldTypeFactory fieldTypeFactory) {
        final SearchDataType searchDataType = this.getSearchDataType();
        return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), searchDataType, true, GuidTokenizer.INSTANCE, 100, displayname, true){

            @Override
            @Nonnull
            public Map<? extends Comparable<?>, String> getMapData() {
                if (searchDataType == SearchDataType.IntegerMap) {
                    HashMap hashMap = new HashMap();
                    FieldTypeSelect.this.a.getSelectOptions(true).forEach(selectOption -> hashMap.put(StringFunctions.isEmpty(selectOption.getValue()) ? null : Integer.valueOf(selectOption.getValue()), selectOption.getLabel()));
                    return hashMap;
                }
                HashMap hashMap = new HashMap();
                FieldTypeSelect.this.a.getSelectOptions(true).forEach(selectOption -> hashMap.put(selectOption.getValue(), selectOption.getLabel()));
                return hashMap;
            }

            @Override
            public boolean showAlsoNonMapValues() {
                return searchDataType == SearchDataType.StringMap;
            }
        });
    }

    @Override
    public String getDisplayValue(@Nullable VALUE value) {
        List<SelectOption> list = this.a.getSelectOptions(true);
        String string = StringFunctions.stringValueOf(value);
        for (SelectOption selectOption : list) {
            if (!Objects.equals(string, selectOption.getValue())) continue;
            return selectOption.getLabel();
        }
        if (this.getSearchDataType() == SearchDataType.StringMap) {
            return string;
        }
        return null;
    }

    protected SearchDataType getSearchDataType() {
        return SearchDataType.StringMap;
    }

    @Override
    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        return this.a.getSelectOptions(includeDeleted);
    }

    @Override
    public boolean evaluateCondition(@Nullable String leftValue, @Nullable String rightValue, FieldOperator operator, Set<String> flags) {
        if (operator == FieldOperator.IS_OR_IS_BELOW) {
            SelectOption selectOption;
            if (leftValue != null && (selectOption = this.getSingleOption(leftValue)) != null) {
                leftValue = selectOption.getPath();
            }
            if (rightValue != null && (selectOption = this.getSingleOption(rightValue)) != null) {
                rightValue = selectOption.getPath();
            }
            return operator.a(leftValue, rightValue, flags);
        }
        return operator.a(leftValue, rightValue, flags);
    }

    @Override
    public Set<FieldOperator> getSupportedOperators() {
        return Set.of(FieldOperator.EQUALS, FieldOperator.EQUALS_NOT, FieldOperator.IS_NOT_EMPTY);
    }
}

