/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field;

import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.lib.util.StringFunctions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;

public class FieldUtils {
    @Nonnull
    public static <V> Class<V> getValueTypeViaReflection(@Nonnull Class<?> inputClass) {
        Type type = FieldUtils.getGenericTypeViaReflection(inputClass);
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        throw new IllegalArgumentException("Wrong generic type declaration");
    }

    @Nonnull
    public static Type getGenericTypeViaReflection(@Nonnull Class<?> inputClass) {
        Type[] typeArray;
        while (inputClass.getGenericSuperclass() != null && !(inputClass.getGenericSuperclass() instanceof ParameterizedType)) {
            inputClass = inputClass.getSuperclass();
        }
        Type type = inputClass.getGenericSuperclass();
        if (type instanceof ParameterizedType && (typeArray = ((ParameterizedType)type).getActualTypeArguments()) != null && typeArray.length > 0) {
            return typeArray[0];
        }
        throw new IllegalArgumentException("Wrong generic type declaration");
    }

    public static SelectOptionResult getOptions(String searchTerm, int currentSize, int chunkSize, Map<? extends Object, String> valuesToDisplayNames) {
        return FieldUtils.getOptions(searchTerm, currentSize, chunkSize, valuesToDisplayNames, (selectOption, selectOption2) -> String.CASE_INSENSITIVE_ORDER.compare(selectOption.getLabel(), selectOption2.getLabel()), (object, string) -> new SelectOption(object == null ? null : object.toString(), (String)string));
    }

    public static SelectOptionResult getOptions(String searchTerm, int currentSize, int chunkSize, Map<? extends Object, String> valuesToDisplayNames, Comparator<SelectOption> comparator) {
        return FieldUtils.getOptions(searchTerm, currentSize, chunkSize, valuesToDisplayNames, comparator, (object, string) -> new SelectOption(object == null ? null : object.toString(), (String)string));
    }

    public static SelectOptionResult getOptions(String searchTerm, int currentSize, int chunkSize, Map<? extends Object, String> valuesToDisplayNames, BiFunction<Object, String, SelectOption> selectOptionCreator) {
        return FieldUtils.getOptions(searchTerm, currentSize, chunkSize, valuesToDisplayNames, (selectOption, selectOption2) -> String.CASE_INSENSITIVE_ORDER.compare(selectOption.getLabel(), selectOption2.getLabel()), selectOptionCreator);
    }

    public static SelectOptionResult getOptions(String searchTerm, int currentSize, int chunkSize, Map<? extends Object, String> valuesToDisplayNames, Comparator<SelectOption> comparator, BiFunction<Object, String, SelectOption> selectOptionCreator) {
        List<SelectOption> list = new ArrayList<SelectOption>();
        if (!StringFunctions.isEmpty(searchTerm)) {
            searchTerm = searchTerm.toLowerCase();
        }
        for (Map.Entry<? extends Object, String> entry : valuesToDisplayNames.entrySet()) {
            Object object;
            if (!StringFunctions.isEmpty(searchTerm) && (entry.getValue() == null || !((String)(object = entry.getValue().toLowerCase())).contains(searchTerm))) continue;
            object = selectOptionCreator.apply(entry.getKey(), entry.getValue());
            list.add((SelectOption)object);
        }
        list.sort(comparator);
        int n2 = list.size();
        if (currentSize >= n2) {
            list.clear();
        } else {
            list = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
        }
        return new SelectOptionResult(n2, list);
    }

    public static SelectOptionResult getOptions(String searchTerm, int currentSize, int chunkSize, List<SelectOption> allOptions) {
        List<SelectOption> list = new ArrayList<SelectOption>();
        if (!StringFunctions.isEmpty(searchTerm)) {
            searchTerm = searchTerm.toLowerCase();
        }
        for (SelectOption selectOption : allOptions) {
            if (!StringFunctions.isEmpty(searchTerm) && (selectOption.getLabel() == null || !selectOption.getLabel().toLowerCase().contains(searchTerm))) continue;
            list.add(selectOption);
        }
        int n2 = list.size();
        if (currentSize >= n2) {
            list.clear();
        } else {
            list = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
        }
        return new SelectOptionResult(n2, list);
    }
}

