/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.setup;

import com.inet.config.setup.ConfigInfo;
import com.inet.config.setup.FullConfigurationNameParser;
import java.util.Optional;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public class ConfigurationApplicabilityChecker {
    private final FullConfigurationNameParser a;

    public ConfigurationApplicabilityChecker(FullConfigurationNameParser cfgNameParser) {
        if (cfgNameParser == null) {
            throw new IllegalArgumentException("cfgNameParser must not be null");
        }
        this.a = cfgNameParser;
    }

    public Optional<ConfigInfo> parseIfCanRunWithThatConfig(String configFullName, IntPredicate isScopeWriteablePredicate) {
        if (isScopeWriteablePredicate == null) {
            throw new IllegalArgumentException("isScopeWriteablePredicate must not be null");
        }
        Predicate<ConfigInfo> predicate = configInfo -> 4 != configInfo.scope() && isScopeWriteablePredicate.test(configInfo.scope());
        return this.a.parseFullConfigName(configFullName).filter(predicate);
    }
}

