/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.provider;

import com.inet.config.ConfigurationManager;
import com.inet.config.provider.ConfigurationProvider;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.core.CoreComponentsStructureProvider;
import com.inet.config.structure.core.CoreSecurityStructureProvider;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static List<ConfigStructureProvider> a;
    private List<ConfigStructureProvider> b;

    @Override
    public ConfigurationManager getConfigurationManager() {
        return ConfigurationManager.getInstance();
    }

    @Override
    public List<ConfigStructureProvider> getStructureProviders() {
        List<ConfigStructureProvider> list = this.b;
        if (list == null) {
            this.b = list = DefaultConfigurationProvider.getAllStructureProviders().stream().filter(configStructureProvider -> SystemPermissionChecker.checkAccess(configStructureProvider.getRequiredPermissions())).collect(Collectors.toList());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static List<ConfigStructureProvider> getAllStructureProviders() {
        List<ConfigStructureProvider> list = a;
        if (list != null) return list;
        Class<ConfigStructure> clazz = ConfigStructure.class;
        synchronized (ConfigStructure.class) {
            if (a != null) return a;
            list = new ArrayList<ConfigStructureProvider>();
            List<ConfigStructureProvider> list2 = ServerPluginManager.getInstance().get(ConfigStructureProvider.class);
            for (ConfigStructureProvider configStructureProvider : list2) {
                if (configStructureProvider.getApplicationKey() != null) continue;
                list.add(configStructureProvider);
            }
            list.add(0, CoreSystemStructureProvider.INSTANCE);
            list.add(1, CoreSecurityStructureProvider.INSTANCE);
            list.add(2, new CoreComponentsStructureProvider());
            a = list;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return list;
        }
    }

    @Override
    public String getContextPath() {
        return null;
    }

    @Override
    public String getApplicationKey() {
        return null;
    }

    @Override
    public String getRecoveryConfiguration() {
        return ConfigurationManager.getRecoveryConfiguration();
    }

    @Override
    public boolean isRecoveryMode() {
        return ConfigurationManager.isRecoveryMode();
    }

    @Override
    public String getScopeName(int scope) {
        return ConfigurationManager.getScopeName(scope);
    }

    @Override
    public boolean isReadable(int scope) {
        return ConfigurationManager.isReadable(scope);
    }

    @Override
    public boolean isWriteable(int scope) {
        return ConfigurationManager.isWriteable(scope);
    }
}

