/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.base;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.RemoteLoginProcessor;
import com.inet.error.BaseErrorCode;
import com.inet.http.ClientMessageException;
import com.inet.http.error.ServletErrorHandler;
import com.inet.plugin.ApplicationDescription;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Nonnull;

@InternalApi
public abstract class BasicLoginProcessor
extends RemoteLoginProcessor {
    private static final Charset a = StandardCharsets.UTF_8;
    private static final Charset b = StandardCharsets.ISO_8859_1;
    private static String c;

    protected BasicLoginProcessor(AuthenticationDescription description) {
        super(description);
    }

    @Override
    public void requestLoginData(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (c == null) {
            c = ApplicationDescription.get().getApplicationName();
        }
        httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + c + "\"");
        if (LOGGER.isDebug()) {
            LOGGER.debug("WWW-Authenticate: Basic realm=\"" + c + "\"");
        }
        httpResponse.setStatus(401);
        httpResponse = new HttpServletResponseWrapper(httpResponse){

            @Override
            public void addHeader(String name, String value) {
            }

            @Override
            public void setStatus(int sc) {
            }
        };
        ServletErrorHandler.sendErrorPage(httpRequest, httpResponse, new ClientMessageException(BaseErrorCode.UserLoginRequired.getMsg("")));
    }

    private static String[] a(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("Authorization");
        if (string == null) {
            return null;
        }
        if (!string.startsWith("Basic ")) {
            LOGGER.error("Wrong authorization header: " + string);
            return null;
        }
        return BasicLoginProcessor.a(string);
    }

    static String[] a(@Nonnull String string) {
        String[] stringArray;
        string = string.substring(6);
        byte[] byArray = Base64.getDecoder().decode(string);
        string = new String(byArray, a);
        if (string.contains("\ufffd")) {
            string = new String(byArray, b);
        }
        if ((stringArray = string.split(":", 2)).length != 2) {
            LOGGER.error("Invalid username:password in Authorization header: " + string);
            return null;
        }
        return stringArray;
    }

    @Override
    public boolean transferClientLoginData(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (this.getLoginID() != null) {
            return true;
        }
        String[] stringArray = BasicLoginProcessor.a(httpRequest);
        if (stringArray == null) {
            return true;
        }
        try {
            return this.transferClientLoginData(stringArray[0], stringArray[1], httpRequest, httpResponse);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }

    protected abstract boolean transferClientLoginData(@Nonnull String var1, @Nonnull String var2, @Nonnull HttpServletRequest var3, @Nonnull HttpServletResponse var4) throws Exception;
}

