/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.RemoteLoginProcessor;
import com.inet.authentication.base.TwoFactorManager;
import com.inet.authentication.stayloggedin.StayLoggedInHandler;
import com.inet.http.PluginServlet;
import com.inet.http.error.ServletErrorHandler;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class FormLoginServlet
extends HttpServlet
implements PluginServlet {
    private static TwoFactorManager a;

    @Override
    @Nonnull
    public String getPathSpec() {
        return "/formlogin";
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        a = ServerPluginManager.getInstance().getOptionalInstance(TwoFactorManager.class);
    }

    @Override
    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="Validation occur in ServletUtils.createRedirectURL")
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String string = ServletUtils.getRequestPage(request);
        if (string == null) {
            ServletException servletException = new ServletException("Do not call this URL directly.");
            ServletErrorHandler.sendErrorPage(request, response, servletException);
            return;
        }
        HttpSession httpSession = request.getSession(true);
        Object object = httpSession.getAttribute("WebUserInfo");
        boolean bl = false;
        RemoteLoginProcessor remoteLoginProcessor = null;
        if (!(object instanceof RemoteLoginProcessor) || !((RemoteLoginProcessor)object).supportsFormLogin()) {
            ServletException servletException = new ServletException("Session lost. You need to enable cookies.");
            ServletErrorHandler.sendErrorPage(request, response, servletException);
            return;
        }
        remoteLoginProcessor = (RemoteLoginProcessor)object;
        bl = remoteLoginProcessor.transferFormLoginData(request, response);
        if (bl) {
            String string2;
            int n2 = string.indexOf(63);
            if (n2 > 0) {
                string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
                request = new HttpServletRequestWrapper(request){

                    @Override
                    public String getQueryString() {
                        return string2;
                    }
                };
            }
            string2 = ServletUtils.createRedirectURL(request, string);
            response.sendRedirect(string2);
            FormLoginServlet.getUserAccountIDInternal(remoteLoginProcessor, request, response);
        }
    }

    public static GUID getUserAccountIDInternal(@Nonnull LoginProcessor login, @Nullable HttpServletRequest request, @Nullable HttpServletResponse response) {
        return login.a(userAccount -> {
            if (login.getClass() == BaseUserManager.NonSessionLoginProcessor.class) {
                UserManager.getInstance().setCurrentUserAccountID(userAccount.getID());
                return true;
            }
            if (a != null && !a.check((UserAccount)userAccount, request, response)) {
                return false;
            }
            UserManager.getInstance().setCurrentUserAccountID(userAccount.getID());
            if (request != null && response != null) {
                String string;
                AuthenticationDescription authenticationDescription = login.getAuthenticationDescription();
                String string2 = string = authenticationDescription != null ? authenticationDescription.getName() : login.getLoginSource();
                if (string != null) {
                    StayLoggedInHandler.handleCookie(string, request, response, true);
                }
            }
            return true;
        });
    }
}

