/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.dynamodb;

import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.io.ChunkedInputStream;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.util.IOFunctions;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.dynamodb.DynamoDbPersistence;
import com.inet.persistence.dynamodb.DynamoDbUtils;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.persistence.spi.util.DatabaseRandomAccessRead;
import com.inet.shared.utils.WeakValueMap;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;

class DynamoDbPersistenceEntry
extends PersistenceEntry {
    private static final WeakValueMap<String, DynamoDbPersistenceEntry> REFS_FOR_DELETE = new WeakValueMap(new ConcurrentHashMap());
    private static final String TABLE_NAME = "files";
    @Nonnull
    private static String tableName = "files";
    private static final String PK = "pk";
    private static final String PARENT = "parent";
    private static final String NAME = "filename";
    private static final String LENGTH = "length";
    private static final String UPLOAD_DATE = "uploadDate";
    private static final String DATA = "filedata";
    private static final String CHUNK_ID = "chunkId";
    private static final String PATH = "filepath";
    private static final String X = "x";
    private static final AttributeValue X_VAL = AttributeValue.fromS((String)"x");
    private static final String IDX = "idx";
    private static final String IDX_PATH = "idx_path";
    private static final int CHUNK_SIZE = 250000;
    private static final String DELIMITER = ":";
    @Nonnull
    private final String path;
    private Map<String, AttributeValue> attrs;

    DynamoDbPersistenceEntry(String path) {
        this.path = PersistenceHelper.checkName((String)path);
    }

    DynamoDbPersistenceEntry(String path, @Nonnull Map<String, AttributeValue> attr) {
        this(path);
        this.attrs = attr;
        this.putReference();
    }

    static void createTable(DynamoDbClient client) {
        try {
            tableName = DynamoDbPersistence.getTablePrefix() + TABLE_NAME;
            AttributeDefinition[] attrs = new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(PK).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(PARENT).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(NAME).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(PATH).attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName(X).attributeType(ScalarAttributeType.S).build()};
            KeySchemaElement pk = (KeySchemaElement)KeySchemaElement.builder().attributeName(PK).keyType(KeyType.HASH).build();
            KeySchemaElement parent = (KeySchemaElement)KeySchemaElement.builder().attributeName(PARENT).keyType(KeyType.HASH).build();
            KeySchemaElement name = (KeySchemaElement)KeySchemaElement.builder().attributeName(NAME).keyType(KeyType.RANGE).build();
            KeySchemaElement x = (KeySchemaElement)KeySchemaElement.builder().attributeName(X).keyType(KeyType.HASH).build();
            KeySchemaElement path = (KeySchemaElement)KeySchemaElement.builder().attributeName(PATH).keyType(KeyType.RANGE).build();
            Projection projection = (Projection)Projection.builder().projectionType(ProjectionType.INCLUDE).nonKeyAttributes(new String[]{CHUNK_ID}).build();
            GlobalSecondaryIndex idx = (GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName(IDX).projection(projection).keySchema(new KeySchemaElement[]{parent, name}).build();
            projection = (Projection)Projection.builder().projectionType(ProjectionType.KEYS_ONLY).build();
            GlobalSecondaryIndex idxPath = (GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName(IDX_PATH).projection(projection).keySchema(new KeySchemaElement[]{x, path}).build();
            CreateTableRequest tableRequest = (CreateTableRequest)CreateTableRequest.builder().attributeDefinitions(attrs).keySchema(new KeySchemaElement[]{pk, name}).globalSecondaryIndexes(new GlobalSecondaryIndex[]{idx, idxPath}).billingMode(BillingMode.PAY_PER_REQUEST).tableName(tableName).build();
            client.createTable(tableRequest);
            DynamoDbWaiter dbWaiter = client.waiter();
            dbWaiter.waitUntilTableExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build());
            PersistenceLogger.LOGGER.debug((Object)("Table '" + tableName + "' created"));
        }
        catch (ResourceInUseException ex) {
            PersistenceLogger.LOGGER.debug((Object)("Table '" + tableName + "' already exists"));
        }
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public DynamoDbPersistenceEntry resolve(@Nonnull String child) throws NullPointerException, IllegalArgumentException {
        String childPath = PersistenceHelper.resolve((String)this.path, (String)child);
        return new DynamoDbPersistenceEntry(childPath);
    }

    @Nullable
    public DynamoDbPersistenceEntry getParent() {
        String parentPath = PersistenceHelper.getParentPath((String)this.path);
        if (parentPath == null) {
            return null;
        }
        return new DynamoDbPersistenceEntry(parentPath);
    }

    @Nullable
    public RandomAccessRead getRandomAccessRead() {
        Map<String, AttributeValue> attrs = this.getAttributes();
        if (attrs != null) {
            AttributeValue data = attrs.get(DATA);
            if (data != null) {
                return RandomAccessRead.wrap((byte[])data.b().asByteArrayUnsafe());
            }
            return new DynamoDbRandomAccessRead(attrs);
        }
        return null;
    }

    public boolean exists() {
        return this.getAttributes() != null;
    }

    @Nonnull
    public List<PersistenceEntry> getChildren() {
        QueryRequest.Builder builder = DynamoDbPersistenceEntry.getChildrenBuilder(this.path);
        ArrayList<PersistenceEntry> result = new ArrayList<PersistenceEntry>();
        DynamoDbUtils.iterate(builder, item -> {
            String parent = ((AttributeValue)item.get(PARENT)).s();
            String name = ((AttributeValue)item.get(NAME)).s();
            String path = PersistenceHelper.resolve((String)parent, (String)name);
            result.add(new DynamoDbPersistenceEntry(path, (Map<String, AttributeValue>)item));
        });
        return result;
    }

    @Nonnull
    public Iterable<PersistenceEntry> search(@Nonnull String pattern) {
        return () -> {
            Object base = this.path.length() == 1 ? this.path : this.path + "/";
            final Pattern regex = Pattern.compile(PersistenceHelper.searchPatternToRegex((String)((String)base + pattern)));
            HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>(2);
            queryParams.put(":x", X_VAL);
            queryParams.put(":path", AttributeValue.fromS((String)base));
            final QueryRequest.Builder builder = QueryRequest.builder().tableName(tableName).indexName(IDX_PATH).keyConditionExpression("x=:x AND begins_with(filepath,:path)").projectionExpression("pk,filepath").expressionAttributeValues(queryParams);
            return new Iterator<PersistenceEntry>(){
                private ArrayDeque<String> list = new ArrayDeque();
                private Map<String, AttributeValue> lastEvaluatedKey;

                @Override
                public boolean hasNext() {
                    while (this.list.isEmpty() && (this.lastEvaluatedKey == null || !this.lastEvaluatedKey.isEmpty())) {
                        QueryRequest request = (QueryRequest)builder.build();
                        QueryResponse response = DynamoDbPersistence.getClient().query(request);
                        List items = response.items();
                        for (Map item : items) {
                            String pk = ((AttributeValue)item.get(DynamoDbPersistenceEntry.PK)).s();
                            String path = ((AttributeValue)item.get(DynamoDbPersistenceEntry.PATH)).s();
                            if (!path.startsWith(pk) || !regex.matcher(path).matches()) continue;
                            this.list.add(path);
                        }
                        this.lastEvaluatedKey = response.lastEvaluatedKey();
                        builder.exclusiveStartKey(this.lastEvaluatedKey);
                    }
                    return !this.list.isEmpty();
                }

                @Override
                public PersistenceEntry next() {
                    if (this.hasNext()) {
                        return new DynamoDbPersistenceEntry(this.list.pop());
                    }
                    throw new NoSuchElementException();
                }
            };
        };
    }

    @Nullable
    public String getString() {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void setString(@Nonnull String value) throws NullPointerException {
        this.setBytes(value.getBytes(StandardCharsets.UTF_8));
    }

    public byte @Nullable [] getBytes() {
        try {
            InputStream inputStream = this.getInputStream();
            if (inputStream == null) {
                return null;
            }
            return IOFunctions.readBytes((InputStream)inputStream);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setBytes(byte @Nonnull [] value) throws NullPointerException {
        this.mkDirs();
        this.save(value);
    }

    public void setInputStream(@Nonnull InputStream value) throws NullPointerException {
        try (OutputStream output = this.getOutputStream();){
            IOFunctions.copyData((InputStream)value, (OutputStream)output);
        }
        catch (IOException ex) {
            ErrorCode.throwAny((Throwable)ex);
        }
    }

    @Nullable
    public InputStream getInputStream() {
        Map<String, AttributeValue> item = this.getAttributes();
        if (item == null) {
            return null;
        }
        AttributeValue value = item.get(DATA);
        if (value != null) {
            return new FastByteArrayInputStream(value.b().asByteArrayUnsafe());
        }
        value = item.get(CHUNK_ID);
        if (value == null) {
            return null;
        }
        final String chunkId = value.s();
        return new ChunkedInputStream(){
            private final long length;
            private final Map<String, AttributeValue> key;
            private final String parent;
            private long size;
            private long chunk;
            {
                this.length = DynamoDbPersistenceEntry.this.size();
                this.key = new HashMap<String, AttributeValue>(2);
                this.parent = DynamoDbPersistenceEntry.getParentKeyValue(DynamoDbPersistenceEntry.this.path);
                String name = DynamoDbPersistenceEntry.getNameKeyValue(DynamoDbPersistenceEntry.this.path);
                this.key.put(DynamoDbPersistenceEntry.NAME, AttributeValue.fromS((String)name));
            }

            protected byte @Nullable [] nextChunk() {
                this.key.put(DynamoDbPersistenceEntry.PK, AttributeValue.fromS((String)(chunkId + DynamoDbPersistenceEntry.DELIMITER + this.chunk++)));
                Map<String, AttributeValue> item = DynamoDbUtils.getItem(tableName, this.key, DynamoDbPersistenceEntry.DATA);
                AttributeValue value = item.get(DynamoDbPersistenceEntry.DATA);
                if (value != null) {
                    byte[] bytes = value.b().asByteArrayUnsafe();
                    this.size += (long)bytes.length;
                    return bytes;
                }
                if (this.size != this.length) {
                    ErrorCode.throwAny((Throwable)new EOFException("Unexpected end of stream. (" + this.size + "/" + this.length + ")"));
                }
                return null;
            }
        };
    }

    @Nonnull
    public OutputStream getOutputStream() {
        this.mkDirs();
        return new FastByteArrayOutputStream(){
            private boolean isClosed;

            public void write(int datum) {
                if (this.isClosed) {
                    ErrorCode.throwAny((Throwable)new IOException("Stream closed"));
                }
                super.write(datum);
            }

            public void write(byte[] data, int offset, int length) {
                if (this.isClosed) {
                    ErrorCode.throwAny((Throwable)new IOException("Stream closed"));
                }
                super.write(data, offset, length);
            }

            public void close() {
                if (!this.isClosed) {
                    this.isClosed = true;
                    byte[] data = this.toByteArray();
                    DynamoDbPersistenceEntry.this.save(data);
                }
            }
        };
    }

    private void save(byte @Nullable [] data) {
        AttributeValue oldChunkID;
        String parent = DynamoDbPersistenceEntry.getParentKeyValue(this.path);
        String name = DynamoDbPersistenceEntry.getNameKeyValue(this.path);
        Map<String, AttributeValue> attrs = this.attrs;
        if (attrs != null) {
            oldChunkID = attrs.get(CHUNK_ID);
        } else {
            attrs = DynamoDbUtils.getItem(tableName, this.getItemKey(), CHUNK_ID);
            oldChunkID = attrs.get(CHUNK_ID);
        }
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        AttributeValue parentAttr = AttributeValue.fromS((String)parent);
        item.put(PK, parentAttr);
        item.put(PARENT, parentAttr);
        item.put(NAME, AttributeValue.fromS((String)name));
        item.put(X, X_VAL);
        item.put(PATH, AttributeValue.fromS((String)this.path));
        item.put(UPLOAD_DATE, AttributeValue.fromN((String)String.valueOf(System.currentTimeMillis())));
        if (data != null) {
            item.put(LENGTH, AttributeValue.fromN((String)String.valueOf(data.length)));
            if (data.length >= 300000) {
                this.saveChunks(item, parent, data);
            } else {
                item.put(DATA, AttributeValue.fromB((SdkBytes)SdkBytes.fromByteArrayUnsafe((byte[])data)));
            }
        }
        DynamoDbUtils.putItem(tableName, item);
        if (oldChunkID != null) {
            DefaultTimerTask cleanup = new DefaultTimerTask(){

                public void runImpl() throws Throwable {
                    ForkJoinPool.commonPool().execute(() -> {
                        String chunkId = DynamoDbUtils.getS(DynamoDbPersistenceEntry.this.getAttributes(), DynamoDbPersistenceEntry.CHUNK_ID);
                        if (chunkId == null) {
                            chunkId = "any";
                        }
                        HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>(3);
                        queryParams.put(":parent", AttributeValue.fromS((String)DynamoDbPersistenceEntry.getParentKeyValue(DynamoDbPersistenceEntry.this.path)));
                        queryParams.put(":name", AttributeValue.fromS((String)DynamoDbPersistenceEntry.getNameKeyValue(DynamoDbPersistenceEntry.this.path)));
                        queryParams.put(":chunk", AttributeValue.fromS((String)chunkId));
                        QueryRequest.Builder builder = QueryRequest.builder().tableName(tableName).indexName(DynamoDbPersistenceEntry.IDX).projectionExpression("pk,filename").keyConditionExpression("parent=:parent AND filename=:name").filterExpression("attribute_exists(chunkId) AND chunkId<>:chunk").expressionAttributeValues(queryParams);
                        DynamoDbUtils.batchDelete(builder);
                    });
                }
            };
            DefaultTimer.getInstance().schedule(cleanup, 100L);
        }
        this.attrs = item;
        this.putReference();
    }

    private void saveChunks(HashMap<String, AttributeValue> mainItem, String parent, byte @Nonnull [] data) {
        PutItemRequest.Builder builder = PutItemRequest.builder().tableName(tableName);
        String chunkId = GUID.generateNew().toString();
        AttributeValue chunkIdAttr = AttributeValue.fromS((String)chunkId);
        mainItem.put(CHUNK_ID, chunkIdAttr);
        AttributeValue name = mainItem.get(NAME);
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        item.put(PARENT, AttributeValue.fromS((String)parent));
        item.put(NAME, name);
        item.put(CHUNK_ID, chunkIdAttr);
        item.put(X, X_VAL);
        item.put(PATH, AttributeValue.fromS((String)this.path));
        int length = data.length;
        int chunks = (length + 250000 - 1) / 250000;
        for (int i = 0; i < chunks; ++i) {
            item.put(PK, AttributeValue.fromS((String)(chunkId + DELIMITER + i)));
            int from = 250000 * i;
            int to = i == chunks - 1 ? length : from + 250000;
            item.put(DATA, AttributeValue.fromB((SdkBytes)SdkBytes.fromByteArrayUnsafe((byte[])Arrays.copyOfRange(data, from, to))));
            DynamoDbPersistence.getClient().putItem((PutItemRequest)builder.item(item).build());
        }
    }

    public long size() {
        AttributeValue size;
        Map<String, AttributeValue> attrs = this.getAttributes();
        if (attrs != null && (size = attrs.get(LENGTH)) != null) {
            return Long.parseLong(size.n());
        }
        return 0L;
    }

    @Nonnull
    private QueryRequest.Builder[] getChildrenTreeBuilders() {
        HashMap<String, AttributeValue> queryParams = new HashMap<String, AttributeValue>(2);
        queryParams.put(":x", X_VAL);
        QueryRequest.Builder builder = QueryRequest.builder().tableName(tableName).indexName(IDX_PATH).keyConditionExpression("x=:x").projectionExpression("pk,filename").expressionAttributeValues(queryParams);
        if (this.path.length() == 1) {
            return new QueryRequest.Builder[]{builder};
        }
        QueryRequest.Builder[] result = new QueryRequest.Builder[2];
        queryParams.put(":path", AttributeValue.fromS((String)this.path));
        builder.keyConditionExpression("x=:x AND filepath=:path").expressionAttributeValues(queryParams);
        result[0] = builder;
        builder = (QueryRequest.Builder)builder.copy();
        queryParams.put(":path", AttributeValue.fromS((String)(this.path + "/")));
        builder.keyConditionExpression("x=:x AND begins_with(filepath,:path)").expressionAttributeValues(queryParams);
        result[1] = builder;
        return result;
    }

    public void deleteTree() {
        DynamoDbUtils.batchDelete(this.getChildrenTreeBuilders());
        for (DynamoDbPersistenceEntry entry : REFS_FOR_DELETE.values()) {
            if (entry == null) continue;
            entry.attrs = null;
        }
        this.deleteParentIfEmpty();
    }

    public void deleteValue() {
        if (DynamoDbPersistenceEntry.hasChildren(this.path)) {
            this.save(null);
        } else {
            this.deleteValueImpl();
            this.deleteParentIfEmpty();
        }
    }

    private void deleteValueImpl() {
        Map<String, AttributeValue> key = this.getItemKey();
        DynamoDbUtils.deleteItem(tableName, key);
        DynamoDbPersistenceEntry entry = (DynamoDbPersistenceEntry)((Object)REFS_FOR_DELETE.get((Object)this.path));
        if (entry != null) {
            entry.attrs = null;
        }
    }

    public long lastModified() {
        AttributeValue size;
        Map<String, AttributeValue> attrs = this.getAttributes();
        if (attrs != null && (size = attrs.get(UPLOAD_DATE)) != null) {
            return Long.parseLong(size.n());
        }
        return 0L;
    }

    public void moveTo(@Nonnull String newPath) throws IllegalStateException, IllegalArgumentException {
        if (this.path.length() <= 1) {
            throw new IllegalStateException("Persistence root can't moved");
        }
        if ((newPath = PersistenceHelper.checkName((String)PersistenceHelper.resolve((String)this.path, (String)newPath))).length() <= 1) {
            throw new IllegalArgumentException("can not moved to the root");
        }
        DynamoDbPersistenceEntry newEntry = this.resolve(newPath);
        if (newEntry.exists()) {
            throw new IllegalStateException("target already exists");
        }
        if (newPath.startsWith(this.path + "/")) {
            throw new IllegalArgumentException("You can't move to a sub folder");
        }
        newEntry.mkDirs();
        String newTarget = DynamoDbPersistenceEntry.getParentKeyValue(newPath);
        String newName = DynamoDbPersistenceEntry.getNameKeyValue(newPath);
        AttributeValue newNameAttr = AttributeValue.fromS((String)newName);
        String oldTarget = DynamoDbPersistenceEntry.getParentKeyValue(this.path);
        DynamoDbClient client = DynamoDbPersistence.getClient();
        block0: for (QueryRequest.Builder builder : this.getChildrenTreeBuilders()) {
            builder.projectionExpression("pk,filename,filepath");
            while (true) {
                QueryResponse response = client.query((QueryRequest)builder.build());
                List items = response.items();
                for (HashMap<String, AttributeValue> key : items) {
                    DynamoDbPersistenceEntry entry;
                    boolean thisEntry;
                    Object newParent;
                    key = new HashMap<String, AttributeValue>(key);
                    String oldFilePath = ((AttributeValue)key.remove(PATH)).s();
                    String oldParent = DynamoDbPersistenceEntry.getParentKeyValue(oldFilePath);
                    String oldName = ((AttributeValue)key.get(NAME)).s();
                    if (oldParent.equals(oldTarget)) {
                        newParent = newTarget;
                        thisEntry = true;
                    } else {
                        newParent = newPath + oldParent.substring(this.path.length());
                        thisEntry = false;
                    }
                    AttributeValue parent = AttributeValue.fromS((String)newParent);
                    String newFilePath = (String)newParent + "/" + newName;
                    boolean isChunk = ((AttributeValue)key.get(PK)).s().contains(DELIMITER);
                    if (!thisEntry && isChunk) {
                        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>(2);
                        values.put(":parent", parent);
                        values.put(":path", AttributeValue.fromS((String)newFilePath));
                        UpdateItemRequest.Builder updateBuilder = UpdateItemRequest.builder().tableName(tableName).key(key).updateExpression("SET parent=:parent,filepath=:path").expressionAttributeValues(values);
                        client.updateItem((UpdateItemRequest)updateBuilder.build());
                    } else {
                        Map<String, AttributeValue> item = DynamoDbUtils.getItem(tableName, key);
                        if (item.isEmpty()) continue;
                        item = new HashMap<String, AttributeValue>(item);
                        if (!isChunk) {
                            item.put(PK, parent);
                        }
                        item.put(PARENT, parent);
                        item.put(PATH, AttributeValue.fromS((String)newFilePath));
                        if (thisEntry) {
                            item.put(NAME, newNameAttr);
                        }
                        DynamoDbUtils.putItem(tableName, item);
                        DynamoDbUtils.deleteItem(tableName, key);
                    }
                    if ((entry = (DynamoDbPersistenceEntry)((Object)REFS_FOR_DELETE.get((Object)(oldParent + "/" + oldName)))) == null) continue;
                    entry.attrs = null;
                }
                Map lastEvaluatedKey = response.lastEvaluatedKey();
                if (lastEvaluatedKey.isEmpty()) continue block0;
                builder.exclusiveStartKey(lastEvaluatedKey);
            }
        }
        this.attrs = null;
        newEntry.attrs = null;
    }

    @Nonnull
    private static String getParentKeyValue(@Nonnull String path) {
        String parent = PersistenceHelper.getParentPath((String)path);
        return parent == null ? DELIMITER : parent;
    }

    @Nonnull
    private static String getNameKeyValue(@Nonnull String path) {
        String name = PersistenceHelper.getName((String)path);
        return name.isEmpty() ? DELIMITER : name;
    }

    @Nonnull
    private static QueryRequest.Builder getChildrenBuilder(@Nonnull String path) {
        return QueryRequest.builder().tableName(tableName).keyConditionExpression("pk=:parent").expressionAttributeValues(Collections.singletonMap(":parent", AttributeValue.fromS((String)path)));
    }

    private static boolean hasChildren(@Nonnull String path) {
        QueryRequest request = (QueryRequest)DynamoDbPersistenceEntry.getChildrenBuilder(path).select(Select.COUNT).build();
        int count = DynamoDbPersistence.getClient().query(request).count();
        return count > 0;
    }

    @Nonnull
    private Map<String, AttributeValue> getItemKey() {
        String parent = DynamoDbPersistenceEntry.getParentKeyValue(this.path);
        String name = DynamoDbPersistenceEntry.getNameKeyValue(this.path);
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>(2);
        key.put(PK, AttributeValue.fromS((String)parent));
        key.put(NAME, AttributeValue.fromS((String)name));
        return key;
    }

    @Nonnull
    private Map<String, AttributeValue> getItemValue() {
        return DynamoDbUtils.getItem(tableName, this.getItemKey());
    }

    @Nullable
    private Map<String, AttributeValue> getAttributes() {
        Map<String, AttributeValue> attrs = this.attrs;
        if (attrs == null) {
            Map<String, AttributeValue> item = this.getItemValue();
            if (!item.isEmpty()) {
                this.attrs = attrs = item;
            }
            this.putReference();
        }
        return attrs;
    }

    private void mkDirs() {
        DynamoDbPersistenceEntry entry;
        String parent = PersistenceHelper.getParentPath((String)this.path);
        while (parent != null && !(entry = new DynamoDbPersistenceEntry(parent)).exists()) {
            entry.save(null);
            parent = PersistenceHelper.getParentPath((String)parent);
        }
    }

    private void deleteParentIfEmpty() {
        String current = this.path;
        String parentPath;
        while ((parentPath = PersistenceHelper.getParentPath((String)current)) != null) {
            if (DynamoDbPersistenceEntry.hasChildren(parentPath)) {
                return;
            }
            DynamoDbPersistenceEntry entry = new DynamoDbPersistenceEntry(parentPath);
            if (!entry.exists()) {
                return;
            }
            if (entry.size() > 0L) {
                return;
            }
            entry.deleteValueImpl();
            current = parentPath;
        }
        return;
    }

    private void putReference() {
        DynamoDbPersistenceEntry entry = (DynamoDbPersistenceEntry)((Object)REFS_FOR_DELETE.put((Object)this.path, (Object)this));
        if (entry != null && entry != this) {
            entry.attrs = null;
        }
    }

    private class DynamoDbRandomAccessRead
    extends DatabaseRandomAccessRead<Map<String, AttributeValue>> {
        public DynamoDbRandomAccessRead(Map<String, AttributeValue> attrs) {
            super(attrs, Long.parseLong(attrs.get(DynamoDbPersistenceEntry.LENGTH).n()), 250000);
        }

        @Override
        protected byte[] getChunk(int chunkIdx) throws EOFException {
            byte[] chunk = (byte[])this.getCache().get((Object)chunkIdx);
            if (chunk == null) {
                Map attrs = (Map)this.getChunkId();
                String chunkId = ((AttributeValue)attrs.get(DynamoDbPersistenceEntry.CHUNK_ID)).s();
                HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
                key.put(DynamoDbPersistenceEntry.PK, AttributeValue.fromS((String)(chunkId + DynamoDbPersistenceEntry.DELIMITER + chunkIdx)));
                key.put(DynamoDbPersistenceEntry.NAME, (AttributeValue)attrs.get(DynamoDbPersistenceEntry.NAME));
                Map<String, AttributeValue> item = DynamoDbUtils.getItem(tableName, key, DynamoDbPersistenceEntry.DATA);
                if (item.isEmpty()) {
                    throw new EOFException("Missing Chunk: " + chunkIdx);
                }
                chunk = item.get(DynamoDbPersistenceEntry.DATA).b().asByteArrayUnsafe();
                this.getCache().put((Object)chunkIdx, (Object)chunk);
            }
            return chunk;
        }
    }
}

