/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.annotations.InternalApi;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Version
implements Comparable<Version> {
    public static final boolean IS_TECHNICAL_BUILD = false;
    private String version;
    private int major;
    private int minor;
    private int build;
    private int microBuild;
    @Nonnull
    private static Version javaVersion = new Version(AccessController.doPrivileged(() -> System.getProperty("java.version")));

    public Version(String version) {
        if (version == null) {
            this.version = String.valueOf(version);
            return;
        }
        this.version = version;
        version = ((String)version).trim() + ".";
        int part = 0;
        int idx = 0;
        for (int i = 0; i < ((String)version).length(); ++i) {
            int value;
            char ch = ((String)version).charAt(i);
            if (Character.isDigit(ch)) continue;
            String str = ((String)version).substring(idx, i);
            try {
                value = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                value = str.isEmpty() && ((String)version).substring(i).matches("\\$\\{.+\\}.*?") ? Integer.MAX_VALUE : 0;
            }
            switch (part) {
                case 0: {
                    this.major = value;
                    break;
                }
                case 1: {
                    this.minor = value;
                    break;
                }
                case 2: {
                    this.build = value;
                    break;
                }
                case 3: {
                    this.microBuild = value;
                    return;
                }
            }
            ++part;
            idx = i + 1;
            if (ch == '.') continue;
            return;
        }
    }

    public boolean isHigherOrEquals(Version ref) {
        return this.compareTo(ref) >= 0;
    }

    public boolean isHigherThan(Version ref) {
        return this.compareTo(ref) > 0;
    }

    @Override
    public int compareTo(Version ref) {
        if (this.major != ref.major) {
            return this.major - ref.major;
        }
        if (this.minor != ref.minor) {
            return this.minor - ref.minor;
        }
        if (this.build != ref.build) {
            return this.build - ref.build;
        }
        return this.microBuild - ref.microBuild;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    public int getMicroBuild() {
        return this.microBuild;
    }

    @Nonnull
    public String toString() {
        return this.version;
    }

    @Nonnull
    public static Version getJavaVersion() {
        return javaVersion;
    }

    @Nonnull
    public static String getTechnicalBuildSuffix() {
        Date expirationDate = Version.getTechnicalBuildExpirationDate();
        if (expirationDate != null) {
            return " Technical Build (valid until " + DateFormat.getDateInstance(3).format(expirationDate) + ")";
        }
        return "";
    }

    @Nullable
    public static Date getTechnicalBuildExpirationDate() {
        return null;
    }
}

