/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

public class Msg {
    private static ResourceBundle getResourceBundle() {
        ResourceBundle languageResourcesTmp;
        try {
            languageResourcesTmp = ResourceBundle.getBundle(Msg.class.getPackage().getName() + ".LanguageResources");
        }
        catch (MissingResourceException e) {
            languageResourcesTmp = null;
        }
        return languageResourcesTmp;
    }

    public static String getMsg(String msgID) {
        Object msg;
        try {
            msg = Msg.getResourceBundle().getString(msgID);
        }
        catch (Throwable e) {
            msg = "$" + msgID + "$";
        }
        return msg;
    }

    public static String getMsg(@Nonnull String msgID, Object ... msgParameter) {
        String msg;
        try {
            ResourceBundle bundle = Msg.getResourceBundle();
            msg = bundle.containsKey(msgID) ? bundle.getString(msgID) : Msg.getLabelFallback(msgID, msgParameter);
        }
        catch (Throwable e) {
            msg = Msg.getLabelFallback(msgID, msgParameter);
        }
        try {
            msg = MessageFormat.format(msg, msgParameter);
        }
        catch (Throwable t) {
            StringBuffer msgBuf = new StringBuffer();
            msgBuf.append('$').append(t.toString()).append('_').append(msgID).append('(');
            for (int i = 0; i < msgParameter.length; ++i) {
                if (i > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append(msgParameter[i]);
            }
            msgBuf.append(')').append('$');
            msg = msgBuf.toString();
        }
        return msg;
    }

    private static String getLabelFallback(@Nonnull String msgID, Object ... msgParameter) {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append(msgID);
        msgBuf.append('(');
        for (int i = 0; i < msgParameter.length; ++i) {
            if (i > 0) {
                msgBuf.append(',');
            }
            msgBuf.append('{');
            msgBuf.append(i);
            msgBuf.append('}');
        }
        msgBuf.append(')');
        String msg = "$" + MessageFormat.format(msgBuf.toString(), msgParameter) + "$";
        return msg;
    }

    public static String getMsg(String msgID, Object param0) {
        return Msg.getMsg(msgID, new Object[]{param0});
    }
}

