/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.IDiffGroupBounds;
import com.inet.pdfc.generator.model.MinifiedDrawableElement;
import com.inet.pdfc.generator.model.MinifiedElement;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.generator.model.MutableDiffGroup;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import com.inet.pdfc.util.Pair;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class CompareDiffGroup
extends MutableDiffGroup
implements IDiffGroupBounds {
    private transient List<PagedElement> list1;
    private transient List<PagedElement> list2;
    private List<Modification> modifications;
    private Rectangle r1;
    private Rectangle r2;
    private PagedElement elementAfter1;
    private PagedElement elementAfter2;
    private PagedElement lastElement1;
    private PagedElement lastElement2;

    private CompareDiffGroup() {
    }

    public CompareDiffGroup(List<PagedElement> list1, List<PagedElement> list2, PagedElement lastElement1, PagedElement lastElement2, PagedElement nextElement1, PagedElement nextElement2, DiffGroup.GroupType type) {
        super(type);
        this.lastElement1 = lastElement1;
        this.lastElement2 = lastElement2;
        this.elementAfter1 = nextElement1;
        this.elementAfter2 = nextElement2;
        this.createModificationsFromAddedRemovedLists(list1, list2);
    }

    protected void createModificationsFromAddedRemovedLists(List<PagedElement> list1, List<PagedElement> list2) {
        this.modifications = new ArrayList<Modification>();
        ElementType recent = null;
        int start = 0;
        switch (this.getType()) {
            case Sync: {
                break;
            }
            case Replaced: {
                this.modifications.add(new Modification(this.getType(), list1, list2, null));
                break;
            }
            case AddedOrRemoved: {
                PagedElement e;
                int i;
                for (i = 0; i < list1.size(); ++i) {
                    e = list1.get(i);
                    if (recent != null && recent != e.getType().getBaseType()) {
                        this.modifications.add(new Modification(this.getType(), new ArrayList<PagedElement>(list1.subList(start, i)), new ArrayList<PagedElement>(), null));
                        start = i;
                    }
                    recent = e.getType().getBaseType();
                }
                if (list1.size() > 0) {
                    this.modifications.add(new Modification(this.getType(), new ArrayList<PagedElement>(list1.subList(start, list1.size())), new ArrayList<PagedElement>(), null));
                }
                start = 0;
                recent = null;
                for (i = 0; i < list2.size(); ++i) {
                    e = list2.get(i);
                    if (recent != null && recent != e.getType().getBaseType()) {
                        this.modifications.add(new Modification(this.getType(), new ArrayList<PagedElement>(), new ArrayList<PagedElement>(list2.subList(start, i)), null));
                        start = i;
                    }
                    recent = e.getType().getBaseType();
                }
                if (list2.size() <= 0) break;
                this.modifications.add(new Modification(this.getType(), new ArrayList<PagedElement>(), new ArrayList<PagedElement>(list2.subList(start, list2.size())), null));
                break;
            }
            case Modified: 
            case MetadataChanged: {
                throw new IllegalStateException("Cannot create a 'style change' modification instance wihtout any actual modifications!");
            }
            default: {
                throw new IllegalStateException("Cannot derive modifications from a '" + String.valueOf(this.getType()) + "' differences group.");
            }
        }
    }

    public CompareDiffGroup(List<Modification> modifications, PagedElement lastElement1, PagedElement lastElement2, PagedElement nextElement1, PagedElement nextElement2, DiffGroup.GroupType type) {
        super(type);
        this.modifications = modifications;
        this.lastElement1 = lastElement1;
        this.lastElement2 = lastElement2;
        this.elementAfter1 = nextElement1;
        this.elementAfter2 = nextElement2;
    }

    public CompareDiffGroup(@Nonnull List<? extends PagedElement> list1, @Nonnull List<? extends PagedElement> list2) {
        super(null);
        this.list1 = new ArrayList<PagedElement>(list1);
        this.list2 = new ArrayList<PagedElement>(list2);
        this.modifications = new ArrayList<Modification>();
        this.modifications.add(new Modification(null, this.list1, this.list2, null));
    }

    public CompareDiffGroup(Modification modification, DiffGroup.GroupType type) {
        super(type);
        if (modification == null) {
            throw new IllegalArgumentException("Cannot instantiate a DiffGroup without any modification or bounds");
        }
        this.modifications = new ArrayList<Modification>();
        this.modifications.add(modification);
    }

    @Nonnull
    private @Nonnull Pair<@Nonnull List<@Nonnull PagedElement>> getElementsFromModifications(List<Modification> modifications) {
        ArrayList<@Nonnull PagedElement> listLeft = new ArrayList<PagedElement>();
        ArrayList<@Nonnull PagedElement> listRight = new ArrayList<PagedElement>();
        if (modifications != null) {
            for (Modification m : modifications) {
                List<PagedElement> affectedSecond;
                List<PagedElement> affectedFirst = m.getAffectedElements(true);
                if (affectedFirst != null) {
                    listLeft.addAll(affectedFirst);
                }
                if ((affectedSecond = m.getAffectedElements(false)) == null) continue;
                listRight.addAll(affectedSecond);
            }
        }
        return new Pair<List<PagedElement>>(listLeft, listRight);
    }

    @Override
    public void setType(DiffGroup.GroupType type) {
        DiffGroup.GroupType preType = this.getType();
        super.setType(type);
        if (preType == DiffGroup.GroupType.AddedOrRemoved && type == DiffGroup.GroupType.Replaced) {
            Pair<List<PagedElement>> pair = this.getElementsFromModifications(this.getModifications());
            this.resetCache();
            this.modifications.clear();
            Modification replacement = new Modification(DiffGroup.GroupType.Replaced, pair.get(true), pair.get(false), null);
            this.modifications.add(replacement);
        }
    }

    @Override
    @Nonnull
    public @Nonnull List<@Nonnull PagedElement> getRemovedElements() {
        if (this.list1 == null && this.list2 == null) {
            Pair<@Nonnull List<@Nonnull PagedElement>> pair = this.getElementsFromModifications(this.modifications);
            this.list1 = Collections.unmodifiableList(pair.get(true));
            this.list2 = Collections.unmodifiableList(pair.get(false));
        }
        return this.list1;
    }

    @Override
    @Nonnull
    public @Nonnull List<@Nonnull PagedElement> getAddedElements() {
        if (this.list1 == null && this.list2 == null) {
            Pair<@Nonnull List<@Nonnull PagedElement>> pair = this.getElementsFromModifications(this.modifications);
            this.list1 = Collections.unmodifiableList(pair.get(true));
            this.list2 = Collections.unmodifiableList(pair.get(false));
        }
        return this.list2;
    }

    @Override
    public void setBounds(Rectangle bounds, boolean first) {
        if (first) {
            this.r1 = bounds;
        } else {
            this.r2 = bounds;
        }
    }

    @Override
    public Rectangle getBounds(boolean first) {
        return first ? this.r1 : this.r2;
    }

    @Override
    public int getDifferencesCount() {
        switch (this.getType()) {
            case Sync: {
                return 0;
            }
        }
        return this.getModifications().size();
    }

    public void minifyDiffs() {
        for (Modification m : this.modifications) {
            this.minifyList(m.getAffectedElements(true));
            this.minifyList(m.getAffectedElements(false));
        }
        if (this.list1 != null || this.list2 != null) {
            Pair<@Nonnull List<@Nonnull PagedElement>> pair = this.getElementsFromModifications(this.modifications);
            this.list1 = Collections.unmodifiableList(pair.get(true));
            this.list2 = Collections.unmodifiableList(pair.get(false));
        }
        this.lastElement1 = this.minifyNoDiff(this.lastElement1);
        this.lastElement2 = this.minifyNoDiff(this.lastElement2);
        this.elementAfter1 = this.minifyNoDiff(this.elementAfter1);
        this.elementAfter2 = this.minifyNoDiff(this.elementAfter2);
    }

    private void minifyList(List<PagedElement> list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, MinifiedElement.minify(list.get(i)));
            }
        }
    }

    private DrawableElement minifyNoDiff(PagedElement element) {
        if (element == null || element instanceof MinifiedDrawableElement) {
            return (DrawableElement)element;
        }
        ElementID id = new ElementID(false, element.getPageIndex(), (int)element.getBounds().getX(), (int)element.getBounds().getY());
        return new MinifiedDrawableElement(MinifiedElement.getBoundsFloat(element.getBounds()), element.getType(), element.getPageIndex(), id);
    }

    @Override
    public void setElementsAfterGroup(PagedElement elementFirst, PagedElement elementSecond) {
        this.elementAfter1 = elementFirst;
        this.elementAfter2 = elementSecond;
    }

    @Override
    public void setElementsInFrontOfGroup(PagedElement elementFirst, PagedElement elementSecond) {
        this.lastElement1 = elementFirst;
        this.lastElement2 = elementSecond;
    }

    @Override
    public PagedElement getBeforeFirst() {
        return this.lastElement1;
    }

    @Override
    public PagedElement getBeforeSecond() {
        return this.lastElement2;
    }

    @Override
    public PagedElement getAfterFirst() {
        return this.elementAfter1;
    }

    @Override
    public PagedElement getAfterSecond() {
        return this.elementAfter2;
    }

    @Override
    public IDiffGroupBounds getBoundingElements() {
        return this;
    }

    @Override
    public List<Modification> getModifications() {
        if (this.modifications == null && this.list1 != null && this.list2 != null) {
            this.createModificationsFromAddedRemovedLists(this.list1, this.list2);
        }
        return this.modifications;
    }

    private static <T> boolean isEqual(T a, T b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public boolean equals(Object other) {
        if (!(other instanceof CompareDiffGroup)) {
            return false;
        }
        CompareDiffGroup dg = (CompareDiffGroup)other;
        return CompareDiffGroup.isEqual(this.list1, dg.list1) && CompareDiffGroup.isEqual(this.list2, dg.list2) && CompareDiffGroup.isEqual(this.modifications, dg.modifications) && CompareDiffGroup.isEqual(this.r1, dg.r1) && CompareDiffGroup.isEqual(this.r2, dg.r2) && CompareDiffGroup.isEqual(this.elementAfter1, dg.elementAfter1) && CompareDiffGroup.isEqual(this.elementAfter2, dg.elementAfter2) && CompareDiffGroup.isEqual(this.lastElement1, dg.lastElement1) && CompareDiffGroup.isEqual(this.lastElement2, dg.lastElement2);
    }

    @Override
    public void resetCache() {
        this.list1 = null;
        this.list2 = null;
    }

    @Override
    public boolean isVisible() {
        for (int i = 0; i < this.modifications.size(); ++i) {
            if (!this.modifications.get(i).isVisible()) continue;
            return true;
        }
        return false;
    }
}

