/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.config;

import com.inet.annotations.PublicApi;
import com.inet.pdfc.model.ElementType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public enum CompareType {
    TEXT,
    LINE,
    IMAGE,
    ANNOTATION;

    private static final Map<CompareType, ElementType[]> TYPE_MAP;

    public static Set<ElementType> getElementTypesForCompareTypes(List<CompareType> diffTypes) {
        HashSet<ElementType> allowedTypes = new HashSet<ElementType>();
        if (diffTypes == null) {
            return allowedTypes;
        }
        for (CompareType type : diffTypes) {
            if (type == null) continue;
            allowedTypes.addAll(Arrays.asList(TYPE_MAP.get((Object)type)));
        }
        return allowedTypes;
    }

    static {
        TYPE_MAP = new HashMap<CompareType, ElementType[]>(){
            {
                this.put(TEXT, new ElementType[]{ElementType.Text, ElementType.ControlText, ElementType.ControlCheckBox, ElementType.ControlSignature, ElementType.TextWord});
                this.put(LINE, new ElementType[]{ElementType.Line, ElementType.LineHorizontal, ElementType.LineVertical, ElementType.Curve, ElementType.Shape});
                this.put(IMAGE, new ElementType[]{ElementType.Image});
                this.put(ANNOTATION, new ElementType[]{ElementType.Annotation});
            }
        };
    }
}

