/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import java.io.Reader;
import javax.annotation.Nonnull;

@InternalApi
public class FastStringReader
extends Reader {
    private final String str;
    private final int length;
    private int idx;

    public FastStringReader(@Nonnull String str) {
        this.str = str;
        this.length = str.length();
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.length <= this.idx) {
            return -1;
        }
        int count = Math.min(this.length - this.idx, len);
        this.str.getChars(this.idx, this.idx + count, cbuf, off);
        this.idx += count;
        return count;
    }

    @Override
    public int read() {
        if (this.length <= this.idx) {
            ++this.idx;
            return -1;
        }
        return this.str.charAt(this.idx++);
    }

    @Override
    public void close() {
        this.idx = this.length;
    }

    public void back() {
        if (this.idx <= 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.idx;
    }

    public int getIndexPosition() {
        return this.idx;
    }

    public void setIndexPosition(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.idx = idx;
    }
}

