/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.json.BonParser;
import com.inet.lib.json.BonWriter;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.json.JsonTypeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Bon {
    public static final Map<Object, Map<String, Object>> NULL_MAP = new HashMap<Object, Map<String, Object>>(){

        @Override
        public Map<String, Object> put(@Nullable Object key, @Nullable Map<String, Object> value) {
            return null;
        }

        @Override
        public void putAll(@Nonnull Map<? extends Object, ? extends Map<String, Object>> m) {
        }
    };

    public byte @Nonnull [] toBinary(@Nonnull Object data) {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.toBinary(data, out);
        return out.toByteArray();
    }

    public void toBinary(@Nonnull Object data, @Nonnull OutputStream out) {
        try {
            BonWriter writer = new BonWriter(out);
            writer.writeValue(data);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nullable
    public <T> T fromBinary(byte @Nonnull [] binaryData, @Nonnull Class<T> clazz, Type ... generic) {
        return this.fromBinary(binaryData, (Type)new JsonParameterizedType(clazz, generic), NULL_MAP, null);
    }

    @Nullable
    public <T> T fromBinary(byte @Nonnull [] binaryData, @Nonnull Class<T> clazz) {
        return this.fromBinary(binaryData, clazz, NULL_MAP, null);
    }

    @Nullable
    public <T> T fromBinary(byte @Nonnull [] binaryData, @Nonnull Type type) {
        return this.fromBinary(binaryData, type, NULL_MAP, null);
    }

    @Nullable
    public <T> T fromBinary(byte @Nonnull [] binaryData, @Nonnull Type type, @Nonnull Map<Object, Map<String, Object>> extraFields, @Nullable JsonTypeResolver typeResolver) {
        try {
            return this.fromBinary((InputStream)new FastByteArrayInputStream(binaryData), type, extraFields, typeResolver);
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }

    @Nullable
    public <T> T fromBinary(@Nonnull InputStream input, @Nonnull Class<T> clazz) throws IOException {
        return this.fromBinary(input, clazz, NULL_MAP, null);
    }

    @Nullable
    public <T> T fromBinary(@Nonnull InputStream input, @Nonnull Class<T> clazz, Type ... generic) throws IOException {
        return this.fromBinary(input, (Type)new JsonParameterizedType(clazz, generic), NULL_MAP, null);
    }

    @Nullable
    public <T> T fromBinary(@Nonnull InputStream input, @Nonnull Type type, @Nonnull Map<Object, Map<String, Object>> extraFields, @Nullable JsonTypeResolver typeResolver) throws IOException {
        try {
            JsonTypeResolver _typeResolver = typeResolver == null ? JsonTypeResolver.INSTANCE : typeResolver;
            BonParser reader = new BonParser(input, extraFields, _typeResolver);
            Object value = reader.parseValue(type, null);
            return (T)value;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw JsonException.create(ex);
        }
    }
}

