/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComparisonFailedException
extends Exception {
    private ERROR_TYPE type;
    private int httpErrorCode;
    private String response;

    public ComparisonFailedException(@Nonnull ERROR_TYPE type) {
        super(type.name());
        this.type = type;
    }

    public ComparisonFailedException(@Nonnull ERROR_TYPE type, int httpCode, @Nullable String response) {
        super(type.name() + ": " + response);
        this.response = response;
        this.type = httpCode == 401 ? ERROR_TYPE.authenticationFailed : type;
        this.httpErrorCode = httpCode;
    }

    public ComparisonFailedException(@Nonnull ERROR_TYPE type, @Nonnull Throwable cause) {
        super(type.name(), cause);
        this.type = type;
        this.httpErrorCode = 200;
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    @Nullable
    public String getResponse() {
        return this.response;
    }

    public ERROR_TYPE getErrorType() {
        return this.type;
    }

    public static enum ERROR_TYPE {
        missingFirstDocument,
        missingSecondDocument,
        authenticationFailed,
        serverError,
        resultError;

    }
}

