/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemorySize;
import com.inet.id.GUID;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldValidationException;
import com.inet.usersandgroups.api.UserField;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class MutableUserData
implements MemorySize {
    private Map<UserField<Object>, Object> a = new HashMap<UserField<Object>, Object>();
    private Set<UserField<Object>> b = new HashSet<UserField<Object>>();

    public static MutableUserData createAndFillWithValidValues(@Nullable GUID accountID, List<UserField<Object>> userFields, Map<UserField<Object>, Object> userData) {
        MutableUserData mutableUserData = new MutableUserData();
        for (UserField<Object> userField : userFields) {
            if (UsersAndGroups.FIELD_EMAIL.equals(userField)) {
                if (userData.containsKey(userField)) {
                    mutableUserData.putValidOrDefaultValueLazily(userField, userData.get(userField));
                    continue;
                }
                mutableUserData.a.put(userField, userField.getDefaultValue());
                continue;
            }
            Object VALUE = userData.containsKey(userField) ? userField.getValidOrDefaultValue(userData.get(userField), accountID) : userField.getDefaultValue();
            mutableUserData.a.put(userField, VALUE);
        }
        return mutableUserData;
    }

    public <VALUE> void put(UserField<VALUE> field, VALUE value) {
        try {
            field.validate(value);
        }
        catch (FieldValidationException fieldValidationException) {
            throw new FieldValidationException(field.getKey() + ": " + fieldValidationException.getMessage(), fieldValidationException);
        }
        this.a.put(field, value);
    }

    public <VALUE> void putValidOrDefaultValueLazily(UserField<VALUE> field, VALUE value) {
        this.b.add(field);
        this.a.put(field, value);
    }

    public <VALUE> VALUE get(UserField<VALUE> field) {
        Object object = this.a.get(field);
        if (this.b.contains(field)) {
            object = field.getValidOrDefaultValue(object, null);
            this.a.put(field, object);
            this.b.remove(field);
        }
        return (VALUE)object;
    }

    public void remove(UserField<?> field) {
        this.a.remove(field);
        this.b.remove(field);
    }

    public boolean containsField(UserField<?> field) {
        return this.a.containsKey(field);
    }

    public Set<UserField<Object>> getIncludedFields() {
        return new HashSet<UserField<Object>>(this.a.keySet());
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public MutableUserData copy() {
        MutableUserData mutableUserData = new MutableUserData();
        for (Map.Entry<UserField<Object>, Object> entry : this.a.entrySet()) {
            UserField<Object> userField = entry.getKey();
            mutableUserData.a.put(userField, userField.copyValue(entry.getValue()));
        }
        mutableUserData.b.addAll(this.b);
        return mutableUserData;
    }

    public MutableUserData copyWithSpecifiedFieldsOnly(Collection<UserField<Object>> fieldsToInclude, boolean insertDefaultValuesForMissingFields) {
        MutableUserData mutableUserData = new MutableUserData();
        for (UserField<Object> userField : fieldsToInclude) {
            if (this.containsField(userField)) {
                Object object = this.a.get(userField);
                mutableUserData.a.put(userField, userField.copyValue(object));
                if (!this.b.contains(userField)) continue;
                mutableUserData.b.add(userField);
                continue;
            }
            if (!insertDefaultValuesForMissingFields) continue;
            mutableUserData.a.put(userField, userField.getDefaultValue());
        }
        return mutableUserData;
    }

    @Override
    public long getSizeInMemory() {
        return 32L + MemorySize.getSizeOfMap(this.a);
    }

    public static <VALUE> MutableUserData of(@Nonnull UserField<VALUE> field, @Nullable VALUE value) {
        MutableUserData mutableUserData = new MutableUserData();
        mutableUserData.put(field, value);
        return mutableUserData;
    }
}

