/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.http.ExpandableHttpSessionListener;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.ConditionTokenMatcher;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

@InternalApi
public class LoggedInUsersConditionTokenMatcher
implements ConditionTokenMatcher {
    @Override
    @Nonnull
    public String getTag() {
        return "loggedinusers";
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return UsersAndGroups.MSG.getMsg("usersandgroupsmanager.loggedinusers.matcher", new Object[0]);
    }

    @Override
    @Nonnull
    public SearchExpression createSearchExpression(@Nonnull String value, @Nonnull SearchCondition.SearchTermOperator operator, boolean quote, boolean useGenericLocale) {
        if (value.isEmpty()) {
            return new PrefilteredSearchExpression(this.a());
        }
        Locale locale = ClientLocale.getThreadLocale();
        if (value.equalsIgnoreCase(CoreSystemStructureProvider.INSTANCE.translate(locale, "license.info.true", new Object[0]))) {
            return new PrefilteredSearchExpression(this.a());
        }
        if (value.equalsIgnoreCase(CoreSystemStructureProvider.INSTANCE.translate(locale, "license.info.false", new Object[0]))) {
            return new PrefilteredSearchExpression(this.b());
        }
        return new PrefilteredSearchExpression(Collections.emptySet());
    }

    private HashSet<GUID> a() {
        HashSet<GUID> hashSet = new HashSet<GUID>();
        long l2 = System.currentTimeMillis() - 180000L;
        Collection<HttpSession> collection = ExpandableHttpSessionListener.getActiveSessions();
        for (HttpSession httpSession : collection) {
            GUID gUID;
            LoginProcessor loginProcessor;
            if (httpSession.getLastAccessedTime() < l2 || (loginProcessor = LoginManager.getLoginProcessor(httpSession)) == null || (gUID = loginProcessor.getUserAccountID()) == null) continue;
            hashSet.add(gUID);
        }
        return hashSet;
    }

    private Set<GUID> b() {
        Set<GUID> set = UserManager.getRecoveryEnabledInstance().getSearchEngine().simpleSearch(new SearchCommand("useraccountid", SearchCondition.SearchTermOperator.StartsWith, ""));
        set.removeAll(this.a());
        return set;
    }

    @Override
    public boolean isSuggestedTag() {
        return this.isTextSearchEnabled();
    }

    @Override
    public boolean isTextSearchEnabled() {
        if (UserManager.getInstance().getCurrentUserAccountID() == null) {
            return false;
        }
        return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
    }

    @Override
    @Nonnull
    public Iterator<String> createDisplayValuesIterator(String startsWith, Predicate filter) {
        Locale locale = ClientLocale.getThreadLocale();
        String string = CoreSystemStructureProvider.INSTANCE.translate(locale, "license.info.true", new Object[0]);
        String string2 = CoreSystemStructureProvider.INSTANCE.translate(locale, "license.info.false", new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.toLowerCase().startsWith(startsWith)) {
            arrayList.add(string);
        }
        if (string2.toLowerCase().startsWith(startsWith)) {
            arrayList.add(string2);
        }
        arrayList.sort(null);
        return arrayList.iterator();
    }
}

