/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.values;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.values.MemberChild;
import com.inet.usersandgroups.api.ui.fields.values.MemberParent;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class MemberEntry {
    private GUID guid;
    private String membershipType;
    private String membershipGroupKey;
    private Type entryType;
    private String entryTypeKey;
    private String displayName;
    private ArrayList<MemberParent> parents = null;
    private ArrayList<MemberChild> children = null;
    private boolean dummy = false;
    private boolean preventEditing = false;
    private int level = 0;
    private String sortPath;

    public static MemberEntry ofGroupMember(@Nonnull UserAccount member, @Nonnull GroupType groupType) {
        return MemberEntry.ofGroupMember(member, groupType, null);
    }

    public static MemberEntry ofGroupMember(@Nonnull UserAccount member, @Nonnull GroupType groupType, @Nullable MembershipType membershipType) {
        String string = membershipType == null ? "" : membershipType.getKey();
        return new MemberEntry(member.getID(), string, groupType.getName(), Type.user, member.getAccountType().name(), member.getDisplayName());
    }

    public static MemberEntry ofUserGroup(@Nonnull UserGroupInfo group) {
        return MemberEntry.ofUserGroup(group, null);
    }

    public static MemberEntry ofUserGroup(@Nonnull UserGroupInfo group, @Nullable MembershipType membershipType) {
        String string = membershipType == null ? "" : membershipType.getKey();
        return new MemberEntry(group.getID(), string, group.getType().getName(), Type.group, group.getType().getName(), group.getDisplayName());
    }

    public static MemberEntry ofGuid(GUID guid, Type entryType, String entryTypeKey, String displayName) {
        return new MemberEntry(guid, "", null, entryType, entryTypeKey, displayName);
    }

    private MemberEntry() {
    }

    private MemberEntry(GUID guid, String membershipType, String membershipGroupKey, Type entryType, String entryTypeKey, String displayName) {
        this.guid = guid;
        this.membershipType = membershipType;
        this.membershipGroupKey = membershipGroupKey;
        this.entryType = entryType;
        this.entryTypeKey = entryTypeKey;
        this.displayName = displayName;
        this.sortPath = displayName;
    }

    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    public void setPreventEditing(boolean preventEditing) {
        this.preventEditing = preventEditing;
    }

    public boolean isPreventEditing() {
        return this.preventEditing;
    }

    public String getMembershipType() {
        return this.membershipType;
    }

    public String getMembershipGroupKey() {
        return this.membershipGroupKey;
    }

    public GUID getGuid() {
        return this.guid;
    }

    public void setParents(ArrayList<MemberParent> parents) {
        if (parents != null && parents.isEmpty()) {
            parents = null;
        }
        this.parents = parents;
        if (parents != null) {
            this.level = parents.size();
            String string = parents.stream().map(MemberParent::getDisplayName).collect(Collectors.joining("/"));
            this.sortPath = string + "/" + this.displayName;
        }
    }

    public List<MemberParent> getParents() {
        if (this.parents == null) {
            return null;
        }
        return new ArrayList<MemberParent>(this.parents);
    }

    public void setChildren(ArrayList<MemberChild> children) {
        this.children = children;
    }

    public List<MemberChild> getChildren() {
        if (this.children == null) {
            return null;
        }
        return new ArrayList<MemberChild>(this.children);
    }
}

