/*
 * Decompiled with CFR 0.152.
 */
package com.inet.graphics.buffered;

import com.inet.annotations.InternalApi;
import com.inet.cache.image.RenderingHintLowerImage;
import com.inet.graphics.buffered.GraphicsObjectID;
import com.inet.graphics.encode.PNGEncoder;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@InternalApi
public class BufferedGraphicsCommand {
    private MethodNames a = null;
    private Object[] b = null;
    private int c;

    public BufferedGraphicsCommand(int graphicsID, MethodNames name, Object[] params) {
        if (name == null) {
            throw new IllegalArgumentException("Keine Methode mit diesem Namen vorhanden:" + String.valueOf((Object)name));
        }
        this.a = name;
        this.b = params;
        this.c = graphicsID;
    }

    public void run(LayerGraphics2D graphics, Map<GraphicsObjectID, AffineTransform> transformMap, Map<Integer, Shape> clipShapeMap) {
        if (graphics != null) {
            AffineTransform affineTransform = graphics.getTransform();
            boolean bl = false;
            if (graphics.getRenderingHint(RenderingHintLowerImage.KEY) != null) {
                bl = (Integer)graphics.getRenderingHint(RenderingHintLowerImage.KEY) == 1;
            }
            Object[] objectArray = this.getParameters();
            boolean bl2 = false;
            try {
                switch (this.a) {
                    case ADD_RENDERING_HINTS: {
                        graphics.addRenderingHints((Map)objectArray[0]);
                        break;
                    }
                    case CLIP: {
                        graphics.clip((Shape)objectArray[0]);
                        break;
                    }
                    case DRAW: {
                        graphics.draw((Shape)objectArray[0]);
                        break;
                    }
                    case DRAW_GLYPH_VECTOR: {
                        graphics.drawGlyphVector((GlyphVector)objectArray[0], ((Float)objectArray[1]).floatValue(), ((Float)objectArray[2]).floatValue());
                        break;
                    }
                    case DRAW_IMAGE_WITH_XFORM: {
                        Image image = (Image)objectArray[0];
                        if (bl && affineTransform != null) {
                            image = this.scaleImage(graphics, affineTransform, image);
                        }
                        AffineTransform affineTransform2 = (AffineTransform)objectArray[1];
                        graphics.drawImage(image, affineTransform2, (ImageObserver)objectArray[2]);
                        if (bl && affineTransform != null) {
                            graphics.setTransform(affineTransform);
                        }
                        break;
                    }
                    case DRAW_IMAGE_WITH_BUFF_IMG: {
                        graphics.drawImage((BufferedImage)objectArray[0], (BufferedImageOp)objectArray[1], (int)((Integer)objectArray[2]), (Integer)objectArray[3]);
                        break;
                    }
                    case DRAW_RENDERABLE_IMAGE: {
                        graphics.drawRenderableImage((RenderableImage)objectArray[0], (AffineTransform)objectArray[1]);
                        break;
                    }
                    case DRAW_RENDERED_IMAGE: {
                        graphics.drawRenderedImage((RenderedImage)objectArray[0], (AffineTransform)objectArray[1]);
                        break;
                    }
                    case DRAW_STRING_WITH_INT: {
                        String string = (String)objectArray[0];
                        int n2 = (Integer)objectArray[1];
                        int n3 = (Integer)objectArray[2];
                        this.a(graphics, string, (float)n2, (float)n3);
                        this.a(graphics, string, n2, n3);
                        this.d(graphics, string, n2, n3);
                        break;
                    }
                    case DRAW_STRING_WITH_FLOAT: {
                        String string = (String)objectArray[0];
                        float f2 = ((Float)objectArray[1]).floatValue();
                        float f3 = ((Float)objectArray[2]).floatValue();
                        this.a(graphics, string, f2, f3);
                        this.b(graphics, string, f2, f3);
                        this.d(graphics, string, f2, f3);
                        break;
                    }
                    case DRAW_STRING_WITH_ACI_AND_INT: {
                        graphics.drawString((AttributedCharacterIterator)objectArray[0], (int)((Integer)objectArray[1]), (int)((Integer)objectArray[2]));
                        break;
                    }
                    case DRAW_STRING_WITH_ACI_AND_FLOAT: {
                        graphics.drawString((AttributedCharacterIterator)objectArray[0], ((Float)objectArray[1]).floatValue(), ((Float)objectArray[2]).floatValue());
                        break;
                    }
                    case FILL: {
                        graphics.fill((Shape)objectArray[0]);
                        break;
                    }
                    case GET_BACKGROUND: {
                        graphics.getBackground();
                        break;
                    }
                    case GET_COMPOSITE: {
                        graphics.getComposite();
                        break;
                    }
                    case GET_DEVICE_CONFIGURATION: {
                        graphics.getDeviceConfiguration();
                        break;
                    }
                    case GET_FONT_RENDER_CONTEXT: {
                        graphics.getFontRenderContext();
                        break;
                    }
                    case GET_PAINT: {
                        graphics.getPaint();
                        break;
                    }
                    case GET_RENDERING_HINT: {
                        graphics.getRenderingHint((RenderingHints.Key)objectArray[0]);
                        break;
                    }
                    case GET_RENDERING_HINTS: {
                        graphics.getRenderingHints();
                        break;
                    }
                    case GET_STROKE: {
                        graphics.getStroke();
                        break;
                    }
                    case GET_TRANSFORM: {
                        transformMap.put((GraphicsObjectID)objectArray[0], graphics.getTransform());
                        break;
                    }
                    case HIT: {
                        graphics.hit((Rectangle)objectArray[0], (Shape)objectArray[1], (Boolean)objectArray[2]);
                        break;
                    }
                    case ROTATE: {
                        graphics.rotate((Double)objectArray[0]);
                        break;
                    }
                    case ROTATE_WITH_COORDS: {
                        graphics.rotate((Double)objectArray[0], (Double)objectArray[1], (Double)objectArray[2]);
                        break;
                    }
                    case SCALE: {
                        graphics.scale((Double)objectArray[0], (Double)objectArray[1]);
                        break;
                    }
                    case SET_BACKGROUND: {
                        graphics.setBackground((Color)objectArray[0]);
                        break;
                    }
                    case SET_COMPOSITE: {
                        Composite composite = (Composite)objectArray[0];
                        if (composite instanceof BlendComposite) {
                            BlendComposite blendComposite = (BlendComposite)objectArray[0];
                            composite = new BlendComposite(blendComposite.getMode(), blendComposite.getAlpha(), blendComposite.getMask());
                        }
                        graphics.setComposite(composite);
                        break;
                    }
                    case SET_GRADIENT_PAINT: 
                    case SET_RADIAL_GRADIENT_PAINT: 
                    case SET_LINEAR_GRADIENT_PAINT: 
                    case SET_TEXTURE_PAINT: 
                    case SETPAINT: 
                    case SET_PAINT_CUSTOM: {
                        graphics.setPaint((Paint)objectArray[0]);
                        break;
                    }
                    case SET_RENDERING_HINT: {
                        graphics.setRenderingHint((RenderingHints.Key)objectArray[0], objectArray[1]);
                        break;
                    }
                    case SET_RENDERING_HINTS: {
                        graphics.setRenderingHints((Map)objectArray[0]);
                        break;
                    }
                    case SET_STROKE: {
                        graphics.setStroke((Stroke)objectArray[0]);
                        break;
                    }
                    case SET_TRANSFORM: {
                        graphics.setTransform(transformMap.get(objectArray[0]));
                        break;
                    }
                    case SHEAR: {
                        graphics.shear((Double)objectArray[0], (Double)objectArray[1]);
                        break;
                    }
                    case TRANSFORM: {
                        graphics.transform((AffineTransform)objectArray[0]);
                        break;
                    }
                    case TRANSLATE_WITH_INT: {
                        graphics.translate((Integer)objectArray[0], (Integer)objectArray[1]);
                        break;
                    }
                    case TRANSLATE_WITH_DOUBLE: {
                        graphics.translate((Double)objectArray[0], (Double)objectArray[1]);
                        break;
                    }
                    case CLEAR_RECT: {
                        graphics.clearRect((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
                        break;
                    }
                    case CLIP_RECT: {
                        graphics.clipRect((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
                        break;
                    }
                    case COPY_AREA: {
                        graphics.copyArea((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4], (Integer)objectArray[5]);
                        break;
                    }
                    case DISPOSE: {
                        graphics.dispose();
                        break;
                    }
                    case DRAW_ARC: {
                        graphics.drawArc((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4], (Integer)objectArray[5]);
                        break;
                    }
                    case DRAW_IMAGE_WITH_OBS: {
                        Image image = (Image)objectArray[0];
                        bl2 = BufferedGraphicsCommand.a(graphics);
                        if (bl && affineTransform != null && bl2) {
                            image = this.scaleImage(graphics, affineTransform, image);
                        }
                        graphics.drawImage(image, (Integer)objectArray[1], (int)((Integer)objectArray[2]), (ImageObserver)objectArray[3]);
                        if (bl && affineTransform != null && bl2) {
                            graphics.setTransform(affineTransform);
                        }
                        break;
                    }
                    case DRAW_IMAGE_WITH_BG: {
                        Image image = (Image)objectArray[0];
                        bl2 = BufferedGraphicsCommand.a(graphics);
                        if (bl && affineTransform != null && bl2) {
                            image = this.scaleImage(graphics, affineTransform, image);
                        }
                        graphics.drawImage(image, (Integer)objectArray[1], (Integer)objectArray[2], (Color)objectArray[3], (ImageObserver)objectArray[4]);
                        if (bl && affineTransform != null && bl2) {
                            graphics.setTransform(affineTransform);
                        }
                        break;
                    }
                    case DRAW_IMAGE_WITH_SIZE: {
                        Image image = (Image)objectArray[0];
                        int n4 = (Integer)objectArray[3];
                        int n5 = (Integer)objectArray[4];
                        bl2 = BufferedGraphicsCommand.a(graphics);
                        if (bl && bl2) {
                            image = this.scaleInternImage(n4, n5, image);
                        }
                        graphics.drawImage(image, (Integer)objectArray[1], (Integer)objectArray[2], n4, n5, (ImageObserver)objectArray[5]);
                        break;
                    }
                    case DRAW_IMAGE_WITH_SIZE_AND_BG: {
                        Image image = (Image)objectArray[0];
                        int n6 = (Integer)objectArray[3];
                        int n7 = (Integer)objectArray[4];
                        bl2 = BufferedGraphicsCommand.a(graphics);
                        if (bl && bl2) {
                            image = this.scaleInternImage(n6, n7, image);
                        }
                        graphics.drawImage(image, (Integer)objectArray[1], (Integer)objectArray[2], n6, n7, (Color)objectArray[5], (ImageObserver)objectArray[6]);
                        break;
                    }
                    case DRAW_IMAGE_WITH_CORNER: {
                        Image image = (Image)objectArray[0];
                        int n8 = (Integer)objectArray[1];
                        int n9 = (Integer)objectArray[2];
                        int n10 = (Integer)objectArray[3];
                        int n11 = (Integer)objectArray[4];
                        int n12 = (Integer)objectArray[5];
                        int n13 = (Integer)objectArray[6];
                        int n14 = (Integer)objectArray[7];
                        int n15 = (Integer)objectArray[8];
                        int n16 = Math.abs(n8 - n10);
                        int n17 = Math.abs(n9 - n11);
                        int n18 = n12 < n14 ? 1 : -1;
                        int n19 = n13 < n15 ? 1 : -1;
                        bl2 = BufferedGraphicsCommand.a(graphics);
                        if (bl && bl2) {
                            image = this.scaleInternImage(n16, n17, image);
                            n14 = n12 + n18 * image.getWidth(null);
                            n15 = n13 + n19 * image.getHeight(null);
                        }
                        graphics.drawImage((Image)objectArray[0], n8, n9, n10, n11, n12, n13, n14, n15, (ImageObserver)objectArray[9]);
                        break;
                    }
                    case DRAW_IMAGE_WITH_CORNER_AND_BG: {
                        Image image = (Image)objectArray[0];
                        int n20 = (Integer)objectArray[1];
                        int n21 = (Integer)objectArray[2];
                        int n22 = (Integer)objectArray[3];
                        int n23 = (Integer)objectArray[4];
                        int n24 = (Integer)objectArray[5];
                        int n25 = (Integer)objectArray[6];
                        int n26 = (Integer)objectArray[7];
                        int n27 = (Integer)objectArray[8];
                        int n28 = Math.abs(n20 - n22);
                        int n29 = Math.abs(n21 - n23);
                        int n30 = n24 < n26 ? 1 : -1;
                        int n31 = n25 < n27 ? 1 : -1;
                        bl2 = BufferedGraphicsCommand.a(graphics);
                        if (bl && bl2) {
                            image = this.scaleInternImage(n28, n29, image);
                            n26 = n24 + n30 * image.getWidth(null);
                            n27 = n25 + n31 * image.getHeight(null);
                        }
                        graphics.drawImage((Image)objectArray[0], n20, n21, n22, n23, n24, n25, n26, n27, (Color)objectArray[9], (ImageObserver)objectArray[10]);
                        break;
                    }
                    case DRAW_LINE: {
                        graphics.drawLine((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
                        break;
                    }
                    case DRAW_OVAL: {
                        graphics.drawOval((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
                        break;
                    }
                    case DRAW_POLYGON: {
                        graphics.drawPolygon((int[])objectArray[0], (int[])objectArray[1], (Integer)objectArray[2]);
                        break;
                    }
                    case DRAW_POLYLINE: {
                        graphics.drawPolyline((int[])objectArray[0], (int[])objectArray[1], (Integer)objectArray[2]);
                        break;
                    }
                    case DRAW_ROUND_RECT: {
                        graphics.drawRoundRect((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4], (Integer)objectArray[5]);
                        break;
                    }
                    case FILL_ARC: {
                        graphics.fillArc((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4], (Integer)objectArray[5]);
                        break;
                    }
                    case FILL_OVAL: {
                        graphics.fillOval((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
                        break;
                    }
                    case FILL_POLYGON: {
                        graphics.fillPolygon((int[])objectArray[0], (int[])objectArray[1], (Integer)objectArray[2]);
                        break;
                    }
                    case FILL_RECT: {
                        graphics.fillRect((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
                        break;
                    }
                    case FILL_ROUND_RECT: {
                        graphics.fillRoundRect((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3], (Integer)objectArray[4], (Integer)objectArray[5]);
                        break;
                    }
                    case GET_CLIP: {
                        clipShapeMap.put((Integer)objectArray[0], graphics.getClip());
                        break;
                    }
                    case GET_CLIP_BOUNDS: {
                        graphics.getClipBounds();
                        break;
                    }
                    case GET_COLOR: {
                        graphics.getColor();
                        break;
                    }
                    case GET_FONT: {
                        graphics.getFont();
                        break;
                    }
                    case GET_FONT_METRICS: {
                        graphics.getFontMetrics((Font)objectArray[0]);
                        break;
                    }
                    case SET_CLIP_WITH_SHAPE: {
                        boolean bl3 = (Boolean)objectArray[0];
                        if (bl3) {
                            Object object = objectArray[1];
                            Shape shape = clipShapeMap.get(object);
                            graphics.setClip(shape);
                            break;
                        }
                        graphics.setClip((Shape)objectArray[1]);
                        break;
                    }
                    case SET_CLIP: {
                        graphics.setClip((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
                        break;
                    }
                    case SET_COLOR: {
                        graphics.setColor((Color)objectArray[0]);
                        break;
                    }
                    case SET_FONT: {
                        graphics.setFont((Font)objectArray[0]);
                        break;
                    }
                    case SET_PAINT_MODE: {
                        graphics.setPaintMode();
                        break;
                    }
                    case SET_XOR_MODE: {
                        graphics.setXORMode((Color)objectArray[0]);
                        break;
                    }
                    case ADDLAYER: {
                        BlendComposite blendComposite = (BlendComposite)objectArray[2];
                        blendComposite = new BlendComposite(blendComposite.getMode(), blendComposite.getAlpha(), blendComposite.getMask());
                        graphics.addLayer((Boolean)objectArray[0], (Boolean)objectArray[1], blendComposite);
                        break;
                    }
                    case INITIALIZE: {
                        graphics.setInitialInformation((Rectangle2D)objectArray[0], (AffineTransform)objectArray[1]);
                        break;
                    }
                    case DRAWLAYER: {
                        graphics.paintLastLayer();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Kein Methodenname gefunden:" + this.a.toString());
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalStateException("Nicht gen\u00fcgend Parameter \u00fcbergeben", arrayIndexOutOfBoundsException);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("Falsche Parameter-Typen \u00fcbergeben f\u00fcr " + String.valueOf((Object)this.a), classCastException);
            }
        }
    }

    private void a(LayerGraphics2D layerGraphics2D, String string, float f2, float f3) {
        Font font = layerGraphics2D.getFont();
        if (font == null) {
            return;
        }
        Paint paint = (Paint)font.getAttributes().get(TextAttribute.BACKGROUND);
        if (paint == null) {
            return;
        }
        FontMetrics fontMetrics = layerGraphics2D.getFontMetrics();
        int n2 = Double.valueOf(Math.floor(f2)).intValue();
        int n3 = Double.valueOf(Math.floor(f3)).intValue();
        double d2 = fontMetrics.getStringBounds(string, layerGraphics2D).getWidth();
        int n4 = Double.valueOf(Math.ceil((double)f2 + d2)).intValue() - n2;
        int n5 = fontMetrics.getHeight();
        Paint paint2 = layerGraphics2D.getPaint();
        layerGraphics2D.setPaint(paint);
        layerGraphics2D.fillRect(n2, n3 - fontMetrics.getAscent(), n4, n5);
        layerGraphics2D.setPaint(paint2);
    }

    private void a(LayerGraphics2D layerGraphics2D, String string, int n2, int n3) {
        if (!this.c(layerGraphics2D, string, n2, n3)) {
            layerGraphics2D.drawString(string, n2, n3);
        }
    }

    private void b(LayerGraphics2D layerGraphics2D, String string, float f2, float f3) {
        if (!this.c(layerGraphics2D, string, f2, f3)) {
            layerGraphics2D.drawString(string, f2, f3);
        }
    }

    private boolean c(LayerGraphics2D layerGraphics2D, String string, float f2, float f3) {
        Integer n2;
        Font font = layerGraphics2D.getFont();
        if (font != null && (n2 = (Integer)font.getAttributes().get(TextAttribute.SUPERSCRIPT)) != null && n2 != 0) {
            float f4 = (float)font.getSize() * 0.666f;
            HashMap hashMap = new HashMap(font.getAttributes());
            hashMap.put(TextAttribute.SIZE, Float.valueOf(f4));
            hashMap.put(TextAttribute.SUPERSCRIPT, 0);
            Font font2 = font.deriveFont(hashMap);
            FontMetrics fontMetrics = layerGraphics2D.getFontMetrics(font2);
            f3 = n2 > 0 ? (f3 -= (float)fontMetrics.getHeight() * 0.4f) : (f3 += (float)fontMetrics.getHeight() * 0.141f);
            layerGraphics2D.setFont(font2);
            layerGraphics2D.drawString(string, f2, f3);
            layerGraphics2D.setFont(font);
            return true;
        }
        return false;
    }

    private void d(LayerGraphics2D layerGraphics2D, String string, float f2, float f3) {
        Font font = layerGraphics2D.getFont();
        if (font != null && font.getAttributes().get(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON) {
            FontMetrics fontMetrics = layerGraphics2D.getFontMetrics();
            int n2 = Double.valueOf(Math.ceil(fontMetrics.getStringBounds(string, layerGraphics2D).getWidth())).intValue();
            int n3 = Double.valueOf(Math.floor(f2)).intValue();
            int n4 = n3 + n2;
            int n5 = font.getSize() * 20;
            float f4 = (float)n5 / 20.078432f;
            float f5 = f4 / 15.0f;
            int n6 = Double.valueOf(Math.floor(f3)).intValue() - fontMetrics.getAscent() / 2 + fontMetrics.getDescent() / 2 + Math.round(f5);
            Stroke stroke = layerGraphics2D.getStroke();
            layerGraphics2D.setStroke(new BasicStroke(f5));
            layerGraphics2D.drawLine(n3, n6, n4, n6);
            layerGraphics2D.setStroke(stroke);
        }
    }

    protected Image scaleImage(Graphics2D graphics, AffineTransform currentTransform, Image image) {
        if (currentTransform.getScaleX() < 0.5 || currentTransform.getScaleY() < 0.5) {
            AffineTransform affineTransform = new AffineTransform(currentTransform);
            while ((Math.abs(affineTransform.getScaleX()) < 0.5 || Math.abs(affineTransform.getScaleY()) < 0.5) && image.getWidth(null) > 1 && image.getHeight(null) > 1) {
                try {
                    int n2;
                    int n3 = n2 = image instanceof BufferedImage ? ((BufferedImage)image).getType() : 2;
                    if (n2 >= 12) {
                        n2 = 1;
                    }
                    BufferedImage bufferedImage = new BufferedImage(image.getWidth(null) / 2, image.getHeight(null) / 2, n2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.drawImage(image, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                    image = bufferedImage;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    image = image.getScaledInstance(image.getWidth(null) / 2, image.getHeight(null) / 2, 4);
                }
                affineTransform.scale(2.0, 2.0);
                graphics.scale(2.0, 2.0);
            }
        }
        return image;
    }

    protected Image scaleInternImage(int width, int height, Image image) {
        while (image.getWidth(null) > width * 2 || image.getHeight(null) > height * 2) {
            try {
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null) / 2, image.getHeight(null) / 2, image instanceof BufferedImage ? ((BufferedImage)image).getType() : 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(image, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                image = bufferedImage;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                image = image.getScaledInstance(image.getWidth(null) / 2, image.getHeight(null) / 2, 4);
            }
        }
        return image;
    }

    public void writeTo(DataOutput out) throws IOException {
        if (out != null) {
            if (this.a == MethodNames.SET_TRANSFORM && !((GraphicsObjectID)this.b[0]).b()) {
                return;
            }
            out.writeInt(this.a.ordinal());
            switch (this.a) {
                case SET_PAINT_CUSTOM: {
                    this.a(out, this.b[0]);
                    break;
                }
                case CREATE: {
                    break;
                }
                case ADD_RENDERING_HINTS: {
                    this.a(out, (Map)this.b[0]);
                    break;
                }
                case SET_CLIP_WITH_SHAPE: {
                    boolean bl = (Boolean)this.b[0];
                    out.writeBoolean(bl);
                    if (bl) {
                        out.writeInt((Integer)this.b[1]);
                        break;
                    }
                    this.a(out, (Shape)this.b[1]);
                    break;
                }
                case CLIP: 
                case DRAW: 
                case FILL: {
                    this.a(out, (Shape)this.b[0]);
                    break;
                }
                case DRAW_IMAGE_WITH_XFORM: 
                case DRAW_RENDERABLE_IMAGE: 
                case DRAW_RENDERED_IMAGE: {
                    this.writeImage(out, (Image)this.b[0]);
                    this.a(out, (AffineTransform)this.b[1]);
                    break;
                }
                case DRAW_IMAGE_WITH_OBS: {
                    this.writeImage(out, (Image)this.b[0]);
                    BufferedGraphicsCommand.a(2, 1, this.b, out);
                    break;
                }
                case DRAW_IMAGE_WITH_BUFF_IMG: {
                    this.writeImage(out, (Image)this.b[0]);
                    BufferedGraphicsCommand.a(2, 2, this.b, out);
                    break;
                }
                case DRAW_IMAGE_WITH_BG: {
                    this.writeImage(out, (Image)this.b[0]);
                    BufferedGraphicsCommand.a(2, 1, this.b, out);
                    this.a(out, (Color)this.b[3]);
                    break;
                }
                case DRAW_IMAGE_WITH_SIZE: {
                    this.writeImage(out, (Image)this.b[0]);
                    BufferedGraphicsCommand.a(4, 1, this.b, out);
                    break;
                }
                case DRAW_IMAGE_WITH_SIZE_AND_BG: {
                    this.writeImage(out, (Image)this.b[0]);
                    BufferedGraphicsCommand.a(4, 1, this.b, out);
                    this.a(out, (Color)this.b[5]);
                    break;
                }
                case DRAW_IMAGE_WITH_CORNER_AND_BG: {
                    this.writeImage(out, (Image)this.b[0]);
                    BufferedGraphicsCommand.a(8, 1, this.b, out);
                    this.a(out, (Color)this.b[9]);
                    break;
                }
                case DRAW_STRING_WITH_INT: {
                    out.writeUTF((String)this.b[0]);
                    BufferedGraphicsCommand.a(2, 1, this.b, out);
                    break;
                }
                case DRAW_STRING_WITH_FLOAT: {
                    out.writeUTF((String)this.b[0]);
                    out.writeFloat(((Float)this.b[1]).floatValue());
                    out.writeFloat(((Float)this.b[2]).floatValue());
                    break;
                }
                case HIT: {
                    Rectangle rectangle = (Rectangle)this.b[0];
                    out.writeInt(rectangle.x);
                    out.writeInt(rectangle.y);
                    out.writeInt(rectangle.width);
                    out.writeInt(rectangle.height);
                    this.a(out, (Shape)this.b[1]);
                    out.writeBoolean((Boolean)this.b[2]);
                    break;
                }
                case ROTATE_WITH_COORDS: {
                    out.writeDouble((Double)this.b[0]);
                    out.writeDouble((Double)this.b[1]);
                    out.writeDouble((Double)this.b[2]);
                    break;
                }
                case SCALE: 
                case SHEAR: 
                case TRANSLATE_WITH_DOUBLE: {
                    out.writeDouble((Double)this.b[0]);
                    out.writeDouble((Double)this.b[1]);
                    break;
                }
                case ROTATE: {
                    out.writeDouble((Double)this.b[0]);
                    break;
                }
                case SET_COMPOSITE: {
                    this.writeComposite(out, (Composite)this.b[0]);
                    break;
                }
                case SETPAINT: {
                    out.writeInt(((Color)this.b[0]).getRGB());
                    break;
                }
                case SET_GRADIENT_PAINT: {
                    GradientPaint gradientPaint = (GradientPaint)this.b[0];
                    Point2D point2D = gradientPaint.getPoint1();
                    out.writeFloat((float)point2D.getX());
                    out.writeFloat((float)point2D.getY());
                    out.writeInt(gradientPaint.getColor1().getRGB());
                    point2D = gradientPaint.getPoint2();
                    out.writeFloat((float)point2D.getX());
                    out.writeFloat((float)point2D.getY());
                    out.writeInt(gradientPaint.getColor2().getRGB());
                    out.writeBoolean(gradientPaint.isCyclic());
                    break;
                }
                case SET_RADIAL_GRADIENT_PAINT: {
                    RadialGradientPaint radialGradientPaint = (RadialGradientPaint)this.b[0];
                    Point2D point2D = radialGradientPaint.getCenterPoint();
                    out.writeFloat((float)point2D.getX());
                    out.writeFloat((float)point2D.getY());
                    out.writeFloat(radialGradientPaint.getRadius());
                    point2D = radialGradientPaint.getFocusPoint();
                    out.writeFloat((float)point2D.getX());
                    out.writeFloat((float)point2D.getY());
                    this.a(out, radialGradientPaint.getFractions());
                    this.a(out, radialGradientPaint.getColors());
                    out.writeInt(radialGradientPaint.getCycleMethod().ordinal());
                    break;
                }
                case SET_LINEAR_GRADIENT_PAINT: {
                    LinearGradientPaint linearGradientPaint = (LinearGradientPaint)this.b[0];
                    Point2D point2D = linearGradientPaint.getStartPoint();
                    out.writeFloat((float)point2D.getX());
                    out.writeFloat((float)point2D.getY());
                    point2D = linearGradientPaint.getEndPoint();
                    out.writeFloat((float)point2D.getX());
                    out.writeFloat((float)point2D.getY());
                    this.a(out, linearGradientPaint.getFractions());
                    this.a(out, linearGradientPaint.getColors());
                    out.writeInt(linearGradientPaint.getCycleMethod().ordinal());
                    out.writeInt(linearGradientPaint.getColorSpace().ordinal());
                    this.a(out, linearGradientPaint.getTransform());
                    break;
                }
                case SET_TEXTURE_PAINT: {
                    TexturePaint texturePaint = (TexturePaint)this.b[0];
                    this.writeImage(out, texturePaint.getImage());
                    Rectangle2D rectangle2D = texturePaint.getAnchorRect();
                    out.writeFloat((float)rectangle2D.getX());
                    out.writeFloat((float)rectangle2D.getY());
                    out.writeFloat((float)rectangle2D.getWidth());
                    out.writeFloat((float)rectangle2D.getHeight());
                    break;
                }
                case SET_STROKE: {
                    BasicStroke basicStroke = (BasicStroke)this.b[0];
                    out.writeFloat(basicStroke.getLineWidth());
                    out.writeInt(basicStroke.getEndCap());
                    out.writeInt(basicStroke.getLineJoin());
                    out.writeFloat(basicStroke.getMiterLimit());
                    float[] fArray = basicStroke.getDashArray();
                    int n2 = fArray == null ? -1 : fArray.length;
                    out.writeInt(n2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        out.writeFloat(fArray[i2]);
                    }
                    out.writeFloat(basicStroke.getDashPhase());
                    break;
                }
                case TRANSFORM: {
                    this.a(out, (AffineTransform)this.b[0]);
                    break;
                }
                case SET_TRANSFORM: {
                    out.writeInt(((GraphicsObjectID)this.b[0]).intValue());
                    break;
                }
                case SET_RENDERING_HINTS: {
                    this.a(out, (Map)this.b[0]);
                    break;
                }
                case SET_RENDERING_HINT: {
                    this.a(out);
                    break;
                }
                case DRAW_IMAGE_WITH_CORNER: {
                    this.writeImage(out, (Image)this.b[0]);
                    BufferedGraphicsCommand.a(8, 1, this.b, out);
                    break;
                }
                case COPY_AREA: 
                case DRAW_ARC: 
                case DRAW_ROUND_RECT: 
                case FILL_ARC: 
                case FILL_ROUND_RECT: {
                    BufferedGraphicsCommand.a(6, 0, this.b, out);
                    break;
                }
                case CLEAR_RECT: 
                case CLIP_RECT: 
                case DRAW_LINE: 
                case DRAW_OVAL: 
                case FILL_OVAL: 
                case FILL_RECT: 
                case SET_CLIP: {
                    BufferedGraphicsCommand.a(4, 0, this.b, out);
                    break;
                }
                case GET_CLIP: {
                    out.writeInt((Integer)this.b[0]);
                    break;
                }
                case TRANSLATE_WITH_INT: {
                    BufferedGraphicsCommand.a(2, 0, this.b, out);
                    break;
                }
                case DISPOSE: 
                case SET_PAINT_MODE: {
                    break;
                }
                case DRAW_POLYGON: 
                case DRAW_POLYLINE: 
                case FILL_POLYGON: {
                    for (int i3 = 0; i3 < 2; ++i3) {
                        int[] nArray = (int[])this.b[i3];
                        out.writeInt(nArray.length);
                        for (int n3 : nArray) {
                            out.writeInt(n3);
                        }
                    }
                    out.writeInt((Integer)this.b[2]);
                    break;
                }
                case SET_BACKGROUND: 
                case SET_COLOR: 
                case SET_XOR_MODE: {
                    this.a(out, (Color)this.b[0]);
                    break;
                }
                case SET_FONT: {
                    this.writeFont(out, (Font)this.b[0]);
                    break;
                }
                case GET_TRANSFORM: {
                    break;
                }
                case ADDLAYER: {
                    out.writeBoolean((Boolean)this.b[0]);
                    out.writeBoolean((Boolean)this.b[1]);
                    this.writeComposite(out, (Composite)this.b[2]);
                    break;
                }
                case INITIALIZE: {
                    Rectangle2D rectangle2D = (Rectangle2D)this.b[0];
                    AffineTransform affineTransform = (AffineTransform)this.b[1];
                    out.writeDouble(rectangle2D.getX());
                    out.writeDouble(rectangle2D.getY());
                    out.writeDouble(rectangle2D.getWidth());
                    out.writeDouble(rectangle2D.getHeight());
                    this.a(out, affineTransform);
                    break;
                }
                case DRAWLAYER: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Kein Methodenname gefunden:" + this.a.toString());
                }
            }
        }
    }

    private void a(DataOutput dataOutput, Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            dataOutput.writeInt(byteArrayOutputStream.size());
            dataOutput.write(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Kann nicht serialisieren:" + object.getClass().getName(), iOException);
        }
    }

    protected void writeComposite(DataOutput out, Composite composite) throws IOException {
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)this.b[0];
            out.writeByte(0);
            out.writeInt(alphaComposite.getRule());
            out.writeFloat(alphaComposite.getAlpha());
        } else if (composite instanceof BlendComposite) {
            BlendComposite blendComposite = (BlendComposite)composite;
            out.writeByte(1);
            out.writeInt(0);
            out.writeFloat(blendComposite.getAlpha());
            out.writeByte(blendComposite.getMode().getId());
            boolean bl = blendComposite.getMask() != null;
            out.writeBoolean(bl);
            if (bl) {
                this.writeImage(out, blendComposite.getMask());
            }
        }
    }

    private void a(DataOutput dataOutput, float[] fArray) throws IOException {
        dataOutput.writeInt(fArray.length);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            dataOutput.writeFloat(fArray[i2]);
        }
    }

    private void a(DataOutput dataOutput, Color[] colorArray) throws IOException {
        dataOutput.writeInt(colorArray.length);
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            dataOutput.writeInt(colorArray[i2].getRGB());
        }
    }

    private void a(DataOutput dataOutput) throws IOException {
        RenderingHints.Key key = (RenderingHints.Key)this.b[0];
        Object object = this.b[1];
        this.a(dataOutput, Collections.singletonMap(key, object));
    }

    private void a(DataOutput dataOutput, Map<?, ?> map) throws IOException {
        Set<?> set = map.keySet();
        dataOutput.writeInt(set.size());
        for (Object obj : set) {
            Object obj2 = map.get(obj);
            if (obj instanceof RenderingHints.Key) {
                if (RenderingHints.KEY_ANTIALIASING.equals(obj)) {
                    dataOutput.writeInt(0);
                    if (RenderingHints.VALUE_ANTIALIAS_ON.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_ANTIALIAS_OFF.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_ANTIALIAS_DEFAULT.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_RENDERING.equals(obj)) {
                    dataOutput.writeInt(1);
                    if (RenderingHints.VALUE_RENDER_SPEED.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_RENDER_QUALITY.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_RENDER_DEFAULT.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_DITHERING.equals(obj)) {
                    dataOutput.writeInt(2);
                    if (RenderingHints.VALUE_DITHER_DISABLE.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_DITHER_ENABLE.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_DITHER_DEFAULT.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_TEXT_ANTIALIASING.equals(obj)) {
                    dataOutput.writeInt(3);
                    if (RenderingHints.VALUE_TEXT_ANTIALIAS_ON.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_TEXT_ANTIALIAS_OFF.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    if (RenderingHints.VALUE_TEXT_ANTIALIAS_GASP.equals(obj2)) {
                        dataOutput.writeInt(3);
                        continue;
                    }
                    if (RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB.equals(obj2)) {
                        dataOutput.writeInt(4);
                        continue;
                    }
                    if (RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR.equals(obj2)) {
                        dataOutput.writeInt(5);
                        continue;
                    }
                    if (RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB.equals(obj2)) {
                        dataOutput.writeInt(6);
                        continue;
                    }
                    if (RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR.equals(obj2)) {
                        dataOutput.writeInt(7);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_TEXT_LCD_CONTRAST.equals(obj)) {
                    dataOutput.writeInt(4);
                    if (obj2 instanceof Integer) {
                        dataOutput.writeInt((Integer)obj2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_FRACTIONALMETRICS.equals(obj)) {
                    dataOutput.writeInt(5);
                    if (RenderingHints.VALUE_FRACTIONALMETRICS_OFF.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_FRACTIONALMETRICS_ON.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_INTERPOLATION.equals(obj)) {
                    dataOutput.writeInt(6);
                    if (RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_INTERPOLATION_BILINEAR.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_INTERPOLATION_BICUBIC.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_ALPHA_INTERPOLATION.equals(obj)) {
                    dataOutput.writeInt(7);
                    if (RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_COLOR_RENDERING.equals(obj)) {
                    dataOutput.writeInt(8);
                    if (RenderingHints.VALUE_COLOR_RENDER_SPEED.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_COLOR_RENDER_QUALITY.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_COLOR_RENDER_DEFAULT.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (RenderingHints.KEY_STROKE_CONTROL.equals(obj)) {
                    dataOutput.writeInt(9);
                    if (RenderingHints.VALUE_STROKE_DEFAULT.equals(obj2)) {
                        dataOutput.writeInt(0);
                        continue;
                    }
                    if (RenderingHints.VALUE_STROKE_NORMALIZE.equals(obj2)) {
                        dataOutput.writeInt(1);
                        continue;
                    }
                    if (RenderingHints.VALUE_STROKE_PURE.equals(obj2)) {
                        dataOutput.writeInt(2);
                        continue;
                    }
                    dataOutput.writeInt(-1);
                    continue;
                }
                if (!RenderingHintLowerImage.KEY.equals(obj)) continue;
                dataOutput.writeInt(10);
                dataOutput.writeInt((Integer)obj2);
                continue;
            }
            dataOutput.writeInt(-1);
            dataOutput.writeInt(-1);
        }
    }

    private static void a(int n2, int n3, Object[] objectArray, DataOutput dataOutput) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeInt((Integer)objectArray[i2 + n3]);
        }
    }

    private final void a(DataOutput dataOutput, Color color) throws IOException {
        dataOutput.writeInt(color.getRGB());
    }

    private void a(DataOutput dataOutput, AffineTransform affineTransform) throws IOException {
        dataOutput.writeDouble(affineTransform.getScaleX());
        dataOutput.writeDouble(affineTransform.getShearY());
        dataOutput.writeDouble(affineTransform.getShearX());
        dataOutput.writeDouble(affineTransform.getScaleY());
        dataOutput.writeDouble(affineTransform.getTranslateX());
        dataOutput.writeDouble(affineTransform.getTranslateY());
    }

    protected void writeFont(DataOutput out, Font font) throws IOException {
        out.writeUTF(font.getName());
        out.writeInt(font.getStyle());
        out.writeInt(font.getSize());
    }

    private final void a(DataOutput dataOutput, Shape shape) throws IOException {
        if (shape == null) {
            dataOutput.writeInt(-1);
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        int n2 = pathIterator.getWindingRule();
        dataOutput.writeInt(n2);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            dataOutput.writeInt(n3);
            switch (n3) {
                case 0: 
                case 1: {
                    dataOutput.writeFloat(fArray[0]);
                    dataOutput.writeFloat(fArray[1]);
                    break;
                }
                case 2: {
                    dataOutput.writeFloat(fArray[0]);
                    dataOutput.writeFloat(fArray[1]);
                    dataOutput.writeFloat(fArray[2]);
                    dataOutput.writeFloat(fArray[3]);
                    break;
                }
                case 3: {
                    dataOutput.writeFloat(fArray[0]);
                    dataOutput.writeFloat(fArray[1]);
                    dataOutput.writeFloat(fArray[2]);
                    dataOutput.writeFloat(fArray[3]);
                    dataOutput.writeFloat(fArray[4]);
                    dataOutput.writeFloat(fArray[5]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown Shape Segment type:" + n3);
                }
            }
            pathIterator.next();
        }
        dataOutput.writeInt(-1);
    }

    protected void writeImage(DataOutput out, Image image) throws IOException {
        byte[] byArray = PNGEncoder.getPNGImageData(image);
        out.writeInt(byArray.length);
        out.write(byArray);
    }

    public int getId() {
        return this.c;
    }

    public MethodNames getName() {
        return this.a;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.c);
        stringBuilder.append("]");
        stringBuilder.append(this.a.name());
        stringBuilder.append("( ");
        if (this.b == null) {
            stringBuilder.append("***NULL PARAMS***");
        } else {
            for (Object object : this.b) {
                if (object instanceof String) {
                    stringBuilder.append("\"" + object.toString() + "\"");
                } else if (object instanceof GeneralPath) {
                    GeneralPath generalPath = (GeneralPath)object;
                    PathIterator pathIterator = generalPath.getPathIterator(null);
                    int n2 = pathIterator.getWindingRule();
                    stringBuilder.append("windingRule=" + n2);
                    stringBuilder.append("(");
                    float[] fArray = new float[6];
                    while (!pathIterator.isDone()) {
                        int n3 = pathIterator.currentSegment(fArray);
                        stringBuilder.append("type=" + n3 + "  ");
                        stringBuilder.append(Arrays.toString(fArray));
                        stringBuilder.append(",");
                        pathIterator.next();
                    }
                    stringBuilder.append(")");
                } else if (object instanceof Number || object instanceof Double || object instanceof Paint || object instanceof Shape || object instanceof AffineTransform) {
                    stringBuilder.append(object.toString());
                } else {
                    stringBuilder.append((String)(object == null ? "null" : object.getClass().getSimpleName() + ":" + object.toString()));
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void setMethod(MethodNames name) {
        this.a = name;
    }

    public void setParameter(int idx, Object value) {
        this.b[idx] = value;
    }

    public Object[] getParameters() {
        return this.b;
    }

    private static boolean a(@Nonnull LayerGraphics2D layerGraphics2D) {
        if (layerGraphics2D.getRootGraphics() == null) {
            return false;
        }
        Graphics2D graphics2D = layerGraphics2D.getRootGraphics();
        Class<?> clazz = graphics2D.getClass();
        return clazz.getName().equals("sun.java2d.SunGraphics2D");
    }

    @InternalApi
    public static final class MethodNames
    extends Enum<MethodNames> {
        public static final /* enum */ MethodNames ADD_RENDERING_HINTS = new MethodNames();
        public static final /* enum */ MethodNames CLIP = new MethodNames();
        public static final /* enum */ MethodNames DRAW = new MethodNames();
        public static final /* enum */ MethodNames DRAW_GLYPH_VECTOR = new MethodNames();
        public static final /* enum */ MethodNames DRAW_IMAGE_WITH_XFORM = new MethodNames();
        public static final /* enum */ MethodNames DRAW_IMAGE_WITH_BUFF_IMG = new MethodNames();
        public static final /* enum */ MethodNames DRAW_RENDERABLE_IMAGE = new MethodNames();
        public static final /* enum */ MethodNames DRAW_RENDERED_IMAGE = new MethodNames();
        public static final /* enum */ MethodNames DRAW_STRING_WITH_INT = new MethodNames();
        public static final /* enum */ MethodNames DRAW_STRING_WITH_FLOAT = new MethodNames();
        public static final /* enum */ MethodNames DRAW_STRING_WITH_ACI_AND_INT = new MethodNames();
        public static final /* enum */ MethodNames DRAW_STRING_WITH_ACI_AND_FLOAT = new MethodNames();
        public static final /* enum */ MethodNames FILL = new MethodNames();
        public static final /* enum */ MethodNames GET_BACKGROUND = new MethodNames();
        public static final /* enum */ MethodNames GET_COMPOSITE = new MethodNames();
        public static final /* enum */ MethodNames GET_DEVICE_CONFIGURATION = new MethodNames();
        public static final /* enum */ MethodNames GET_FONT_RENDER_CONTEXT = new MethodNames();
        public static final /* enum */ MethodNames GET_PAINT = new MethodNames();
        public static final /* enum */ MethodNames GET_RENDERING_HINT = new MethodNames();
        public static final /* enum */ MethodNames GET_RENDERING_HINTS = new MethodNames();
        public static final /* enum */ MethodNames GET_STROKE = new MethodNames();
        public static final /* enum */ MethodNames GET_TRANSFORM = new MethodNames();
        public static final /* enum */ MethodNames HIT = new MethodNames();
        public static final /* enum */ MethodNames ROTATE = new MethodNames();
        public static final /* enum */ MethodNames ROTATE_WITH_COORDS = new MethodNames();
        public static final /* enum */ MethodNames SCALE = new MethodNames();
        public static final /* enum */ MethodNames SET_BACKGROUND = new MethodNames();
        public static final /* enum */ MethodNames SET_COMPOSITE = new MethodNames();
        public static final /* enum */ MethodNames SETPAINT = new MethodNames();
        public static final /* enum */ MethodNames SET_RENDERING_HINT = new MethodNames();
        public static final /* enum */ MethodNames SET_RENDERING_HINTS = new MethodNames();
        public static final /* enum */ MethodNames SET_STROKE = new MethodNames();
        public static final /* enum */ MethodNames SET_TRANSFORM = new MethodNames();
        public static final /* enum */ MethodNames SHEAR = new MethodNames();
        public static final /* enum */ MethodNames TRANSFORM = new MethodNames();
        public static final /* enum */ MethodNames TRANSLATE_WITH_INT = new MethodNames();
        public static final /* enum */ MethodNames TRANSLATE_WITH_DOUBLE = new MethodNames();
        public static final /* enum */ MethodNames CLEAR_RECT = new MethodNames();
        public static final /* enum */ MethodNames CLIP_RECT = new MethodNames();
        public static final /* enum */ MethodNames COPY_AREA = new MethodNames();
        public static final /* enum */ MethodNames CREATE = new MethodNames();
        public static final /* enum */ MethodNames DISPOSE = new MethodNames();
        public static final /* enum */ MethodNames DRAW_ARC = new MethodNames();
        public static final /* enum */ MethodNames DRAW_IMAGE_WITH_OBS = new MethodNames();
        public static final /* enum */ MethodNames DRAW_IMAGE_WITH_BG = new MethodNames();
        public static final /* enum */ MethodNames DRAW_IMAGE_WITH_SIZE = new MethodNames();
        public static final /* enum */ MethodNames DRAW_IMAGE_WITH_SIZE_AND_BG = new MethodNames();
        public static final /* enum */ MethodNames DRAW_IMAGE_WITH_CORNER = new MethodNames();
        public static final /* enum */ MethodNames DRAW_IMAGE_WITH_CORNER_AND_BG = new MethodNames();
        public static final /* enum */ MethodNames DRAW_LINE = new MethodNames();
        public static final /* enum */ MethodNames DRAW_OVAL = new MethodNames();
        public static final /* enum */ MethodNames DRAW_POLYGON = new MethodNames();
        public static final /* enum */ MethodNames DRAW_POLYLINE = new MethodNames();
        public static final /* enum */ MethodNames DRAW_ROUND_RECT = new MethodNames();
        public static final /* enum */ MethodNames FILL_ARC = new MethodNames();
        public static final /* enum */ MethodNames FILL_OVAL = new MethodNames();
        public static final /* enum */ MethodNames FILL_POLYGON = new MethodNames();
        public static final /* enum */ MethodNames FILL_RECT = new MethodNames();
        public static final /* enum */ MethodNames FILL_ROUND_RECT = new MethodNames();
        public static final /* enum */ MethodNames GET_CLIP = new MethodNames();
        public static final /* enum */ MethodNames GET_CLIP_BOUNDS = new MethodNames();
        public static final /* enum */ MethodNames GET_COLOR = new MethodNames();
        public static final /* enum */ MethodNames GET_FONT = new MethodNames();
        public static final /* enum */ MethodNames GET_FONT_METRICS = new MethodNames();
        public static final /* enum */ MethodNames SET_CLIP = new MethodNames();
        public static final /* enum */ MethodNames SET_CLIP_WITH_SHAPE = new MethodNames();
        public static final /* enum */ MethodNames SET_COLOR = new MethodNames();
        public static final /* enum */ MethodNames SET_FONT = new MethodNames();
        public static final /* enum */ MethodNames SET_PAINT_MODE = new MethodNames();
        public static final /* enum */ MethodNames SET_XOR_MODE = new MethodNames();
        public static final /* enum */ MethodNames SET_GRADIENT_PAINT = new MethodNames();
        public static final /* enum */ MethodNames GRAPHICS_SWITCH = new MethodNames();
        public static final /* enum */ MethodNames END_FLAG = new MethodNames();
        public static final /* enum */ MethodNames SET_RADIAL_GRADIENT_PAINT = new MethodNames();
        public static final /* enum */ MethodNames SET_LINEAR_GRADIENT_PAINT = new MethodNames();
        public static final /* enum */ MethodNames SET_PAINT_CUSTOM = new MethodNames();
        public static final /* enum */ MethodNames SET_TEXTURE_PAINT = new MethodNames();
        public static final /* enum */ MethodNames ADDLAYER = new MethodNames();
        public static final /* enum */ MethodNames INITIALIZE = new MethodNames();
        public static final /* enum */ MethodNames DRAWLAYER = new MethodNames();
        private static final /* synthetic */ MethodNames[] a;

        public static MethodNames[] values() {
            return (MethodNames[])a.clone();
        }

        public static MethodNames valueOf(String name) {
            return Enum.valueOf(MethodNames.class, name);
        }

        private static /* synthetic */ MethodNames[] a() {
            return new MethodNames[]{ADD_RENDERING_HINTS, CLIP, DRAW, DRAW_GLYPH_VECTOR, DRAW_IMAGE_WITH_XFORM, DRAW_IMAGE_WITH_BUFF_IMG, DRAW_RENDERABLE_IMAGE, DRAW_RENDERED_IMAGE, DRAW_STRING_WITH_INT, DRAW_STRING_WITH_FLOAT, DRAW_STRING_WITH_ACI_AND_INT, DRAW_STRING_WITH_ACI_AND_FLOAT, FILL, GET_BACKGROUND, GET_COMPOSITE, GET_DEVICE_CONFIGURATION, GET_FONT_RENDER_CONTEXT, GET_PAINT, GET_RENDERING_HINT, GET_RENDERING_HINTS, GET_STROKE, GET_TRANSFORM, HIT, ROTATE, ROTATE_WITH_COORDS, SCALE, SET_BACKGROUND, SET_COMPOSITE, SETPAINT, SET_RENDERING_HINT, SET_RENDERING_HINTS, SET_STROKE, SET_TRANSFORM, SHEAR, TRANSFORM, TRANSLATE_WITH_INT, TRANSLATE_WITH_DOUBLE, CLEAR_RECT, CLIP_RECT, COPY_AREA, CREATE, DISPOSE, DRAW_ARC, DRAW_IMAGE_WITH_OBS, DRAW_IMAGE_WITH_BG, DRAW_IMAGE_WITH_SIZE, DRAW_IMAGE_WITH_SIZE_AND_BG, DRAW_IMAGE_WITH_CORNER, DRAW_IMAGE_WITH_CORNER_AND_BG, DRAW_LINE, DRAW_OVAL, DRAW_POLYGON, DRAW_POLYLINE, DRAW_ROUND_RECT, FILL_ARC, FILL_OVAL, FILL_POLYGON, FILL_RECT, FILL_ROUND_RECT, GET_CLIP, GET_CLIP_BOUNDS, GET_COLOR, GET_FONT, GET_FONT_METRICS, SET_CLIP, SET_CLIP_WITH_SHAPE, SET_COLOR, SET_FONT, SET_PAINT_MODE, SET_XOR_MODE, SET_GRADIENT_PAINT, GRAPHICS_SWITCH, END_FLAG, SET_RADIAL_GRADIENT_PAINT, SET_LINEAR_GRADIENT_PAINT, SET_PAINT_CUSTOM, SET_TEXTURE_PAINT, ADDLAYER, INITIALIZE, DRAWLAYER};
        }

        static {
            a = MethodNames.a();
        }
    }
}

