/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.layout;

import com.inet.font.CharMetricsProvider;
import com.inet.font.layout.FontLayout;
import com.inet.font.truetype.InstalledFontTT;
import com.inet.shared.bidi.BidiString;

public class TTFontLayout
extends FontLayout
implements CharMetricsProvider {
    private final InstalledFontTT a;
    private final int b;
    private final int c;
    private final int d;

    public TTFontLayout(InstalledFontTT installedFont, String name, int fontStyle, int sizeTwips) {
        super(name, fontStyle, sizeTwips);
        this.a = installedFont;
        this.b = (this.a.getAscent() * sizeTwips + 500) / 1000;
        this.c = (Math.abs(this.a.getDescent()) * sizeTwips + 500) / 1000;
        this.d = (this.a.getLineGap() * sizeTwips + 500) / 1000;
        double d2 = this.a.getTTFont().getItalicData();
        if (d2 < 0.0) {
            this.setItalicIndent((int)Math.ceil((double)this.b * Math.toRadians(-d2) / 2.0));
        }
    }

    @Override
    public int charWidth(int c2) {
        return (this.a.getCharWidth(c2, this.getSizeTwips(), this.getStyle()) + 500) / 1000;
    }

    @Override
    public final int getAscent() {
        return this.b;
    }

    @Override
    public final int getDescent() {
        return this.c;
    }

    @Override
    public final int getLeading() {
        return this.d;
    }

    @Override
    public int stringWidthSpecial(String text) {
        text = BidiString.reorder(text);
        int n2 = 0;
        int n3 = text.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = text.charAt(i2);
            if (Character.isHighSurrogate(c2) && i2 < n3 - 1) {
                n2 += this.charWidth(Character.toCodePoint(c2, text.charAt(++i2)));
                continue;
            }
            n2 += this.charWidth(c2);
        }
        return n2;
    }

    public boolean isEmbedded() {
        return this.a.isEmbedded();
    }

    public InstalledFontTT getInstalledFontTT() {
        return this.a;
    }

    @Override
    public boolean canDisplay(char ch) {
        return this.a.canDisplay(ch);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TTFontLayout) {
            TTFontLayout tTFontLayout = (TTFontLayout)obj;
            return tTFontLayout.getSizeTwips() == this.getSizeTwips() && tTFontLayout.getStyle() == this.getStyle() && tTFontLayout.getName().equals(this.getName()) && tTFontLayout.a.equals(this.a);
        }
        return false;
    }

    @Override
    public boolean isSymbolCodePage() {
        return this.a.isSymbolCodePage();
    }

    public int getNativeStyle() {
        return this.a.getNativeStyle();
    }

    public int registerCharactersAndCalculateWidth(String text, boolean glyphsUP) {
        text = BidiString.reorder(text);
        int n2 = 0;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            n2 += this.charWidth(c2);
        }
        return n2;
    }

    public TTFontLayout scaleFontLayout(int fontSizeTwips) {
        return new TTFontLayout(this.getInstalledFontTT(), this.getName(), this.getNativeStyle(), fontSizeTwips);
    }

    @Override
    public int getWidth(char ch) {
        return this.a.getCharWidth(ch, 20, 0);
    }
}

