/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.cache;

import com.inet.annotations.InternalApi;
import com.inet.font.FontPool;
import com.inet.font.FontUtils;
import com.inet.font.cache.FontNameProcessor;
import com.inet.font.layout.AdobeCourierFontLayout;
import com.inet.font.layout.AdobeFontLayout;
import com.inet.font.layout.AdobeHelveticaBoldFontLayout;
import com.inet.font.layout.AdobeHelveticaBoldObliqueFontLayout;
import com.inet.font.layout.AdobeHelveticaNormalFontLayout;
import com.inet.font.layout.AdobeHelveticaObliqueFontLayout;
import com.inet.font.layout.AdobeSymbolFontLayout;
import com.inet.font.layout.AdobeTimesBoldFontLayout;
import com.inet.font.layout.AdobeTimesBoldItalicFontLayout;
import com.inet.font.layout.AdobeTimesItalicFontLayout;
import com.inet.font.layout.AdobeTimesNormalFontLayout;
import com.inet.font.layout.FontLayout;
import com.inet.font.layout.JavaFontLayout;
import com.inet.font.layout.SoftFontLayoutMap;
import com.inet.font.layout.TTFontLayout;
import com.inet.font.truetype.InstalledFontTT;
import com.inet.font.truetype.ReplacingFontFinder;
import com.inet.font.truetype.SubFontTT;
import java.awt.Font;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalApi
public class FontCache {
    private final SoftFontLayoutMap a = new SoftFontLayoutMap();
    private SoftFontLayoutMap b = new SoftFontLayoutMap();
    private boolean c = false;

    public FontCache() {
        SubFontTT subFontTT = FontPool.getInstalledFont("EUDC", 0, null, null);
        if (subFontTT != null) {
            this.c = true;
        }
    }

    public TTFontLayout getEUDCfont(int size, int style, ReplacingFontFinder replacingFontFinder) {
        if (!this.c) {
            return null;
        }
        return this.getTTFontLayout("EUDC", style, size, replacingFontFinder);
    }

    @Nonnull
    public final FontLayout getFontLayout(String fontName, int ccFontStyle, int sizeTwips, boolean onlyLogicalFonts) {
        return this.getFontLayout(fontName, ccFontStyle, sizeTwips, onlyLogicalFonts, true);
    }

    @Nonnull
    public final FontLayout getFontLayout(String fontName, int ccFontStyle, int sizeTwips, boolean onlyLogical, boolean isFractional) {
        int n2 = ccFontStyle & 3;
        FontLayout fontLayout = this.a.get(fontName, n2, sizeTwips);
        if (fontLayout == null) {
            if (FontUtils.getSettings().isUseNativeFonts()) {
                InstalledFontTT installedFontTT = FontPool.getNonEmbeddedFont(fontName, n2, null);
                if (installedFontTT == null && n2 != 0) {
                    installedFontTT = FontPool.getNonEmbeddedFont(fontName, 0, null);
                }
                if (installedFontTT != null) {
                    fontLayout = new TTFontLayout(installedFontTT, fontName, n2, sizeTwips);
                }
            }
            if (fontLayout == null) {
                fontLayout = new JavaFontLayout(this.getFloatingFont(fontName, n2, sizeTwips), fontName, sizeTwips, isFractional);
            }
            this.a.put(fontLayout);
        }
        return fontLayout;
    }

    public final TTFontLayout getTTFontLayout(String fontName, int ccFontStyle, int sizeTwips, ReplacingFontFinder fontFinder) {
        FontLayout fontLayout;
        ccFontStyle &= 3;
        SoftFontLayoutMap softFontLayoutMap = null;
        if (fontFinder != null) {
            softFontLayoutMap = fontFinder.getFontLayoutMap();
        }
        if (softFontLayoutMap == null) {
            softFontLayoutMap = this.a;
        }
        if ((fontLayout = softFontLayoutMap.get(fontName, ccFontStyle, sizeTwips)) instanceof TTFontLayout) {
            return (TTFontLayout)fontLayout;
        }
        String string = FontNameProcessor.getCompositeName(fontName, ccFontStyle);
        SubFontTT subFontTT = null;
        Map map = null;
        if (fontFinder != null) {
            map = fontFinder.getInstalledFontMap();
            subFontTT = (SubFontTT)map.get(string);
        }
        if (subFontTT == null) {
            subFontTT = FontPool.getEmbeddedFont(fontName, ccFontStyle, fontFinder);
        }
        if (subFontTT != null && map != null) {
            map.put(string, subFontTT);
        }
        if (subFontTT != null) {
            if (fontFinder != null && fontFinder.isJAVA_EXPORT() && subFontTT.getTTFont().getFontCollection().isProblematic()) {
                return null;
            }
            TTFontLayout tTFontLayout = new TTFontLayout(subFontTT, fontName, ccFontStyle, sizeTwips);
            softFontLayoutMap.put(tTFontLayout);
            return tTFontLayout;
        }
        return null;
    }

    public final Font getFloatingFont(String fontName, int style, int sizeTwips) {
        return FontUtils.getFloatingFont(fontName, style, sizeTwips);
    }

    public final FontLayout getAdobeFontLayout(int fontFamilyId, String fontName, int ccFontStyle, int sizeTwips, long range) {
        FontLayout fontLayout = this.b.get(fontName, ccFontStyle, sizeTwips, range);
        if (fontLayout == null) {
            if (fontFamilyId == -1) {
                fontFamilyId = AdobeFontLayout.getFontFamilyId(fontName, range);
            }
            FontLayout fontLayout2 = this.getFontLayout(fontName, ccFontStyle, sizeTwips, false, true);
            ccFontStyle &= 3;
            block0 : switch (fontFamilyId) {
                case 1: {
                    switch (ccFontStyle) {
                        case 0: {
                            fontLayout = new AdobeHelveticaNormalFontLayout(fontLayout2);
                            break;
                        }
                        case 1: {
                            fontLayout = new AdobeHelveticaBoldFontLayout(fontLayout2);
                            break;
                        }
                        case 2: {
                            fontLayout = new AdobeHelveticaObliqueFontLayout(fontLayout2);
                            break;
                        }
                        case 3: {
                            fontLayout = new AdobeHelveticaBoldObliqueFontLayout(fontLayout2);
                        }
                    }
                    break;
                }
                case 2: {
                    fontLayout = new AdobeCourierFontLayout(fontLayout2);
                    break;
                }
                case 3: {
                    fontLayout = new AdobeSymbolFontLayout(fontLayout2, range);
                    break;
                }
                default: {
                    switch (ccFontStyle) {
                        case 0: {
                            fontLayout = new AdobeTimesNormalFontLayout(fontLayout2);
                            break block0;
                        }
                        case 1: {
                            fontLayout = new AdobeTimesBoldFontLayout(fontLayout2);
                            break block0;
                        }
                        case 2: {
                            fontLayout = new AdobeTimesItalicFontLayout(fontLayout2);
                            break block0;
                        }
                        case 3: {
                            fontLayout = new AdobeTimesBoldItalicFontLayout(fontLayout2);
                        }
                    }
                }
            }
        }
        this.b.put(fontLayout);
        return fontLayout;
    }
}

