/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.migrator;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.ServerPluginManager;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AuthenticationConfigurationMigrator
implements ConfigurationMigrator {
    @Override
    public void migrate(Configuration config) {
        AuthenticationConfigurationMigrator.a(config);
        AuthenticationConfigurationMigrator.b(config);
    }

    private static void a(Configuration configuration) {
        HashMap<CallSite, String> hashMap;
        if (!StringFunctions.isEmpty(configuration.get(ConfigKey.AUTHENTICATION_SETTINGS.getKey()))) {
            return;
        }
        String string = configuration.get(ConfigKey.PERMISSION_LOGINTYPE.getKey());
        String string2 = configuration.get(ConfigKey.PERMISSION_LOGINURL.getKey());
        String string3 = configuration.get("DB_Auth");
        Boolean bl = (Boolean)configuration.getValue(ConfigKey.PERMISSION_GUEST_ACTIVATED);
        if (string == null) {
            if (string2 == null && StringFunctions.isEmpty(string3) && !bl.booleanValue()) {
                return;
            }
            string = "";
        }
        if (string2 != null && (StringFunctions.isEmpty(string) || "automatic".equals(string))) {
            hashMap = ServerPluginManager.getInstance();
            if (string2.startsWith("jdbc") && ((ServerPluginManager)((Object)hashMap)).isPluginLoaded("authentication.database")) {
                string = "database";
            } else if (string2.startsWith("ldap") && ((ServerPluginManager)((Object)hashMap)).isPluginLoaded("authentication.ldap")) {
                string = "ldap";
            } else if (string2.startsWith("http") && ((ServerPluginManager)((Object)hashMap)).isPluginLoaded("authentication.script")) {
                string = "external";
            }
        }
        hashMap = new HashMap();
        switch (string) {
            case "ldap": {
                Object object;
                ServerPluginManager serverPluginManager;
                String string4 = configuration.get("permission.default_domain");
                if (string4 != null) {
                    hashMap.put((CallSite)((Object)(string + ".default_domain")), string4);
                }
                if (!(serverPluginManager = ServerPluginManager.getInstance()).isPluginLoaded("authentication.ldap") && configuration.equals(ConfigurationManager.getInstance().getCurrent())) {
                    object = (Map)configuration.getValue(ConfigKey.PLUGINS_ACTIVATED);
                    object.put("authentication.ldap", Boolean.TRUE);
                    configuration.put(ConfigKey.PLUGINS_ACTIVATED, new Json().toJson(object));
                }
            }
            case "external": {
                Object object = configuration.get(ConfigKey.PERMISSION_LOGINURL_TRUSTALL.getKey());
                if (object != null) {
                    hashMap.put((CallSite)((Object)(string + ".trustall")), (String)object);
                }
            }
            case "database": {
                hashMap.put((CallSite)((Object)(string + ".loginurl")), string2);
            }
            case "windows": 
            case "pam": 
            case "internal": {
                hashMap.put((CallSite)((Object)"provider"), "system");
                hashMap.put((CallSite)((Object)"logintype"), string);
                break;
            }
            case "automatic": 
            case "": {
                hashMap.put((CallSite)((Object)"provider"), "system");
                break;
            }
            default: {
                hashMap.put((CallSite)((Object)"provider"), string);
            }
        }
        Object object = new ArrayList();
        object.add(hashMap);
        if (!StringFunctions.isEmpty(string3)) {
            try {
                int n2 = Integer.parseInt(string3);
                switch (n2) {
                    case 1: 
                    case 2: {
                        hashMap = new HashMap();
                        hashMap.put((CallSite)((Object)"provider"), "product");
                        hashMap.put((CallSite)((Object)"userCanRegister"), Boolean.toString(n2 == 2));
                        object.add(hashMap);
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                LogManager.getConfigLogger().error(throwable);
            }
        }
        if (bl.booleanValue()) {
            hashMap = new HashMap<CallSite, String>();
            hashMap.put((CallSite)((Object)"provider"), "guest");
            object.add(hashMap);
        }
        configuration.put(ConfigKey.AUTHENTICATION_SETTINGS.getKey(), new Json().toJson(object));
    }

    private static void b(Configuration configuration) {
        if (!StringFunctions.isEmpty(configuration.get(ConfigKey.AUTHENTICATION_ALLOW_NEW_USER.getKey()))) {
            return;
        }
        String string = configuration.get("clientstartoption");
        if (StringFunctions.isEmpty(string)) {
            return;
        }
        try {
            boolean bl = (Integer.parseInt(string) & 0x800) == 0;
            configuration.put(ConfigKey.AUTHENTICATION_ALLOW_NEW_USER.getKey(), Boolean.toString(bl));
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().error(exception);
        }
    }
}

