/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@InternalApi
public class ElementID
implements Comparable<ElementID>,
Serializable {
    @Nonnull
    public static final ElementID DUMMY = new ElementID();
    private int @Nonnull [] idLevels;

    private ElementID() {
        this.idLevels = new int[0];
    }

    public ElementID(int id) {
        this.idLevels = new int[]{id};
    }

    public ElementID(int ... idLevels) {
        this(true, idLevels);
    }

    public ElementID(boolean copy, int ... idLevels) {
        if (copy) {
            this.idLevels = new int[idLevels.length];
            System.arraycopy(idLevels, 0, this.idLevels, 0, idLevels.length);
        } else {
            this.idLevels = idLevels;
        }
    }

    public int @Nonnull [] getRaw() {
        return this.idLevels;
    }

    @Nonnull
    public ElementID getNext() {
        int[] levels = Arrays.copyOf(this.idLevels, this.idLevels.length);
        int n = levels.length - 1;
        levels[n] = levels[n] + 1;
        ElementID copy = new ElementID(false, levels);
        return copy;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ElementID)) {
            return false;
        }
        return Arrays.equals(this.idLevels, ((ElementID)obj).idLevels);
    }

    public int hashCode() {
        return Arrays.hashCode(this.idLevels);
    }

    @Override
    public int compareTo(@Nonnull ElementID o) {
        int common = Math.min(this.idLevels.length, o.idLevels.length);
        for (int i = 0; i < common; ++i) {
            int compare = Integer.compare(this.idLevels[i], o.idLevels[i]);
            if (compare == 0) continue;
            return compare;
        }
        if (this.idLevels.length == o.idLevels.length) {
            return 0;
        }
        return o.idLevels.length - this.idLevels.length;
    }

    @Nonnull
    public ElementID getDescendant() {
        return this.getDescendant(0);
    }

    @Nonnull
    public ElementID getDescendant(int descendantID) {
        int[] levels = Arrays.copyOf(this.idLevels, this.idLevels.length + 1);
        levels[levels.length - 1] = descendantID;
        return new ElementID(false, levels);
    }

    @Nonnull
    public String toString() {
        if (this.idLevels.length == 1) {
            return Integer.toString(this.idLevels[0]);
        }
        StringBuilder b = new StringBuilder();
        for (int level : this.idLevels) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(level);
        }
        return b.toString();
    }

    public static ElementID valueOf(String value) {
        @Nonnull String @Nonnull [] parts = value.split(",");
        int[] levels = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            levels[i] = Integer.parseInt(parts[i]);
        }
        return new ElementID(false, levels);
    }

    static {
        ElementID.DUMMY.idLevels = new int[]{0};
    }
}

