/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class JsonParameterizedType
implements ParameterizedType {
    private final Type rawType;
    private final Type[] typeArguments;

    public JsonParameterizedType(Type rawType, Type ... typeArguments) {
        this.rawType = rawType;
        this.typeArguments = typeArguments;
    }

    @Override
    @Nonnull
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    @Nonnull
    public @Nonnull Type @Nonnull [] getActualTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    public int hashCode() {
        return this.rawType.hashCode() + Arrays.hashCode(this.typeArguments);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JsonParameterizedType type = (JsonParameterizedType)obj;
        return this.rawType.equals(type.rawType) && Arrays.equals(this.typeArguments, type.typeArguments);
    }

    @Nonnull
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("JsonParameterizedType: " + this.rawType.toString() + "<");
        for (int i = 0; i < this.typeArguments.length; ++i) {
            Type type = this.typeArguments[i];
            buf.append(type.toString());
            buf.append(i < this.typeArguments.length - 1 ? "," : ">");
        }
        return buf.toString();
    }
}

