/*
 * Decompiled with CFR 0.152.
 */
package com.inet.graphics;

import com.inet.annotations.InternalApi;
import java.awt.BasicStroke;

@InternalApi
public enum BasicStrokeStyle {
    LINE_STYLE_NONE(0),
    LINE_STYLE_SINGLE(1),
    LINE_STYLE_DASHED(3),
    LINE_STYLE_DOTTED(4),
    LINE_STYLE_DOTTED_SQUARE(5),
    LINE_STYLE_DASHEDPOINT(6),
    LINE_STYLE_LONGDASHED(7),
    LINE_STYLE_LONGDASHEDPOINT(8),
    LINE_STYLE_LONGDASHEDPOINTPOINT(9);

    private byte id;

    public byte getId() {
        return this.id;
    }

    private BasicStrokeStyle(byte style) {
        this.id = style;
    }

    public static BasicStroke getBasicStrokeFromStyle(BasicStrokeStyle strokeStyle) {
        return BasicStrokeStyle.getBasicStrokeFromStyle(strokeStyle, 1.0f);
    }

    public static BasicStroke getBasicStrokeFromStyle(BasicStrokeStyle strokeStyle, float width) {
        switch (strokeStyle) {
            case LINE_STYLE_NONE: {
                return null;
            }
            case LINE_STYLE_SINGLE: {
                return new BasicStroke(width, 0, 0);
            }
            case LINE_STYLE_DOTTED: {
                return new BasicStroke(width, 0, 1, 1.0f, new float[]{width * 1.0f, width * 1.0f}, 0.0f);
            }
            case LINE_STYLE_DOTTED_SQUARE: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 3.0f, width * 1.0f}, 0.0f);
            }
            case LINE_STYLE_DASHED: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 4.0f, width * 2.0f}, 0.0f);
            }
            case LINE_STYLE_DASHEDPOINT: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 4.0f, width * 2.0f, width * 1.0f, width * 2.0f}, 0.0f);
            }
            case LINE_STYLE_LONGDASHED: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 6.0f, width * 2.0f}, 0.0f);
            }
            case LINE_STYLE_LONGDASHEDPOINT: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 6.0f, width * 2.0f, width * 1.0f, width * 2.0f}, 0.0f);
            }
            case LINE_STYLE_LONGDASHEDPOINTPOINT: {
                return new BasicStroke(width, 0, 0, 1.0f, new float[]{width * 6.0f, width * 2.0f, width * 1.0f, width * 2.0f, width * 1.0f, width * 2.0f}, 0.0f);
            }
        }
        return new BasicStroke();
    }

    public static byte getLineStyleFromStroke(BasicStroke bs) {
        if (bs == null) {
            return LINE_STYLE_NONE.getId();
        }
        float[] dashArray = bs.getDashArray();
        if (dashArray == null || dashArray.length <= 1) {
            return LINE_STYLE_SINGLE.getId();
        }
        if (dashArray.length == 2) {
            if (dashArray[0] <= bs.getLineWidth() * 1.2f) {
                return LINE_STYLE_DOTTED.getId();
            }
            if (dashArray[0] <= bs.getLineWidth() * 3.501f) {
                return LINE_STYLE_DOTTED_SQUARE.getId();
            }
            if (dashArray[0] <= bs.getLineWidth() * 5.501f) {
                return LINE_STYLE_DASHED.getId();
            }
            return LINE_STYLE_LONGDASHED.getId();
        }
        if (dashArray.length == 4) {
            return dashArray[0] <= bs.getLineWidth() * 5.501f ? LINE_STYLE_DASHEDPOINT.getId() : LINE_STYLE_LONGDASHEDPOINT.getId();
        }
        if (dashArray.length >= 6) {
            return LINE_STYLE_LONGDASHEDPOINTPOINT.getId();
        }
        return LINE_STYLE_SINGLE.getId();
    }
}

