/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.security;

import com.inet.error.ErrorCode;
import com.inet.http.security.CombinedKeyStore;
import com.inet.http.security.CombinedKeyStoreEx;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.util.IOFunctions;
import java.io.InputStream;
import java.security.KeyStoreSpi;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public class CombinedProvider
extends Provider {
    private static final String KEYSTORE_TYPE = "Combined";

    private CombinedProvider() {
        super("CombinedKeystore", 1.0, "Combined keystore provider");
        this.put("KeyStore.Combined", CombinedKeyStoreEx.class.getName());
    }

    @Nonnull
    public static String getKeystoreType() {
        return KEYSTORE_TYPE;
    }

    public static void addCertificates(@Nonnull String fileOrUrl) {
        try {
            Provider[] providerArray;
            byte[] byArray = IOFunctions.getFileBuffer(IOFunctions.getURLFromString(fileOrUrl));
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(new FastByteArrayInputStream(byArray));
            for (Provider provider : providerArray = Security.getProviders()) {
                Set<Provider.Service> set = provider.getServices();
                for (Provider.Service service : set) {
                    String string;
                    if (!"KeyStore".equals(service.getType())) continue;
                    switch (string = service.getAlgorithm()) {
                        case "JKS": {
                            KeyStoreSpi keyStoreSpi = (KeyStoreSpi)service.newInstance(null);
                            keyStoreSpi.engineLoad((InputStream)null, (char[])null);
                            for (Certificate certificate : collection) {
                                String string2 = ((X509Certificate)certificate).getSubjectX500Principal().getName();
                                keyStoreSpi.engineSetCertificateEntry(string2, certificate);
                            }
                            CombinedKeyStore.addExtraKeyStrore(keyStoreSpi);
                            new CombinedKeyStoreEx().logRootCertificates(fileOrUrl, keyStoreSpi);
                            return;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw (RuntimeException)ErrorCode.throwAny(throwable);
        }
    }

    static {
        if (System.getProperty("javax.net.ssl.trustStoreType") == null) {
            Security.addProvider(new CombinedProvider());
            System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        }
    }
}

