/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.http.ClientMessageException;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;

public abstract class GroupFieldDefinition<T>
extends FieldDefinition {
    public GroupFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, Type.group, fieldKey, displayType, prio);
    }

    public abstract FieldValue getFieldValue(UserGroupInfo var1);

    public abstract T convertFromString(String var1);

    public void validate(Object value) throws ClientMessageException {
        UserGroupField userGroupField = UserGroupManager.getRecoveryEnabledInstance().getField(this.getFieldKey());
        if (userGroupField != null) {
            try {
                userGroupField.validate(value);
            }
            catch (Throwable throwable) {
                throw new ClientMessageException(this.getLabel() + ": " + throwable.getMessage());
            }
        }
    }

    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        userGroupUpdateData.addUserGroupData(this.getFieldKey(), value);
    }

    public boolean isAvailable(UserGroupInfo userGroup) {
        return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
    }
}

