/*
 * Decompiled with CFR 0.152.
 */
package com.inet.thread.job;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.thread.ThreadStackTrace;
import com.inet.thread.job.ManageableJobState;
import com.inet.thread.job.manager.ManageableJob;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

@JsonData
public class JobInfo
implements Serializable {
    public static final int NOT_IN_QUEUE = 100000;
    private String name;
    private String type;
    private ManageableJobState state;
    private int progress;
    private long submitDate;
    private long elapsedExecutionTime;
    private GUID userId = null;
    private String userName;
    private String uuid;
    private ArrayList<String> stackTraces;
    private String failureTrace;
    private long memorySize;
    private long swapSize;
    private long objectHandles;
    private String clientaddress;
    private int posInWaitingQueue = 100000;

    private JobInfo() {
    }

    public static JobInfo from(ManageableJob<?, ?> job, List<ThreadStackTrace> stackTraces, int posInWaitingQueue) {
        JobInfo jobInfo = JobInfo.from(job);
        jobInfo.stackTraces = JobInfo.stackTracesAsStrings(stackTraces);
        jobInfo.posInWaitingQueue = posInWaitingQueue < 1 ? 100000 : posInWaitingQueue;
        return jobInfo;
    }

    public static JobInfo from(ManageableJob<?, ?> job, Throwable failure) {
        JobInfo jobInfo = JobInfo.from(job);
        if (failure != null) {
            jobInfo.failureTrace = JobInfo.exceptionAsStrings(failure);
        }
        return jobInfo;
    }

    public static JobInfo from(ManageableJob<?, ?> job) {
        GUID gUID;
        JobInfo jobInfo = new JobInfo();
        jobInfo.name = job.job().name();
        jobInfo.state = job.manageableJobState();
        if (jobInfo.state == ManageableJobState.STARTED && !job.getSubJobs().isEmpty()) {
            jobInfo.state = ManageableJobState.WAITING;
        }
        if ((gUID = job.userAccountID()) != null) {
            jobInfo.userId = gUID;
            UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
            if (userAccount != null) {
                jobInfo.userName = userAccount.getDisplayName();
            }
        }
        jobInfo.progress = job.job().progress();
        if (jobInfo.state == ManageableJobState.FINISHED) {
            jobInfo.progress = 100;
        }
        jobInfo.submitDate = job.submitDate();
        jobInfo.elapsedExecutionTime = job.startTime().map(t -> System.currentTimeMillis() - t).orElse(0L);
        jobInfo.uuid = job.uuid();
        jobInfo.memorySize = job.job().memorySize();
        jobInfo.swapSize = job.job().swapSize();
        jobInfo.objectHandles = job.job().objectHandles();
        jobInfo.clientaddress = job.getClientIp();
        jobInfo.type = job.job().jobType();
        return jobInfo;
    }

    public int getProgress() {
        return this.progress;
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public long getSwapSize() {
        return this.swapSize;
    }

    public long getObjectHandles() {
        return this.objectHandles;
    }

    public String getClientaddress() {
        return this.clientaddress;
    }

    private static String exceptionAsStrings(Throwable failure) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        failure.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static ArrayList<String> stackTracesAsStrings(List<ThreadStackTrace> stackTraces) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ThreadStackTrace threadStackTrace : stackTraces) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("THREAD NAME = ").append(threadStackTrace.name()).append('\n');
            for (StackTraceElement stackTraceElement : threadStackTrace.elements()) {
                stringBuilder.append("at ").append(stackTraceElement).append('\n');
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public String getUuid() {
        return this.uuid;
    }

    public ManageableJobState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public String getUserName() {
        return this.userName;
    }

    public GUID getUserId() {
        return this.userId;
    }

    public String toString() {
        return "Job " + this.name + " " + String.valueOf((Object)this.state);
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getPosInWaitingQueue() {
        return this.posInWaitingQueue;
    }

    public long getSubmitDate() {
        return this.submitDate;
    }

    public long getElapsedExecutionTime() {
        return this.elapsedExecutionTime;
    }

    public ArrayList<String> getStackTraces() {
        return this.stackTraces;
    }

    public String getType() {
        return this.type;
    }

    public String getFailureTrace() {
        return this.failureTrace;
    }
}

