/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin;

import com.inet.annotations.InternalApi;
import com.inet.logging.LogManager;
import com.inet.plugin.DynamicExtensionListener;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.ServerPluginManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DynamicExtensionManager {
    private static final DynamicExtensionManager a = new DynamicExtensionManager();
    private final ConcurrentHashMap<Class<?>, List<?>> b = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, CopyOnWriteArrayList<DynamicExtensionListener>> c = new ConcurrentHashMap();

    public static DynamicExtensionManager getInstance() {
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(Class<T> interfaceClass, T instance) {
        Object object2;
        if (instance == null) {
            return;
        }
        Object object3 = this.b;
        synchronized (object3) {
            object2 = this.b.get(interfaceClass);
            if (object2 == null) {
                object2 = new CopyOnWriteArrayList();
                this.b.put(interfaceClass, (List<?>)object2);
            }
            if (NamedExtension.class.isAssignableFrom(interfaceClass)) {
                String string = ((NamedExtension)instance).getExtensionName();
                List<T> list = ServerPluginManager.getInstance().b(interfaceClass);
                list.addAll((Collection<T>)object2);
                if (list.stream().filter(object -> string.equals(((NamedExtension)object).getExtensionName())).findFirst().isPresent()) {
                    throw new IllegalArgumentException("Cannot register duplicate name '" + string + "' for extension type " + String.valueOf(interfaceClass));
                }
            }
            object2.add(instance);
        }
        object3 = interfaceClass.getName();
        object2 = instance.getClass().getName();
        LogManager.getConfigLogger().debug("  - register " + (String)object3 + ": " + (String)object2);
        this.b(interfaceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void unregister(Class<T> interfaceClass, T instance) {
        Object object;
        if (instance == null) {
            return;
        }
        boolean bl = false;
        Object object2 = this.b;
        synchronized (object2) {
            object = this.b.get(interfaceClass);
            if (object != null) {
                bl = object.remove(instance);
            }
        }
        object2 = interfaceClass.getName();
        object = instance.getClass().getName();
        LogManager.getConfigLogger().debug("  - remove " + (String)object2 + ": " + (String)object + (bl ? "" : " failed"));
        if (bl) {
            this.b(interfaceClass);
        }
    }

    @Nonnull
    public <T> @Nonnull List<@Nonnull T> get(@Nonnull @Nonnull Class<@Nonnull ? super T> interfaceClass) {
        List<@Nonnull T> list = ServerPluginManager.getInstance().a(interfaceClass);
        List<@Nonnull ?> list2 = this.b.get(interfaceClass);
        if (list2 != null) {
            list.addAll(list2);
        }
        if (LogManager.getConfigLogger().isDebug()) {
            LogManager.getConfigLogger().debug("get dynamic extensions for: " + interfaceClass.getName() + " (" + list.size() + ")");
        }
        return list;
    }

    @Nonnull
    public <T extends NamedExtension> T getSingleInstanceByName(@Nonnull Class<T> interfaceClass, @Nullable String instanceKey, boolean useDefault) throws IllegalStateException {
        return ServerPluginManager.a(this.get(interfaceClass), interfaceClass, instanceKey, useDefault);
    }

    public <T> void registerListener(@Nonnull Class<T> interfaceClass, @Nonnull DynamicExtensionListener<T> listener) {
        CopyOnWriteArrayList<DynamicExtensionListener<Object>> copyOnWriteArrayList = this.c.get(interfaceClass);
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.c.put(interfaceClass, copyOnWriteArrayList);
        }
        copyOnWriteArrayList.add(listener);
    }

    public <T> void unregisterListener(@Nonnull Class<T> interfaceClass, @Nonnull DynamicExtensionListener listener) {
        List list = this.c.get(interfaceClass);
        if (list != null) {
            list.remove(listener);
        }
    }

    void a() {
        for (Class clazz : this.c.keySet()) {
            this.b(clazz);
        }
    }

    private <T> void b(@Nonnull Class<T> clazz) {
        List list;
        if (ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT && (list = (List)this.c.get(clazz)) != null && !list.isEmpty()) {
            List<T> list2 = this.get(clazz);
            for (DynamicExtensionListener dynamicExtensionListener : list) {
                try {
                    dynamicExtensionListener.valuesChanged(list2);
                }
                catch (Throwable throwable) {
                    LogManager.getConfigLogger().error(throwable);
                }
            }
        }
    }

    @Nullable
    <T> List<T> a(@Nonnull Class<? super T> clazz) {
        return this.b.get(clazz);
    }

    @Nonnull
    public <T> List<T> getStaticRegistered(@Nonnull Class<? super T> interfaceClass) {
        return ServerPluginManager.getInstance().a(interfaceClass);
    }
}

