/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.list;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public final class IntArrayList
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = -1609708610121579826L;
    private final Object a = new Object();
    private int[][] b;
    private int c;
    private int d;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(Vector v) {
        this(v.size());
        v.copyInto((Object[])this.b);
        this.c = v.size();
    }

    public IntArrayList(IntArrayList o2) {
        this(o2.size());
        System.arraycopy(o2.b, 0, this.b, 0, o2.c);
        this.c = o2.c;
    }

    public IntArrayList(int capacity) {
        this(capacity, 0);
    }

    public IntArrayList(int capacity, int capacityIncrement) {
        this.b = new int[capacity][];
        this.d = capacityIncrement;
    }

    public final int[] elementAt(int idx) {
        if (idx < this.c) {
            return this.b[idx];
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    public final void setCapacity(int capacity) {
        if (capacity < this.c) {
            this.c = capacity;
        }
        if (capacity != this.b.length) {
            int[][] nArrayArray = new int[capacity][];
            System.arraycopy(this.b, 0, nArrayArray, 0, this.c);
            this.b = nArrayArray;
        }
    }

    private final void a(int n2) {
        int n3 = this.b.length;
        if (n2 > n3) {
            if (this.d > 0) {
                while ((n3 += this.d) < n2) {
                }
            } else {
                if (n3 == 0) {
                    n3 = 1;
                }
                while ((n3 = 2 * n3) < n2) {
                }
            }
        } else if (n3 > 100000 && n3 > 2 * n2) {
            n3 = this.d > 0 ? n2 + this.d : n2 * 2;
        }
        int n4 = n3;
        if (n4 != this.b.length) {
            this.setCapacity(n4);
        }
    }

    public final void addElement(int[] o2) {
        if (this.c >= this.b.length) {
            this.a(this.c + 1);
        }
        this.b[this.c] = o2;
        ++this.c;
    }

    public final void insertElementAt(int[] o2, int index) {
        if (index > this.c) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.a(this.c + 1);
        System.arraycopy(this.b, index, this.b, index + 1, this.c - index);
        this.b[index] = o2;
        ++this.c;
    }

    public final int[] removeElementAt(int idx) {
        int[] nArray = this.b[idx];
        if (idx < this.c - 1) {
            System.arraycopy(this.b, idx + 1, this.b, idx, this.c - idx - 1);
        }
        this.b[--this.c] = null;
        return nArray;
    }

    public final int size() {
        return this.c;
    }

    public final void setSize(int size) {
        for (int i2 = size; i2 < this.c; ++i2) {
            this.b[i2] = null;
        }
        this.a(size);
        this.c = size;
    }

    public final void clear() {
        this.setSize(0);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            out.writeObject(this.b[i2]);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.c = in.readInt();
        if (this.b.length < this.c) {
            this.b = new int[this.c][];
        }
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.b[i2] = (int[])in.readObject();
        }
    }

    public final int indexOf(int[] o2) {
        if (o2 == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (o2 != this.b[i2]) continue;
            return i2;
        }
        return -1;
    }

    public final void removeElement(int[] o2) {
        int n2 = this.indexOf(o2);
        if (n2 < 0) {
            return;
        }
        this.removeElementAt(n2);
    }

    public final Vector toVector() {
        Vector<int[]> vector = new Vector<int[]>(this.c);
        for (int i2 = 0; i2 < this.c; ++i2) {
            vector.addElement(this.b[i2]);
        }
        return vector;
    }

    public final boolean contains(int[] o2) {
        return this.indexOf(o2) >= 0;
    }

    public final int[][] toArray() {
        return this.toArray(new int[this.c][]);
    }

    public final int[][] toArray(int[][] o2) {
        if (o2 == null || ((int[][])o2).length != this.c) {
            o2 = new int[this.c][];
        }
        System.arraycopy(this.b, 0, o2, 0, this.c);
        return o2;
    }

    public final void copyInto(int[][] o2) {
        if (o2 == null || o2.length != this.c) {
            throw new RuntimeException();
        }
        System.arraycopy(this.b, 0, o2, 0, this.c);
    }

    public final void addAll(IntArrayList o2) {
        this.a(this.c + o2.c);
        System.arraycopy(o2.b, 0, this.b, this.c, o2.c);
        this.c += o2.c;
    }

    public final void setElementAt(int[] o2, int index) {
        if (index >= this.c) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.b[index] = o2;
    }

    public final int[] lastElement() {
        return this.b[this.c - 1];
    }

    public final Object clone() {
        IntArrayList intArrayList = null;
        try {
            intArrayList = (IntArrayList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
        intArrayList.b = new int[this.b.length][];
        System.arraycopy(this.b, 0, intArrayList.b, 0, this.c);
        return intArrayList;
    }

    public final boolean isEmpty() {
        return this.c == 0;
    }

    public final Object getID() {
        return this.a;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i2 = 0; i2 < this.c; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',').append(' ');
            }
            stringBuffer.append(this.b[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final Object getObjectAt(int i2) {
        return this.elementAt(i2);
    }
}

