/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication;

import com.inet.annotations.PublicApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.LoginListener;
import com.inet.authentication.base.LoginApiAccessor;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.logging.SecurityEventLog;
import com.inet.plugin.DynamicExtension;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.SessionLocal;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.user.search.SearchTagLoginSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public abstract class LoginProcessor {
    private static final ConfigValue<Boolean> a = new ConfigValue(ConfigKey.AUTHENTICATION_ALLOW_NEW_USER);
    private static LoginProcessor b;
    private static final SessionLocal<LoginProcessor> c;
    private static final DynamicExtension<LoginListener> d;
    public static final String SYSTEM_LOGIN_SOURCE = "system";
    public static final String MASTER_LOGIN_SOURCE = "master";
    public static final String MASTER_LOGIN_ID = "Master";
    public static final String MASTER_LOGIN_HIDDEN = "master.hidden";
    public static final String GUEST_LOGIN_SOURCE = "guest";
    public static final String TEMP_LOGIN_SOURCE = "temp";
    private final AuthenticationDescription e;
    private GUID f;
    private a g;
    @Nonnull
    public static final Logger LOGGER;

    protected LoginProcessor(AuthenticationDescription description) {
        this.e = description;
        if (LOGGER.isDebug() && !(this instanceof BaseUserManager.NonSessionLoginProcessor) && !(this instanceof UserAccountScope.PrivilegedLoginProcessor)) {
            LOGGER.debug("Create LoginProcessor: " + this.getClass().getName());
        }
    }

    @Nullable
    public AuthenticationDescription getAuthenticationDescription() {
        return this.e;
    }

    @Nullable
    public GUID getUserAccountID() {
        return this.f;
    }

    @Nullable
    GUID a(Predicate<@Nonnull UserAccount> predicate) {
        UserAccount userAccount;
        String string;
        if (this.f == null && !StringFunctions.isEmpty(string = this.getLoginID()) && (userAccount = this.getOrCreateUserAccount(string)) != null) {
            GUID gUID = userAccount.getID();
            LoginApiAccessor loginApiAccessor = LoginApiAccessor.getInstance();
            if (loginApiAccessor.isAddSignUpMode()) {
                this.f = gUID;
            } else if (predicate == null || predicate.test(userAccount)) {
                this.f = gUID;
                for (LoginListener loginListener : d.get()) {
                    try {
                        loginListener.userLoggedIn(userAccount, this);
                    }
                    catch (Exception exception) {
                        LOGGER.error(exception);
                    }
                }
            }
        }
        return this.f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected UserAccount getOrCreateUserAccount(@Nonnull String loginID) {
        LoginApiAccessor loginApiAccessor = LoginApiAccessor.getInstance();
        boolean bl = loginApiAccessor.isAddSignUpMode();
        UserManager userManager = bl ? UserManager.getRecoveryEnabledInstance() : UserManager.getInstance();
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore(loginID.toLowerCase());){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                Object object;
                UserAccount userAccount;
                block17: {
                    block15: {
                        block16: {
                            userAccount = userManager.findActiveUserAccount(this.getLoginSource(), loginID);
                            if (userAccount == null && !bl) {
                                userAccount = this.a(this.getLoginSource(), loginID, userManager);
                            }
                            if (userAccount != null) break block15;
                            if (!this.isCreateUserAccountSupported()) break block16;
                            object = SearchTagLoginSettings.settingsAsToken(this.getLoginSource(), loginID);
                            SearchCommand searchCommand = new SearchCommand("loginsettings", SearchCondition.SearchTermOperator.Equals, object);
                            SearchResult<GUID> searchResult = userManager.getSearchEngine().search(searchCommand);
                            List<SearchResultEntry<GUID>> list = searchResult.getEntries();
                            LoginSettings loginSettings = this.createLoginSettings(loginID);
                            if (list.size() == 0) {
                                userAccount = loginApiAccessor.createUserAccount(this.getUserAccountType(), loginSettings, this.createNewUserData());
                                if (userAccount != null) {
                                    this.g = com.inet.authentication.LoginProcessor$a.a;
                                }
                                break block17;
                            } else {
                                userAccount = userManager.getUserAccount(list.get(0).getId());
                                if (userAccount != null && !userAccount.isActive()) {
                                    SecurityEventLog.DeactivatedUser.log(loginID);
                                    throw new ClientMessageException(LoginApiAccessor.I18N.getMsg("user.deactivated", loginSettings.getDisplayName()));
                                }
                                userManager.getSearchEngine().reIndexAsync();
                            }
                            break block17;
                        }
                        LOGGER.debug("The new authenticated user was not created because this is disabled in the configuration: " + loginID);
                        SecurityEventLog.CreationBlocked.log(loginID);
                        this.g = com.inet.authentication.LoginProcessor$a.b;
                        break block17;
                    }
                    if (bl) {
                        object = this.createLoginSettings(loginID);
                        loginApiAccessor.createUserAccount(this.getUserAccountType(), (LoginSettings)object, this.createNewUserData());
                    }
                }
                object = userAccount;
                return object;
            }
        }
    }

    @Nonnull
    public LoginSettings createLoginSettings(String loginID) {
        return new LoginSettings(this.getLoginSource(), loginID, null);
    }

    private UserAccount a(String string, String string2, UserManager userManager) {
        String string3;
        UserAccount userAccount;
        string2 = string2.replace('/', '\\');
        if (string == SYSTEM_LOGIN_SOURCE && string2.contains("\\") && (userAccount = userManager.findActiveUserAccount(string, string3 = string2.substring(string2.indexOf(92) + 1))) != null) {
            boolean bl = userAccount.getLoginSettingsFor(string).stream().anyMatch(loginSettings -> loginSettings.getLoginID().matches(".+[/\\\\]" + string3));
            if (bl) {
                return null;
            }
            LoginSettings loginSettings2 = this.createLoginSettings(string2);
            userManager.updateLoginSettings(userAccount.getID(), Arrays.asList(loginSettings2), Collections.emptyList());
            return userAccount;
        }
        return null;
    }

    protected boolean isCreateUserAccountSupported() {
        if (a.get().booleanValue()) {
            return true;
        }
        LoginApiAccessor loginApiAccessor = LoginApiAccessor.getInstance();
        return loginApiAccessor.isAddSignUpMode();
    }

    @Nonnull
    protected MutableUserData createNewUserData() {
        return new MutableUserData();
    }

    @Nonnull
    public abstract String getLoginSource();

    @Nullable
    public abstract String getLoginID();

    @Nonnull
    public UserAccountType getUserAccountType() {
        return UserAccountType.Standard;
    }

    public abstract boolean supportsRoles();

    public abstract boolean isWebUserInRole(String var1);

    public boolean isNewUser() {
        return this.g == com.inet.authentication.LoginProcessor$a.a;
    }

    public boolean isCreationBlocked() {
        return this.g == com.inet.authentication.LoginProcessor$a.b;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public static void setCurrentForAllThreads(LoginProcessor login) {
        b = login;
        GUID gUID = b == null ? null : b.a(null);
        UserManager.getInstance().setCurrentUserAccountIDForAllThreads(gUID);
    }

    public static void setCurrent(LoginProcessor login) {
        c.set(login);
    }

    public static void setCurrent(@Nonnull BaseRunnableSession session, LoginProcessor login) {
        session.setSessionValue(c, login);
    }

    public static void destroyCurrent() {
        c.removeThreadFromSession();
    }

    @Nullable
    public static LoginProcessor getCurrent() {
        if (b != null) {
            return b;
        }
        return c.get();
    }

    public boolean isSameAccount(@Nonnull String loginID, char @Nullable [] passwordChars, LoginSettings login) {
        return Objects.equals(this.getLoginSource(), login.getLoginSource()) && loginID.equalsIgnoreCase(login.getLoginID());
    }

    static {
        c = new SessionLocal();
        d = new DynamicExtension<LoginListener>(LoginListener.class);
        LOGGER = LogManager.getLogger("Authentication");
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        private static final /* synthetic */ a[] c;

        public static a[] values() {
            return (a[])c.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b};
        }

        static {
            c = com.inet.authentication.LoginProcessor$a.a();
        }
    }
}

