/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, len);
        return len;
    }

    public static long copyData(InputStream input, OutputStream output) throws IOException {
        int len = Math.max(4096, Math.min(65536, input.available()));
        byte[] buf = new byte[len];
        long count = 0L;
        while ((len = input.read(buf)) > 0) {
            output.write(buf, 0, len);
            count += (long)len;
        }
        return count;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(in.available());
        ByteBufferInputStream.copyData(in, bos);
        return bos.toByteArray();
    }

    @Nonnull
    public static String readString(InputStream in, Charset charset) throws IOException {
        byte[] data = ByteBufferInputStream.readBytes(in);
        return new String(data, charset);
    }
}

