/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.graphics.BasicStrokeStyle;
import com.inet.pdfc.model.DrawableElementXY;
import com.inet.pdfc.model.ElementID;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.Visitable;
import com.inet.pdfc.model.Visitor;
import com.inet.pdfc.model.i18n.Msg;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@JsonData
@InternalApi
public class ShapeElement
extends DrawableElementXY
implements Visitable {
    public static final int SEGMENT_LIMIT = 500;
    static final long serialVersionUID = -4288921972079575311L;
    private boolean isClip;
    private double xOffset = Double.NaN;
    private double yOffset = Double.NaN;
    private Shape shape;
    private BasicStroke stroke;
    private Paint strokePaint;
    private Paint fillPaint;
    private transient float lineWidth;
    private transient List<Shape> segments;
    private static final double ALMOST_ZERO = 1.0E-5;
    private static final Comparator<Shape> SHAPE_SORTER = (a, b) -> Double.compare(ShapeElement.getShapeDiameter(b), ShapeElement.getShapeDiameter(a));

    public ShapeElement(boolean isClip, int pageIndex, Point2D offset, Shape shape, BasicStroke stroke, Paint strokePaint, Paint fillPaint, ElementID id) {
        super(pageIndex, id);
        this.isClip = isClip;
        this.shape = shape;
        this.stroke = stroke;
        this.strokePaint = strokePaint;
        this.fillPaint = fillPaint;
        if (offset != null) {
            this.setX(offset.getX());
            this.setY(offset.getY());
        }
        if (stroke != null) {
            this.lineWidth = this.stroke.getLineWidth();
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        if (shape != null) {
            Rectangle2D bounds = shape.getBounds2D();
            super.setX(bounds.getX());
            super.setY(bounds.getY());
            this.segments = null;
        }
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke bs) {
        this.stroke = bs;
        if (this.stroke != null) {
            this.lineWidth = this.stroke.getLineWidth();
        }
    }

    public boolean getIsClip() {
        return this.isClip;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public int getLineStyle() {
        return BasicStrokeStyle.getLineStyleFromStroke(this.stroke);
    }

    public int createShapeSegments() {
        if (this.getShape() == null) {
            return 0;
        }
        this.segments = new ArrayList<Shape>();
        float curX = 0.0f;
        float curY = 0.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        double tx = Double.isNaN(this.xOffset) ? 0.0 : this.xOffset;
        double ty = Double.isNaN(this.yOffset) ? 0.0 : this.yOffset;
        PathIterator pi = this.getShape().getPathIterator(AffineTransform.getTranslateInstance(tx, ty));
        while (!pi.isDone()) {
            float[] coords = new float[6];
            switch (pi.currentSegment(coords)) {
                case 0: {
                    curX = coords[0];
                    curY = coords[1];
                    startX = curX;
                    startY = curY;
                    break;
                }
                case 1: {
                    if (curX == coords[0] && curY == coords[1]) break;
                    this.segments.add(new Line2D.Float(curX, curY, coords[0], coords[1]));
                    curX = coords[0];
                    curY = coords[1];
                    break;
                }
                case 3: {
                    this.segments.add(new CubicCurve2D.Float(curX, curY, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]));
                    curX = coords[4];
                    curY = coords[5];
                    break;
                }
                case 2: {
                    this.segments.add(new QuadCurve2D.Float(curX, curY, coords[0], coords[1], coords[2], coords[3]));
                    curX = coords[2];
                    curY = coords[3];
                    break;
                }
                case 4: {
                    if (curX != startX || curY != startY) {
                        this.segments.add(new Line2D.Float(curX, curY, startX, startY));
                    }
                    curX = startX;
                    curY = startY;
                }
            }
            pi.next();
        }
        if (this.segments.size() > 500) {
            Collections.sort(this.segments, SHAPE_SORTER);
            this.segments = new ArrayList<Shape>(this.segments.subList(0, 500));
        }
        return this.segments.size();
    }

    private static double getShapeDiameter(Shape a) {
        Rectangle2D b1 = a.getBounds2D();
        double diameter = b1.getWidth() * b1.getWidth() + b1.getHeight() * b1.getHeight();
        return diameter;
    }

    public List<Shape> getShapeSegments() {
        if (this.segments == null && this.shape != null) {
            this.createShapeSegments();
        }
        return this.segments;
    }

    @Override
    public void setX(double x) {
        this.xOffset = !Double.isNaN(this.xOffset) ? (this.xOffset += x - this.getX()) : 0.0;
        this.segments = null;
        super.setX(x);
    }

    @Override
    public void setY(double y) {
        this.yOffset = !Double.isNaN(this.yOffset) ? (this.yOffset += y - this.getY()) : 0.0;
        this.segments = null;
        super.setY(y);
    }

    public boolean isEmpty() {
        return this.shape == null;
    }

    void setSegments(List<Shape> segments) {
        this.segments = segments;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.shape == null) {
            if (this.segments == null || this.segments.size() == 0) {
                return null;
            }
            this.shape = new Polygon();
            Path2D.Double path = new Path2D.Double();
            for (Shape s : this.segments) {
                path.append(s, true);
            }
            this.shape = path;
        }
        double tx = Double.isNaN(this.xOffset) ? 0.0 : this.xOffset;
        double ty = Double.isNaN(this.yOffset) ? 0.0 : this.yOffset;
        Rectangle2D b = this.shape.getBounds2D();
        b.setRect(b.getX() + tx, b.getY() + ty, b.getWidth(), b.getHeight());
        return b;
    }

    @Override
    public int getCompareHash() {
        return 4;
    }

    @Override
    public ElementType getType() {
        return ElementType.Shape;
    }

    public void setStrokePaint(Paint paint) {
        this.strokePaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    @Override
    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    @Override
    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public String toString() {
        String shapeBounds;
        DecimalFormat f = new DecimalFormat("0.###");
        Rectangle2D bounds2D = this.getBounds();
        Rectangle bounds = bounds2D != null ? bounds2D.getBounds() : null;
        String string = shapeBounds = bounds != null ? "(" + f.format(bounds2D.getMinX()) + ":" + f.format(bounds2D.getMinY()) + " -> " + f.format(bounds2D.getMaxX()) + ":" + f.format(bounds2D.getMaxY()) + ")" : "";
        if (this.isClip) {
            return this.getElementID().toString() + ": Clip-Shape " + shapeBounds;
        }
        return this.getElementID().toString() + ": " + shapeBounds;
    }

    @Override
    public String getLabel() {
        Rectangle2D bounds = this.getBounds();
        String width = bounds != null ? Long.toString(Math.round(bounds.getWidth())) : "null";
        String height = bounds != null ? Long.toString(Math.round(bounds.getHeight())) : "null";
        return Msg.getMsg("ElementType." + String.valueOf(this.getType()), width, height);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

