/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user.search;

import com.inet.permissions.Permission;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.user.search.SearchTagActive;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class a
extends AbstractMap<String, Object> {
    private static final String[] a = new String[]{"useraccountid", "active", "locked", "useraccountdisplayname", "loginsettings", "loginid", "useraccounttype", "permissions", "authgroupname", "lastaccess"};
    private final UserAccount b;
    private final Map<String, UserField> c;
    private UserPersistence d;
    private Set<String> e;
    private Set<Map.Entry<String, Object>> f;

    a(@Nonnull UserAccount userAccount, @Nonnull Map<String, UserField> map, @Nullable UserPersistence userPersistence) {
        this.b = userAccount;
        this.c = map;
        this.d = userPersistence;
    }

    a(@Nonnull UserAccount userAccount, @Nonnull Map<String, UserField> map, @Nullable Set<String> set) {
        this.b = userAccount;
        this.c = map;
        this.e = set;
    }

    @Override
    @Nullable
    public Object get(Object key) {
        UserField userField = this.c.get(key);
        if (userField != null) {
            Object object = this.b.getValue(userField);
            if (object != null && userField.getValueType() == Boolean.class) {
                object = (Boolean)object != false ? 1 : 0;
            }
            return object;
        }
        return this.a((String)key);
    }

    @Nullable
    private Object a(String string) {
        switch (string) {
            case "useraccountid": {
                return this.b.getID().toString();
            }
            case "useraccountdisplayname": {
                return this.b.getDisplayName();
            }
            case "active": {
                return SearchTagActive.valueAsInt(this.b.isActive());
            }
            case "locked": {
                return SearchTagActive.valueAsInt(this.b.getValue(UsersAndGroups.FIELD_USER_LOCKED) != null);
            }
            case "loginsettings": {
                return this.b.getLoginSettings();
            }
            case "loginid": {
                return this.b.getLoginSettings().stream().map(loginSettings -> loginSettings.getDisplayName()).collect(Collectors.joining(", "));
            }
            case "useraccounttype": {
                return this.b.getAccountType();
            }
            case "permissions": {
                return UserManager.MASTER_ACCOUNT_ID.equals(this.b.getID()) ? new HashSet<Permission>(Arrays.asList(Permission.values())) : Permission.filterOutPermissionsWithoutGrantedAncestorPermissions(this.b.getPermissionsIncludingInactive());
            }
            case "lastaccess": {
                return this.b.getLastAccess();
            }
            case "authgroupname": {
                if (this.e != null) {
                    return this.e;
                }
                if (this.d == null) break;
                return BaseUserManager.loadAuthGroupNames(this.d, this.b.getID());
            }
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.f == null) {
            Set<UserField<Object>> set = this.b.getIncludedFields();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (UserField userField : this.c.values()) {
                if (!set.contains(userField)) continue;
                hashMap.put(userField.getKey(), this.b.getValue(userField));
            }
            for (String string : a) {
                Object object = this.a(string);
                if (object == null) continue;
                hashMap.put(string, object);
            }
            this.f = Collections.unmodifiableSet(hashMap.entrySet());
        }
        return this.f;
    }
}

