/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups.persistence;

import com.inet.annotations.InternalApi;
import com.inet.error.PersistenceException;
import com.inet.id.GUID;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.permissions.Permission;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociationMap;
import com.inet.usersandgroups.api.FileSystemPersistenceDirectoryStructure;
import com.inet.usersandgroups.api.FileSystemPersistenceHelper;
import com.inet.usersandgroups.api.NodeIdIterator;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupMembership;
import com.inet.usersandgroups.api.groups.persistence.UserGroupPersistence;
import com.inet.usersandgroups.api.groups.persistence.UserGroupPersistenceUnit;
import com.inet.usersandgroups.api.groups.persistence.UserGroupPersistenceUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class FileSystemUserGroupPersistence
implements UserGroupPersistence {
    private final FileSystemPersistenceDirectoryStructure a;
    private final PersistenceEntry b;
    private Map<String, GroupTypeDef> c;

    public FileSystemUserGroupPersistence(Persistence persistence) {
        this(persistence.resolve("usersandgroups/groups"));
    }

    public FileSystemUserGroupPersistence(PersistenceEntry groupsDir) {
        this.b = groupsDir;
        this.a = new FileSystemPersistenceDirectoryStructure(groupsDir);
    }

    @Override
    public void init(Set<GroupTypeDef> groupTypes) {
        if (groupTypes == null) {
            throw new IllegalArgumentException("group types must not be null");
        }
        if (groupTypes.isEmpty()) {
            throw new IllegalArgumentException("there must be at least one group type");
        }
        if (this.c != null) {
            throw new IllegalStateException("persistence is already initialized");
        }
        this.c = new HashMap<String, GroupTypeDef>();
        for (GroupTypeDef groupTypeDef : groupTypes) {
            this.c.put(groupTypeDef.getGroupType().getName(), groupTypeDef);
        }
    }

    @Override
    public UserGroupInfo saveNew(@Nonnull GUID groupID, @Nullable GUID parentID, String groupName, GroupType groupType, long lastModified, MutableUserGroupData groupData) {
        GroupTypeDef groupTypeDef = this.c.get(groupType.getName());
        if (groupTypeDef == null) {
            throw new IllegalArgumentException("unsupported group type: " + groupType.getName());
        }
        boolean bl = true;
        UserGroupMembership userGroupMembership = new UserGroupMembership(groupTypeDef.getMembershipTypes(), groupTypeDef.getMemberToTypeCardinality(), Collections.emptyMap());
        byte[] byArray = UserGroupPersistenceUnit.toJsonizedPersistenceUnit(parentID, groupName, groupType.getName(), lastModified, bl, userGroupMembership, groupData, Collections.emptySet());
        PersistenceEntry persistenceEntry = this.a.getJsonDataFile(groupID);
        if (!FileSystemPersistenceHelper.isMaintenanceMode()) {
            persistenceEntry.setBytes(byArray);
        }
        return UserGroupInfo.create(parentID, groupID, groupName, groupType, lastModified, userGroupMembership, groupData, Collections.emptySet(), bl);
    }

    @Override
    public UserGroupInfo setGroupName(GUID groupID, String newGroupName, long lastModified) {
        try {
            PersistenceEntry persistenceEntry = this.a.getJsonDataFile(groupID);
            UserGroupPersistenceUnit userGroupPersistenceUnit = this.a(persistenceEntry);
            GroupTypeDef groupTypeDef = this.a(groupID, userGroupPersistenceUnit.getGroupType());
            UserGroupPersistenceUnit userGroupPersistenceUnit2 = new UserGroupPersistenceUnit(userGroupPersistenceUnit.getParentID(), newGroupName, userGroupPersistenceUnit.getGroupType(), lastModified, userGroupPersistenceUnit.isActive(), userGroupPersistenceUnit.getMembers(), userGroupPersistenceUnit.getFields(), userGroupPersistenceUnit.getPermissions());
            this.a(groupID, userGroupPersistenceUnit2);
            return this.a(groupID, this.a(groupTypeDef), userGroupPersistenceUnit2);
        }
        catch (JsonException | IOException exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public UserGroupInfo updateGroupData(GUID groupID, long lastModified, MutableUserGroupData groupData) {
        try {
            PersistenceEntry persistenceEntry = this.a.getJsonDataFile(groupID);
            UserGroupPersistenceUnit userGroupPersistenceUnit = this.a(persistenceEntry);
            GroupTypeDef groupTypeDef = this.a(groupID, userGroupPersistenceUnit.getGroupType());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (UserGroupField<Object> userGroupField : groupData.getIncludedFields()) {
                Object object = groupData.get(userGroupField);
                String string = object == null ? null : new Json().toJson(object);
                hashMap.put(userGroupField.getKey(), string);
            }
            if (UserGroupPersistenceUtils.hasDifferencesBetweenValues(userGroupPersistenceUnit.getFields(), hashMap)) {
                HashMap<String, String> hashMap2 = new HashMap<String, String>(userGroupPersistenceUnit.getFields());
                hashMap2.putAll(hashMap);
                userGroupPersistenceUnit = new UserGroupPersistenceUnit(userGroupPersistenceUnit.getParentID(), userGroupPersistenceUnit.getGroupName(), userGroupPersistenceUnit.getGroupType(), lastModified, userGroupPersistenceUnit.isActive(), userGroupPersistenceUnit.getMembers(), hashMap2, userGroupPersistenceUnit.getPermissions());
                this.a(groupID, userGroupPersistenceUnit);
            }
            return this.a(groupID, this.a(groupTypeDef), userGroupPersistenceUnit);
        }
        catch (JsonException | IOException exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public UserGroupInfo updateMembers(GUID groupID, long lastModified, Map<GUID, Set<MembershipType>> membersToAdd, Map<GUID, Set<MembershipType>> membersToRemove) {
        try {
            PersistenceEntry persistenceEntry = this.a.getJsonDataFile(groupID);
            UserGroupPersistenceUnit userGroupPersistenceUnit = this.a(persistenceEntry);
            GroupTypeDef groupTypeDef = this.a(groupID, userGroupPersistenceUnit.getGroupType());
            MemberToTypeCardinality memberToTypeCardinality = groupTypeDef.getMemberToTypeCardinality();
            HashMap<GUID, Set<String>> hashMap = new HashMap<GUID, Set<String>>(userGroupPersistenceUnit.getMembers());
            UserGroupPersistenceUtils.updateMembersMapAndThrowIfInvalid(groupID, hashMap, membersToAdd, membersToRemove, memberToTypeCardinality);
            UserGroupPersistenceUnit userGroupPersistenceUnit2 = new UserGroupPersistenceUnit(userGroupPersistenceUnit.getParentID(), userGroupPersistenceUnit.getGroupName(), userGroupPersistenceUnit.getGroupType(), lastModified, userGroupPersistenceUnit.isActive(), hashMap, userGroupPersistenceUnit.getFields(), userGroupPersistenceUnit.getPermissions());
            this.a(groupID, userGroupPersistenceUnit2);
            return this.a(groupID, this.a(groupTypeDef), userGroupPersistenceUnit2);
        }
        catch (JsonException | IOException exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public UserGroupInfo updatePermissions(GUID groupID, long lastModified, Set<String> permissionsToAdd, Set<String> permissionsToRemove) {
        try {
            PersistenceEntry persistenceEntry = this.a.getJsonDataFile(groupID);
            UserGroupPersistenceUnit userGroupPersistenceUnit = this.a(persistenceEntry);
            GroupTypeDef groupTypeDef = this.a(groupID, userGroupPersistenceUnit.getGroupType());
            HashSet<String> hashSet = new HashSet<String>(userGroupPersistenceUnit.getPermissions());
            hashSet.addAll(permissionsToAdd);
            hashSet.removeAll(permissionsToRemove);
            UserGroupPersistenceUnit userGroupPersistenceUnit2 = new UserGroupPersistenceUnit(userGroupPersistenceUnit.getParentID(), userGroupPersistenceUnit.getGroupName(), userGroupPersistenceUnit.getGroupType(), lastModified, userGroupPersistenceUnit.isActive(), userGroupPersistenceUnit.getMembers(), userGroupPersistenceUnit.getFields(), hashSet);
            this.a(groupID, userGroupPersistenceUnit2);
            return this.a(groupID, this.a(groupTypeDef), userGroupPersistenceUnit2);
        }
        catch (JsonException | IOException exception) {
            throw new PersistenceException(exception);
        }
    }

    private GroupTypeDef a(GUID gUID, String string) {
        GroupTypeDef groupTypeDef = this.c.get(string);
        if (groupTypeDef == null) {
            throw new IllegalArgumentException(String.format("group with ID %s has unsupported type: %s", gUID, string));
        }
        return groupTypeDef;
    }

    @Override
    public UserGroupInfo setParentGroup(GUID groupID, GUID parentID, long lastModified) {
        try {
            PersistenceEntry persistenceEntry = this.a.getJsonDataFile(groupID);
            UserGroupPersistenceUnit userGroupPersistenceUnit = this.a(persistenceEntry);
            GroupTypeDef groupTypeDef = this.a(groupID, userGroupPersistenceUnit.getGroupType());
            UserGroupPersistenceUnit userGroupPersistenceUnit2 = new UserGroupPersistenceUnit(parentID, userGroupPersistenceUnit.getGroupName(), userGroupPersistenceUnit.getGroupType(), lastModified, userGroupPersistenceUnit.isActive(), userGroupPersistenceUnit.getMembers(), userGroupPersistenceUnit.getFields(), userGroupPersistenceUnit.getPermissions());
            this.a(groupID, userGroupPersistenceUnit2);
            return this.a(groupID, this.a(groupTypeDef), userGroupPersistenceUnit2);
        }
        catch (JsonException | IOException exception) {
            throw new PersistenceException(exception);
        }
    }

    @Override
    public void delete(GUID groupID) {
        this.a.getNodeDirectory(groupID).deleteTree();
    }

    @Override
    public void deleteAll() {
        this.b.deleteTree();
    }

    @Override
    public UserGroupInfo deactivate(GUID groupID, boolean removeMembershipData, long lastModified) {
        try {
            PersistenceEntry persistenceEntry = this.a.getJsonDataFile(groupID);
            UserGroupPersistenceUnit userGroupPersistenceUnit = this.a(persistenceEntry);
            GroupTypeDef groupTypeDef = this.a(groupID, userGroupPersistenceUnit.getGroupType());
            HashMap<GUID, Set<String>> hashMap = removeMembershipData ? new HashMap<GUID, Set<String>>() : userGroupPersistenceUnit.getMembers();
            UserGroupPersistenceUnit userGroupPersistenceUnit2 = new UserGroupPersistenceUnit(userGroupPersistenceUnit.getParentID(), userGroupPersistenceUnit.getGroupName(), userGroupPersistenceUnit.getGroupType(), lastModified, false, hashMap, userGroupPersistenceUnit.getFields(), userGroupPersistenceUnit.getPermissions());
            this.a(groupID, userGroupPersistenceUnit2);
            return this.a(groupID, this.a(groupTypeDef), userGroupPersistenceUnit2);
        }
        catch (JsonException | IOException exception) {
            throw new PersistenceException(exception);
        }
    }

    private UserGroupPersistenceUnit a(PersistenceEntry persistenceEntry) throws IOException {
        try (EncodedReader encodedReader = new EncodedReader(persistenceEntry.getInputStream());){
            UserGroupPersistenceUnit userGroupPersistenceUnit = new Json().fromJson((Reader)encodedReader, UserGroupPersistenceUnit.class, new HashMap<Object, Map<String, String>>());
            if (userGroupPersistenceUnit.getGroupName() == null || userGroupPersistenceUnit.getGroupType() == null) {
                String string = "data of the user group can not be used because of missing information about name and/or type";
                UsersAndGroups.LOGGER.error(string + ": file=" + persistenceEntry.getPath());
                throw new PersistenceException(string);
            }
            UserGroupPersistenceUnit userGroupPersistenceUnit2 = userGroupPersistenceUnit;
            return userGroupPersistenceUnit2;
        }
    }

    private void a(GUID gUID, UserGroupPersistenceUnit userGroupPersistenceUnit) throws IOException {
        if (!FileSystemPersistenceHelper.isMaintenanceMode()) {
            byte[] byArray = FileSystemPersistenceHelper.toEncodedJsonized(userGroupPersistenceUnit);
            PersistenceEntry persistenceEntry = this.a.getJsonDataFile(gUID);
            persistenceEntry.setBytes(byArray);
        }
    }

    private UserGroupInfo a(GUID gUID, List<UserGroupField<Object>> list, UserGroupPersistenceUnit userGroupPersistenceUnit) {
        MutableUserGroupData mutableUserGroupData = UserGroupPersistenceUtils.convertToMutableUserGroupData(gUID, list, userGroupPersistenceUnit.getFields());
        GroupTypeDef groupTypeDef = this.a(gUID, userGroupPersistenceUnit.getGroupType());
        UserGroupMembership userGroupMembership = UserGroupPersistenceUtils.convertToUserGroupMembershipOrThrowIfInvalid(gUID, groupTypeDef, userGroupPersistenceUnit.getMembers());
        Set<Permission> set = UserGroupPersistenceUtils.convertKeysToPermissions(userGroupPersistenceUnit.getPermissions());
        return UserGroupInfo.create(userGroupPersistenceUnit.getParentID(), gUID, userGroupPersistenceUnit.getGroupName(), groupTypeDef.getGroupType(), userGroupPersistenceUnit.getLastModified(), userGroupMembership, mutableUserGroupData, set, userGroupPersistenceUnit.isActive());
    }

    @Override
    public Iterator<UserGroupInfo> getUserGroupInfoIterator() {
        final NodeIdIterator nodeIdIterator = this.a.getNodeIdIterator(null);
        return new Iterator<UserGroupInfo>(){
            private Optional<UserGroupInfo> c;

            @Override
            public boolean hasNext() {
                this.b();
                return this.c.isPresent();
            }

            public UserGroupInfo a() {
                this.b();
                if (this.c.isPresent()) {
                    UserGroupInfo userGroupInfo = this.c.get();
                    this.c = null;
                    return userGroupInfo;
                }
                throw new NoSuchElementException();
            }

            private void b() {
                if (this.c != null) {
                    return;
                }
                while (nodeIdIterator.hasNext()) {
                    GUID gUID = nodeIdIterator.next();
                    UserGroupInfo userGroupInfo = FileSystemUserGroupPersistence.this.load(gUID);
                    if (userGroupInfo == null) continue;
                    this.c = Optional.of(userGroupInfo);
                    return;
                }
                this.c = Optional.empty();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    @Override
    @Nullable
    public UserGroupInfo load(GUID groupID) {
        PersistenceEntry persistenceEntry = this.a.getJsonDataFile(groupID);
        UserGroupPersistenceUnit userGroupPersistenceUnit = null;
        try {
            userGroupPersistenceUnit = this.a(persistenceEntry);
        }
        catch (Exception exception) {
            if (exception instanceof JsonException) {
                UsersAndGroups.LOGGER.error("data of the user group can not be deserialized: file=" + persistenceEntry.getPath());
                UsersAndGroups.LOGGER.error(exception);
            }
            return null;
        }
        GroupTypeDef groupTypeDef = this.c.get(userGroupPersistenceUnit.getGroupType());
        if (groupTypeDef == null) {
            return null;
        }
        return this.a(groupID, this.a(groupTypeDef), userGroupPersistenceUnit);
    }

    @Nonnull
    private List<UserGroupField<Object>> a(GroupTypeDef groupTypeDef) {
        return FieldAndGroupTypeAssociationMap.getFieldsFor(groupTypeDef.getGroupType());
    }
}

