/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.persistence.PersistenceEntry;
import com.inet.usersandgroups.api.NodeBinaryDataIterator;
import com.inet.usersandgroups.api.NodeIdIterator;
import javax.annotation.Nullable;

@InternalApi
public class FileSystemPersistenceDirectoryStructure {
    public static final int BRANCH_DIR_NAME_LENGTH_WITHOUT_PREFIX = 3;
    public static final char BRANCH_DIR_NAME_PREFIX = '_';
    private final PersistenceEntry a;

    public FileSystemPersistenceDirectoryStructure(PersistenceEntry directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        this.a = directory;
    }

    public NodeIdIterator getNodeIdIterator(@Nullable String extraFileName) {
        return new NodeIdIterator(this.a, extraFileName);
    }

    public NodeBinaryDataIterator getBinaryDataIterator(@Nullable GUID accountID) {
        return new NodeBinaryDataIterator(this.a, accountID);
    }

    public PersistenceEntry getBranchDirectory(GUID nodeID) {
        String string = "_" + nodeID.toString().substring(0, 3);
        return this.a.resolve(string);
    }

    public PersistenceEntry getNodeDirectory(GUID nodeID) {
        return this.getBranchDirectory(nodeID).resolve(nodeID.toString());
    }

    public PersistenceEntry getJsonDataFile(GUID nodeID) {
        PersistenceEntry persistenceEntry = this.getNodeDirectory(nodeID);
        return FileSystemPersistenceDirectoryStructure.getJsonDataFile(persistenceEntry);
    }

    public static PersistenceEntry getJsonDataFile(PersistenceEntry node) {
        return node.resolve(node.getName() + ".json");
    }

    public static boolean isBranchDirectory(PersistenceEntry file) {
        String string = file.getName();
        if (!string.startsWith(String.valueOf('_'))) {
            return false;
        }
        if (string.length() != 3 + String.valueOf('_').length()) {
            return false;
        }
        string = string.substring(1);
        return FileSystemPersistenceDirectoryStructure.a(string);
    }

    private static boolean a(String string) {
        try {
            GUID.checkID(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

