/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api;

import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.logging.LogManager;
import com.inet.persistence.Persistence;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.TokenMatcher;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.usersandgroups.api.UserManagerFactory;
import com.inet.usersandgroups.api.user.BaseUserManager;
import com.inet.usersandgroups.api.user.LoggedInUsersConditionTokenMatcher;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.persistence.FileSystemUserPersistence;
import com.inet.usersandgroups.api.user.search.UserSearchEngine;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class BaseUserManagerFactory
implements UserManagerFactory {
    @Override
    @Nonnull
    public UserManager createManager(boolean useOriginalInRecoveryMode, SearchIndexVeto searchIndexVeto) {
        Persistence persistence = useOriginalInRecoveryMode ? Persistence.getRecoveryEnabledInstance() : Persistence.getInstance();
        FileSystemUserPersistence fileSystemUserPersistence = new FileSystemUserPersistence(persistence);
        List<TokenMatcher> list = Arrays.asList(new LoggedInUsersConditionTokenMatcher());
        UserSearchEngine userSearchEngine = new UserSearchEngine(list, useOriginalInRecoveryMode);
        userSearchEngine.setSearchIndexVeto(searchIndexVeto);
        BaseUserManager baseUserManager = new BaseUserManager(fileSystemUserPersistence, userSearchEngine);
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        try {
            baseUserManager.init();
        }
        catch (Exception exception) {
            LogManager.getConfigLogger().fatal(exception);
            ErrorCode.throwAny(exception);
        }
        if ((ConfigurationManager.isHelpCenterMode() || ConfigurationManager.isRecoveryMode()) && !useOriginalInRecoveryMode) {
            baseUserManager.disableLoggingEvents();
            return baseUserManager;
        }
        serverPluginManager.get(UserEventListener.class).forEach(userEventListener -> baseUserManager.registerListener((UserEventListener)userEventListener));
        return baseUserManager;
    }
}

