/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.index;

import com.inet.annotations.JsonData;
import com.inet.error.ErrorCode;
import com.inet.lib.json.Bon;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.lib.util.IOFunctions;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.d;
import com.inet.search.index.dataseries.SortedDataSeries;
import com.inet.search.index.j;
import com.inet.search.index.k;
import com.inet.thread.ThreadUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

class DiskExtendedSet<ID extends Comparable<ID>>
implements d,
j<ID> {
    static final int MAX_ENTRIES_PER_PAGE = 1024;
    private static final SetPage[] a = new SetPage[0];
    private SetPage<ID>[] b;
    @Nonnull
    private final WeakReference<k<ID>> c;
    private Integer d;

    DiskExtendedSet(@Nonnull WeakReference<k<ID>> indexRef) {
        this.c = indexRef;
        this.b = a;
    }

    DiskExtendedSet(@Nonnull WeakReference<k<ID>> indexRef, Object[] values) throws IOException {
        this.c = indexRef;
        this.b = new SetPage[]{new SetPage(values)};
    }

    DiskExtendedSet(@Nonnull WeakReference<k<ID>> indexRef, Bon bon, Integer fileID, final Class<?> idType) throws IOException {
        this.c = indexRef;
        this.d = fileID;
        this.b = this.a(fileChannel -> {
            int n2 = (int)fileChannel.size() - 4;
            fileChannel.position(n2);
            int n3 = IOFunctions.readInt(fileChannel);
            fileChannel.position(n3);
            byte[] byArray = new byte[n2 - n3];
            fileChannel.read(ByteBuffer.wrap(byArray));
            JsonTypeResolver jsonTypeResolver = new JsonTypeResolver(){

                @Override
                protected Type getGenericType(Object obj, Field field) {
                    if ("start".equals(field.getName())) {
                        return idType;
                    }
                    return super.getGenericType(obj, field);
                }
            };
            return (SetPage[])bon.fromBinary(byArray, (Type)((Object)SetPage[].class), null, jsonTypeResolver);
        });
    }

    Integer a() {
        return this.d;
    }

    @Nonnull
    Object[] c() {
        SetPage<ID> setPage = this.b[0];
        return Arrays.copyOf(setPage.values, setPage.count);
    }

    /*
     * Loose catch block
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="no user input is used.")
    private <T> T a(a<T> a2) {
        String string = ((k)this.c.get()).c(this.d);
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore(string);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                T t;
                FileChannel fileChannel;
                block18: {
                    fileChannel = FileChannel.open(Paths.get(string, new String[0]), StandardOpenOption.READ);
                    t = a2.read(fileChannel);
                    if (fileChannel == null) break block18;
                    fileChannel.close();
                }
                return t;
                {
                    catch (Throwable throwable) {
                        try {
                            if (fileChannel != null) {
                                try {
                                    fileChannel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            IndexSearchEngine.LOGGER.error(String.valueOf(throwable3) + ": with file: " + string);
                            throw (RuntimeException)ErrorCode.throwAny(throwable3);
                        }
                    }
                }
            }
        }
    }

    public boolean a(ID ID) {
        int n2 = this.b(ID);
        if (n2 >= 0) {
            SetPage<ID>[] setPageArray = this.b;
            SetPage<ID> setPage = setPageArray[n2];
            if (setPage.add(ID, this)) {
                if (setPage.count > 1024) {
                    SetPage<ID> setPage2 = setPage.split();
                    this.b = com.inet.search.index.a.a(setPageArray, n2 + 1, setPage2);
                }
                return this.d();
            }
            return false;
        }
        SetPage<ID> setPage = new SetPage<ID>(ID);
        this.b = new SetPage[]{setPage};
        return this.d();
    }

    @Override
    public boolean remove(Object id) {
        boolean bl;
        int n2 = this.b((Comparable)id);
        if (n2 >= 0 && (bl = this.b[n2].remove((Comparable)id, this))) {
            return this.d();
        }
        return false;
    }

    @Override
    public boolean contains(Object id) {
        int n2 = this.b((Comparable)id);
        if (n2 >= 0) {
            return this.b[n2].contains((Comparable)id, this);
        }
        return false;
    }

    @Override
    public int size() {
        int n2 = 0;
        SetPage<ID>[] setPageArray = this.b;
        int n3 = setPageArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += setPageArray[i2].count;
        }
        return n2;
    }

    @Override
    public int a(int n2) {
        int n3 = 0;
        int n4 = 0;
        SetPage<ID>[] setPageArray = this.b;
        int n5 = setPageArray.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            SetPage<ID> setPage = setPageArray[i2];
            if (setPage.values == null) continue;
            n3 += setPage.count;
            n4 += setPage.values.length;
        }
        return 40 + n3 * n2 + n4 * 4 + setPageArray.length * 40;
    }

    private boolean d() {
        if (this.b.length <= 1) {
            return true;
        }
        boolean bl = false;
        Integer n2 = this.d;
        if (n2 == null) {
            this.d = n2 = ((k)this.c.get()).a();
            bl = true;
        }
        ((k)this.c.get()).a(n2, this);
        return bl;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="no user input is used.")
    public void a(Bon bon, String string) throws IOException {
        Path path = Paths.get(string, new String[0]);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            SetPage<ID>[] setPageArray = this.b;
            int n2 = setPageArray.length;
            boolean bl = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                SetPage<ID> setPage = setPageArray[i2];
                bl = setPage.prepareSave(bon, fileChannel, bl);
            }
            b b2 = new b();
            for (int i3 = 0; i3 < n2; ++i3) {
                SetPage<ID> setPage = setPageArray[i3];
                setPage.flushSave(bon, fileChannel, b2);
            }
            long l2 = b2.a;
            fileChannel.position(l2);
            byte[] byArray = bon.toBinary(setPageArray);
            fileChannel.write(ByteBuffer.wrap(byArray));
            IOFunctions.writeInt(fileChannel, (int)l2);
            fileChannel.truncate(l2 + (long)byArray.length + 4L);
        }
    }

    private int b(ID ID) {
        SetPage<ID>[] setPageArray = this.b;
        int n2 = 0;
        int n3 = setPageArray.length - 1;
        if (n3 < 0) {
            return -1;
        }
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            SetPage<ID> setPage = setPageArray[n4];
            int n5 = setPage.compare(ID);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return n3 < 0 ? 0 : n2 - 1;
    }

    @Override
    @Nonnull
    public Iterator<ID> iterator() {
        return new Iterator<ID>(){
            private SetPage<ID>[] b;
            private int c;
            private int d;
            private Object[] e;
            private int f;
            private int g;
            private ID h;
            {
                this.b = DiskExtendedSet.this.b;
                this.c = this.b.length;
            }

            @Override
            public boolean hasNext() {
                if (this.h != null) {
                    return true;
                }
                while (true) {
                    if (this.g < this.f) {
                        this.h = (Comparable)this.e[this.g++];
                        return true;
                    }
                    if (this.d >= this.c) break;
                    SetPage setPage = this.b[this.d++];
                    this.e = setPage.getValues(DiskExtendedSet.this);
                    this.f = setPage.count;
                    this.g = 0;
                }
                return false;
            }

            public ID a() {
                if (this.hasNext()) {
                    Object ID = this.h;
                    this.h = null;
                    return ID;
                }
                throw new NoSuchElementException();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    @Override
    @Nonnull
    public SortedDataSeries<ID> b() {
        return new SortedDataSeries<ID>(){
            private SetPage<ID>[] b;
            private int c;
            private Object[] d;
            private int e;
            {
                this.b = DiskExtendedSet.this.b;
                this.c = this.b.length - 1;
            }

            public ID a() {
                while (true) {
                    if (this.e > 0) {
                        return (Comparable)this.d[--this.e];
                    }
                    if (this.c < 0) break;
                    SetPage setPage = this.b[this.c--];
                    this.d = setPage.getValues(DiskExtendedSet.this);
                    this.e = setPage.count;
                }
                return null;
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    @Override
    public /* synthetic */ boolean add(Object object) {
        return this.a((Comparable)object);
    }

    @JsonData
    private static class SetPage<ID extends Comparable<ID>> {
        private ID start;
        private long pos;
        private int length;
        private transient Object[] values;
        private transient int count;
        private transient boolean modified;
        private transient byte[] data;

        private SetPage() {
        }

        SetPage(ID id) {
            this.start = id;
            this.values = new Object[]{id};
            this.count = 1;
            this.modified = true;
        }

        SetPage(Object[] values) {
            this.values = values;
            this.start = (Comparable)values[0];
            this.count = values.length;
        }

        boolean prepareSave(Bon bon, FileChannel file, boolean override) throws IOException {
            if (this.modified || override) {
                Object[] objectArray = this.getValues(file);
                objectArray = Arrays.copyOf(this.values, this.count);
                this.data = bon.toBinary(objectArray);
                byte[] byArray = this.data;
                int n2 = byArray.length;
                if (this.length == 0 || n2 > this.length) {
                    override = true;
                }
            }
            return override;
        }

        void flushSave(Bon bon, FileChannel file, b state) throws IOException {
            byte[] byArray = this.data;
            if (byArray != null) {
                int n2 = byArray.length;
                if (state.b || this.length == 0 || n2 > this.length) {
                    this.pos = state.a;
                    this.length = Math.max(n2, this.count > 0 ? n2 * 1025 / this.count : n2 * 1024);
                    state.b = true;
                }
                file.write(ByteBuffer.wrap(byArray), this.pos);
                this.data = null;
            }
            state.a += (long)this.length;
        }

        Object[] getValues(FileChannel file) throws IOException {
            Object[] objectArray = this.values;
            if (objectArray == null) {
                objectArray = this.loadValues(file);
            }
            return objectArray;
        }

        Object[] getValues(DiskExtendedSet<?> set) {
            Object[] objectArray = this.values;
            if (objectArray == null) {
                try {
                    objectArray = set.a(file -> this.loadValues(file));
                }
                catch (Throwable throwable) {
                    IndexSearchEngine.LOGGER.error(throwable);
                    ((k)set.c.get()).a(throwable);
                    this.values = new Object[0];
                    objectArray = this.values;
                }
            }
            return objectArray;
        }

        private Object @Nonnull [] loadValues(FileChannel file) throws IOException {
            try {
                file.position(this.pos);
                byte[] byArray = new byte[this.length];
                file.read(ByteBuffer.wrap(byArray));
                this.values = new Bon().fromBinary(byArray, Object[].class, this.start.getClass());
                Object[] objectArray = this.values;
                this.count = objectArray.length;
                return objectArray;
            }
            catch (Exception exception) {
                IndexSearchEngine.LOGGER.error(String.valueOf(exception) + ": at pos: " + this.pos + " -> " + this.length + " file size: " + file.size());
                throw exception;
            }
        }

        int compare(ID id) {
            return this.start.compareTo(id);
        }

        boolean add(ID id, DiskExtendedSet<ID> set) {
            int n2;
            Object[] objectArray = this.getValues(set);
            int n3 = Arrays.binarySearch(objectArray, 0, n2 = this.count, id);
            if (n3 < 0) {
                Object[] objectArray2;
                n3 = -n3 - 1;
                if (objectArray.length <= n2) {
                    objectArray2 = new Object[n2 == 0 ? 1 : n2 * 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n3);
                } else {
                    objectArray2 = objectArray;
                }
                if (n2 > n3) {
                    System.arraycopy(objectArray, n3, objectArray2, n3 + 1, n2 - n3);
                }
                objectArray2[n3] = id;
                this.values = objectArray2;
                ++this.count;
                this.modified = true;
                if (n3 == 0) {
                    this.start = id;
                }
                return true;
            }
            return false;
        }

        private boolean remove(ID id, DiskExtendedSet<ID> set) {
            int n2;
            Object[] objectArray = this.getValues(set);
            int n3 = Arrays.binarySearch(objectArray, 0, n2 = this.count, id);
            if (n3 >= 0) {
                int n4 = n2 - n3 - 1;
                if (n4 > 0) {
                    System.arraycopy(objectArray, n3 + 1, objectArray, n3, n4);
                    if (n3 == 0) {
                        this.start = (Comparable)objectArray[0];
                    }
                }
                --this.count;
                this.modified = true;
                return true;
            }
            return false;
        }

        boolean contains(ID id, DiskExtendedSet<ID> set) {
            int n2;
            Object[] objectArray = this.getValues(set);
            return Arrays.binarySearch(objectArray, 0, n2 = this.count, id) >= 0;
        }

        @Nonnull
        SetPage<ID> split() {
            SetPage<ID> setPage = new SetPage<ID>();
            int n2 = this.count / 2;
            setPage.start = (Comparable)this.values[n2];
            setPage.count = this.count - n2;
            setPage.values = Arrays.copyOfRange(this.values, n2, n2 + this.count);
            setPage.modified = true;
            this.count = n2;
            this.modified = true;
            return setPage;
        }
    }

    @FunctionalInterface
    private static interface a<T> {
        public T read(FileChannel var1) throws IOException;
    }

    private static class b {
        long a;
        boolean b;

        private b() {
        }
    }
}

