/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.truetype;

import com.inet.cache.internal.HardDiskExternalDataWriterFactory;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.font.CharGlyphMap;
import com.inet.font.FontFamily;
import com.inet.font.FontUtils;
import com.inet.font.truetype.CmapSubTableInfo;
import com.inet.font.truetype.CmapSubTableList;
import com.inet.font.truetype.FontDescription;
import com.inet.font.truetype.FontFactory;
import com.inet.font.truetype.FontLanguageID;
import com.inet.font.truetype.SubFontTT;
import com.inet.font.truetype.TTFont;
import com.inet.font.truetype.TTFontData;
import com.inet.font.unicode.UnicodeBlockHandler;
import com.inet.font.unicode.UnicodeBlockOnePointChecker;
import com.inet.font.unicode.UnicodeCharBlock;
import com.inet.font.unicode.UnicodeCharBlockGroupList;
import com.inet.lib.list.IntList;
import com.inet.lib.list.StringList;
import com.inet.logging.LogManager;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.SuppressFBWarnings;

public class FontCollection {
    private static final byte[] a = FontUtils.getBytes("ttcf");
    private static final int FONT_HEADER_MIN_SIZE = 32;
    private String b;
    private boolean c;
    private List<FontFactory> d;
    private String[][] e;
    private String[][] f;
    private StringList g = new StringList();
    private StringList h = new StringList();
    private boolean i;
    private String j;
    private boolean[] k;
    private int[] l;
    private int m = 1;
    private boolean n;
    private static final int BUFFER_SIZE0 = 1024;
    private static final String STANDARD_ENCODING = "ISO-8859-1";
    private static final int CMAP3_0 = 1;
    private static final int CMAP0_0 = 2;
    private static final int CMAP0_3 = 2;
    private static final int SYMBOLIC_CODE_RANGE = 4;
    private int[][] o;
    private RandomAccessFile p;
    private byte[] q = new byte[1024];
    private int[][] r;
    private int[] s;
    private int[] t;
    private int[] u;
    private int[] v;
    private int[] w;
    private int[] x;
    private int[] y;
    private int[] z;
    private int[] A;
    private int[] B;
    private int[] C;
    private int[] D;
    private int[] E;
    private int[] F;
    private int[] G;
    private int[] H;
    private int[] I;
    private int[] J;
    private int[] K;
    private int[] L;
    private int[] M;
    private int[] N;
    private int[][] O;
    private int[][] P;
    private int[][] Q;
    private String[][] R;
    private static final int NOT_INITIATED = -1;
    private static final int UNDEFINED = 0;
    private static final int MAC_APPLE = 4;
    private static final int WIN_SYMBOL = 6;
    private static final int WIN_UNICODE = 8;
    private int[] S;
    private int T = -1;
    private static final int BASE_LANGUAGE_ID = 1033;
    private int[] U;
    private int V = -1;
    private static IntList W;
    private int X;
    private boolean[] Y;
    private boolean[] Z;
    private CmapSubTableList[] aa;
    private String[] ab;
    private boolean ac;
    private boolean ad;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    FontCollection(String fontPath, boolean deleteOnFinalize) throws FileNotFoundException, IllegalStateException, UnsupportedOperationException {
        this.a(fontPath);
        this.c = deleteOnFinalize;
        try {
            this.p = new RandomAccessFile(this.getFontPath(), "r");
            if (this.n()) {
                if (this.isType1() && FontUtils.isProblematicFont(Font.createFont(0, new File(fontPath)))) {
                    return;
                }
                this.m();
                if (this.isType1() && FontUtils.isProblematicFont(Font.createFont(0, new File(fontPath)))) {
                    this.ad = true;
                }
            }
        }
        catch (Exception exception) {
            LogManager.getLogger("Reporting").error("Error by processing the font file '" + fontPath + "':");
            LogManager.getLogger("Reporting").error(exception);
        }
        finally {
            try {
                this.p.close();
                this.p = null;
            }
            catch (Throwable throwable) {}
        }
    }

    public static FontFactory[] getFontFactories(String fontPath) {
        return FontCollection.a(fontPath, false);
    }

    private static FontFactory[] a(String string, boolean bl) {
        try {
            FontCollection fontCollection = new FontCollection(string, false);
            if (fontCollection.d == null) {
                return null;
            }
            FontFactory[] fontFactoryArray = new FontFactory[fontCollection.d.size()];
            return fontCollection.d.toArray(fontFactoryArray);
        }
        catch (Exception exception) {
            LogManager.getLogger("Reporting").error(exception);
            return null;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    public static FontFactory[] getFontFactories(byte[] fontBytes) throws IOException {
        File file = HardDiskExternalDataWriterFactory.getDefaultDir();
        if (!file.isDirectory() && !file.mkdirs()) {
            LogManager.getLogger("Reporting").warn("Unable to create temp '" + String.valueOf(file) + "'folder for fonts. Font embedding in PDF files may be incorrect.");
        }
        File file2 = File.createTempFile("FontPool_TTFont", ".ttf", file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        bufferedOutputStream.write(fontBytes);
        bufferedOutputStream.close();
        String string = file2.getAbsolutePath();
        ShutdownManager.deleteOnShutdown(string);
        return FontCollection.a(string, true);
    }

    protected void finalize() {
        if (this.c) {
            ShutdownManager.delete(this.b);
        }
    }

    private void m() {
        this.d = new ArrayList<FontFactory>();
        for (int i2 = 0; i2 < this.m; ++i2) {
            CharGlyphMap[] charGlyphMapArray;
            Object object;
            int n2;
            if (!this.k[i2]) {
                if (this.f == null || this.f.length == 0 || i2 >= this.a().length || this.a()[i2] == null || this.a()[i2].length == 0) continue;
                LogManager.getApplicationLogger().info("font " + this.a()[i2][0] + " is not licensed for embedding");
                continue;
            }
            String[][] stringArray = this.i ? this.f : this.e;
            int n3 = n2 = this.S[i2] != -1 ? this.S[i2] : 0;
            if (n2 >= stringArray[i2].length) {
                n2 = 0;
            }
            String string = stringArray[i2][n2];
            String string2 = this.U[i2] != -1 ? stringArray[i2][this.U[i2]] : null;
            FontFamily fontFamily = new FontFamily(string2, string);
            fontFamily.setEmbedded(true);
            fontFamily.setFamilyClass(this.ab[i2]);
            fontFamily.setFontRank(FontUtils.getFontRank(string));
            fontFamily.setType1(this.isType1());
            fontFamily.setProblematic(this.ad);
            if (this.X != 0) {
                int n4 = this.f[i2].length;
                object = this.f[i2][n4 > n2 ? n2 : n4 - 1];
                fontFamily.setStyle(this.X);
                fontFamily.setFaceName((String)object);
            }
            if (!this.a(i2, charGlyphMapArray = new CharGlyphMap[1])) continue;
            object = new FontFactory(fontFamily, this.X, this.f[i2], this, i2, this.e[i2]);
            ((FontFactory)object).a(this.j(i2));
            this.d.add((FontFactory)object);
            UnicodeCharBlockGroupList unicodeCharBlockGroupList = UnicodeCharBlockGroupList.getUnicodeCharBlockGroupList(this.o[i2]);
            CharGlyphMap charGlyphMap = charGlyphMapArray[0];
            UnicodeBlockOnePointChecker unicodeBlockOnePointChecker = new UnicodeBlockOnePointChecker(charGlyphMap);
            UnicodeBlockHandler unicodeBlockHandler = new UnicodeBlockHandler(unicodeCharBlockGroupList, unicodeBlockOnePointChecker);
            ArrayList<UnicodeCharBlock> arrayList = new ArrayList<UnicodeCharBlock>();
            unicodeBlockHandler.handle(unicodeCharBlockGroupList, arrayList);
            fontFamily.setUnicodeCharBlocks(arrayList);
        }
    }

    private boolean n() throws IllegalStateException, UnsupportedOperationException {
        int n2;
        int n3 = 0;
        try {
            n3 = this.p.read(this.q, 0, 1024);
            if (n3 < 32) {
                LogManager.getApplicationLogger().error("invalid font size: " + n3 + "< 32");
                return false;
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable.getMessage());
        }
        int n4 = 0;
        if (this.getFontPath().toLowerCase().endsWith(".ttc")) {
            this.n = true;
            if (!TTFont.a(this.q, 0, a, true)) {
                throw new IllegalStateException("invalid ttc file name ");
            }
            n4 = 8;
            this.m = this.h(n4);
            n4 += 4;
            if (this.m < 1) {
                throw new IllegalStateException("invalid ttc directory count: " + this.m);
            }
            this.l = new int[this.m];
        }
        int n5 = n4;
        this.O = new int[this.m][];
        this.P = new int[this.m][];
        this.Q = new int[this.m][];
        this.R = new String[this.m][];
        this.s = new int[this.m];
        this.t = new int[this.m];
        this.u = new int[this.m];
        this.v = new int[this.m];
        this.w = new int[this.m];
        this.x = new int[this.m];
        this.y = new int[this.m];
        this.z = new int[this.m];
        this.A = new int[this.m];
        this.B = new int[this.m];
        this.C = new int[this.m];
        this.D = new int[this.m];
        this.E = new int[this.m];
        this.F = new int[this.m];
        this.G = new int[this.m];
        this.H = new int[this.m];
        this.I = new int[this.m];
        this.J = new int[this.m];
        this.K = new int[this.m];
        this.L = new int[this.m];
        this.M = new int[this.m];
        this.N = new int[this.m];
        this.r = new int[this.m][SubFontTT.b.length];
        this.k = new boolean[this.m];
        this.ab = new String[this.m];
        this.o = new int[this.m][4];
        this.e = new String[this.m][];
        this.f = new String[this.m][];
        this.S = new int[this.m];
        this.U = new int[this.m];
        this.Y = new boolean[this.m];
        this.Z = new boolean[this.m];
        for (n2 = 0; n2 < this.m; ++n2) {
            this.S[n2] = -1;
            this.U[n2] = -1;
        }
        this.aa = new CmapSubTableList[this.m];
        for (n2 = 0; n2 < this.m; ++n2) {
            this.aa[n2] = new CmapSubTableList();
        }
        for (n2 = 0; n2 < this.m; ++n2) {
            int n6;
            this.c()[n2] = -1;
            this.d()[n2] = -1;
            this.e()[n2] = -1;
            this.f()[n2] = -1;
            this.g()[n2] = -1;
            this.x[n2] = -1;
            this.h()[n2] = -1;
            this.i()[n2] = -1;
            this.A[n2] = -1;
            this.B[n2] = -1;
            this.j()[n2] = -1;
            this.k()[n2] = -1;
            this.E[n2] = -1;
            this.F[n2] = -1;
            this.G[n2] = -1;
            int n7 = 0;
            if (this.n) {
                n4 = n5 + n2 * 4;
                this.l[n2] = n7 = this.h(n4);
            }
            if ((n6 = this.e(n4 = n7)) != 65536) {
                if (n6 == 0x4F54544F) {
                    LogManager.getApplicationLogger().debug("OTF Font " + this.getFontPath());
                } else {
                    throw new IllegalStateException("UNKNOWN FONT TYPE VERSION: " + n6);
                }
            }
            int n8 = this.f(n4 += 4);
            this.a(n4 += 8, n8, n2);
            this.c(n2);
            this.b(n2);
            this.p();
        }
        this.i(0);
        this.g = null;
        this.h = null;
        return true;
    }

    private FontDescription b(int n2) {
        int n3;
        int n4;
        FontDescription fontDescription = new FontDescription();
        int n5 = this.y[n2];
        if (n5 == -1 || (n4 = this.O[n2][n5]) == -1) {
            throw new RuntimeException("Table OS/2 not found");
        }
        this.k[n2] = false;
        try {
            this.p.seek(n4 + 8);
            n3 = this.p.readShort();
            if (n3 != 2) {
                this.k[n2] = true;
            }
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().info("can not resolve permission for embedding:");
            LogManager.getApplicationLogger().error(throwable);
        }
        n3 = -1;
        int n6 = -1;
        int n7 = -1;
        boolean bl = false;
        boolean bl2 = false;
        try {
            this.p.seek(n4 + 30);
            n3 = this.p.readShort();
            int n8 = this.p.read();
            n6 = this.p.read();
            int n9 = this.p.read();
            n7 = this.p.read();
            this.p.skipBytes(6);
            this.o[n2][0] = this.p.readInt();
            this.o[n2][1] = this.p.readInt();
            this.o[n2][2] = this.p.readInt();
            this.o[n2][3] = this.p.readInt();
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().info("can not read unicode intervals");
            LogManager.getApplicationLogger().error(throwable);
        }
        try {
            n5 = this.z[n2];
            if (n5 == -1 || (n4 = this.O[n2][n5]) == -1) {
                LogManager.getApplicationLogger().error("Table POST not found");
            } else {
                this.p.seek(n4 + 12);
                bl2 = this.p.readInt() != 0;
                bl = true;
            }
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().info("can not read post table");
            LogManager.getApplicationLogger().error(throwable);
        }
        this.ab[n2] = FontDescription.getFontFamilyClass(n3, n6, n7, bl, bl2);
        return fontDescription;
    }

    private void c(int n2) {
        int n3 = this.getEntriesOffsetsTTC()[n2][this.x[n2]];
        if (n3 == -1) {
            LogManager.getApplicationLogger().info("Table name not found");
            return;
        }
        this.d(0);
        int n4 = 0;
        int n5 = 0;
        try {
            this.p.seek(n3 + 2);
            n4 = this.p.readUnsignedShort();
            n5 = this.p.readUnsignedShort();
            if (n4 < 1 || n4 > 1000) {
                LogManager.getApplicationLogger().error("invalid names number " + n4 + " in font " + n2);
                this.e[n2] = new String[1];
                this.e[n2][0] = "";
                this.f[n2] = new String[1];
                this.f[n2][0] = "";
                return;
            }
            long l2 = 0L;
            block8: for (int i2 = 0; i2 < n4; ++i2) {
                int n6 = this.p.readUnsignedShort();
                int n7 = this.p.readUnsignedShort();
                int n8 = this.p.readUnsignedShort();
                int n9 = this.p.readUnsignedShort();
                switch (n9) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        this.m(4);
                        continue block8;
                    }
                }
                int n10 = this.p.readUnsignedShort();
                int n11 = this.p.readUnsignedShort();
                l2 = this.p.getFilePointer();
                int n12 = n3 + n5 + n11;
                String string = n6 == 0 || n6 == 3 || n6 == 2 && n7 == 1 ? this.b(n12, n10) : this.a(n12, n10);
                this.a(n6, n7, n8, n9, string, n2);
                this.p.seek(l2);
            }
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().error("by reading font names:");
            LogManager.getApplicationLogger().error(throwable);
        }
        this.o();
        this.e[n2] = this.g.toArray();
        this.f[n2] = this.h.toArray();
        this.d(0);
    }

    private void o() {
        int n2 = this.g.size();
        if (n2 == 0) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            int n3;
            String string2 = this.g.elementAt(i2);
            for (n3 = 0; n3 < this.h.size() && (string = this.h.elementAt(n3)).indexOf(string2) == -1; ++n3) {
            }
            if (n3 != this.h.size()) continue;
            this.b(string2);
        }
    }

    private void d(int n2) {
        this.g.setSize(n2);
        this.h.setSize(n2);
    }

    private void b(String string) {
        this.h.addElement(string);
    }

    private void a(int n2, int n3, int n4) throws UnsupportedOperationException {
        this.O[n4] = new int[n3];
        int[] nArray = this.O[n4];
        this.P[n4] = new int[n3];
        int[] nArray2 = this.P[n4];
        this.Q[n4] = new int[n3];
        int[] nArray3 = this.Q[n4];
        this.R[n4] = new String[n3];
        String[] stringArray = this.R[n4];
        for (int i2 = 0; i2 < n3; ++i2) {
            String string;
            if (i2 > 0) {
                n2 += 16;
            }
            stringArray[i2] = string = this.a(n2, 4);
            if (string.equals("cmap")) {
                this.s[n4] = i2;
            } else if (string.equals("head")) {
                this.t[n4] = i2;
            } else if (string.equals("hhea")) {
                this.u[n4] = i2;
            } else if (string.equals("hmtx")) {
                this.v[n4] = i2;
            } else if (string.equals("maxp")) {
                this.w[n4] = i2;
            } else if (string.equals("name")) {
                this.x[n4] = i2;
            } else if (string.equals("OS/2")) {
                this.y[n4] = i2;
            } else if (string.equals("post")) {
                this.z[n4] = i2;
            } else if (string.equals("cvt ")) {
                this.A[n4] = i2;
            } else if (string.equals("fpgm")) {
                this.B[n4] = i2;
            } else if (string.equals("glyf")) {
                this.C[n4] = i2;
            } else if (string.equals("loca")) {
                this.D[n4] = i2;
            } else if (string.equals("prep")) {
                this.E[n4] = i2;
            } else if (string.equals("kern")) {
                this.F[n4] = i2;
            } else if (string.equals("DSIG")) {
                this.H[n4] = i2;
            } else if (string.equals("GDEF")) {
                this.I[n4] = i2;
            } else if (string.equals("GPOS")) {
                this.J[n4] = i2;
            } else if (string.equals("GSUB")) {
                this.K[n4] = i2;
            } else if (string.equals("LTSH")) {
                this.L[n4] = i2;
            } else if (string.equals("gasp")) {
                this.M[n4] = i2;
            } else if (string.equals("hdmx")) {
                this.N[n4] = i2;
            } else if (string.equals("CFF ")) {
                this.G[n4] = i2;
                this.a(true);
            }
            nArray3[i2] = this.e(n2 + 4);
            int n5 = nArray[i2] = this.e(n2 + 8);
            if (n5 < 0) {
                throw new UnsupportedOperationException("Offset of table is negative: " + string);
            }
            nArray2[i2] = this.e(n2 + 12);
        }
        if (this.ac) {
            this.r[n4][0] = this.G[n4];
            this.r[n4][1] = this.s[n4];
            this.r[n4][2] = this.t[n4];
            this.r[n4][3] = this.u[n4];
            this.r[n4][4] = this.v[n4];
            this.r[n4][5] = this.w[n4];
            this.r[n4][6] = this.x[n4];
            this.r[n4][7] = this.z[n4];
            this.r[n4][8] = this.y[n4];
        } else {
            this.r[n4][0] = this.s[n4];
            this.r[n4][1] = this.A[n4];
            this.r[n4][2] = this.B[n4];
            this.r[n4][3] = this.C[n4];
            this.r[n4][4] = this.t[n4];
            this.r[n4][5] = this.u[n4];
            this.r[n4][6] = this.v[n4];
            this.r[n4][7] = this.D[n4];
            this.r[n4][8] = this.w[n4];
            this.r[n4][9] = this.E[n4];
            this.r[n4][10] = this.x[n4];
            this.r[n4][11] = this.z[n4];
            this.r[n4][12] = this.y[n4];
        }
    }

    private int e(int n2) {
        try {
            this.p.seek(n2);
            return this.p.readInt();
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().error(throwable);
            throw new RuntimeException();
        }
    }

    private int f(int n2) {
        try {
            this.p.seek(n2);
            return this.p.readUnsignedShort();
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().error(throwable);
            throw new RuntimeException();
        }
    }

    private char g(int n2) {
        try {
            this.p.seek(n2);
            return this.p.readChar();
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().error(throwable);
            throw new RuntimeException();
        }
    }

    private String a(int n2, int n3) {
        byte[] byArray = new byte[n3];
        try {
            this.p.seek(n2);
            int n4 = this.p.read(byArray, 0, n3);
            if (n4 < n3) {
                throw new RuntimeException("unexpected end of font file");
            }
            return new String(byArray, STANDARD_ENCODING);
        }
        catch (Exception exception) {
            throw new RuntimeException("can't read string: " + exception.getMessage());
        }
    }

    private String b(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        n3 /= 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(this.g(n2));
            n2 += 2;
        }
        return stringBuilder.toString();
    }

    private int h(int n2) {
        int n3 = this.q[n2] & 0xFF;
        int n4 = this.q[n2 + 1] & 0xFF;
        int n5 = this.q[n2 + 2] & 0xFF;
        int n6 = this.q[n2 + 3] & 0xFF;
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    private int c(int n2, int n3) {
        int n4 = 0;
        switch (n2) {
            case 3: {
                if (n3 == 0) {
                    n4 = 6;
                    break;
                }
                if (n3 != 1) break;
                n4 = 8;
                break;
            }
            case 0: 
            case 1: {
                n4 = 4;
            }
        }
        return n4;
    }

    private void a(int n2, int n3, int n4, int n5, String string, int n6) {
        if (string.trim().length() == 0) {
            LogManager.getApplicationLogger().error("true type fonts: name not found");
            return;
        }
        boolean bl = n4 == 1033 || n4 == 0;
        boolean bl2 = !bl && W != null && W.contains(n4);
        int n7 = this.c(n2, n3);
        StringList stringList = null;
        block0 : switch (n5) {
            case 1: {
                stringList = this.g;
                int n8 = stringList.indexOf(string);
                if (n8 == -1) {
                    n8 = stringList.size();
                    stringList.addElement(string);
                }
                if (bl && n7 >= this.T || n7 > this.T) {
                    this.S[n6] = n8;
                    this.T = n7;
                }
                if (!bl2 || n7 < this.V) break;
                this.U[n6] = n8;
                this.V = n7;
                break;
            }
            case 2: {
                if (!bl) break;
                switch (string) {
                    case "": 
                    case "Regular": 
                    case "Bold": 
                    case "Bold Italic": 
                    case "Bold Oblique": 
                    case "Italic": 
                    case "Oblique": {
                        break block0;
                    }
                }
                this.i = true;
                break;
            }
            case 4: {
                stringList = this.h;
                int n9 = stringList.indexOf(string);
                if (n9 != -1) break;
                stringList.addElement(string);
                break;
            }
            case 6: {
                if (this.j != null && (n2 != 3 || n3 != 1)) break;
                this.j = string;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void p() {
        this.T = -1;
        this.V = -1;
    }

    private void i(int n2) {
        int n3 = this.getEntriesOffsetsTTC()[n2][this.h()[n2]];
        if (n3 == -1) {
            LogManager.getApplicationLogger().info("Table OS_2 not found");
            return;
        }
        try {
            boolean bl;
            this.p.seek(n3 + 2);
            this.m(60);
            int n4 = this.p.readUnsignedShort();
            boolean bl2 = (n4 & 1) > 0;
            boolean bl3 = (n4 & 0x20) > 0;
            boolean bl4 = bl = (n4 & 0x40) > 0;
            if (bl && (bl2 || bl3)) {
                LogManager.getApplicationLogger().warn("font  is bad defined");
                bl3 = false;
                bl2 = false;
            }
            if (bl3) {
                this.X |= 1;
            }
            if (bl2) {
                this.X |= 2;
            }
        }
        catch (IOException iOException) {
            LogManager.getApplicationLogger().error("can not read font style");
        }
    }

    private boolean j(int n2) {
        if (this.Z[n2]) {
            return this.Y[n2];
        }
        this.Z[n2] = true;
        boolean bl = false;
        try {
            int n3 = this.k(n2);
            switch (n3) {
                case 5: 
                case 6: 
                case 7: {
                    bl = TTFontData.a(this, n2, this.p);
                }
            }
        }
        catch (Exception exception) {
            LogManager.getApplicationLogger().error("font reading: " + exception.getMessage());
        }
        this.Y[n2] = bl;
        return bl;
    }

    private int a(int n2, String string) throws IOException, IllegalArgumentException {
        int n3 = -2;
        if (string.equals("cmap")) {
            n3 = this.c()[n2];
        } else if (string.equals("OS/2")) {
            n3 = this.h()[n2];
        }
        if (n3 == -2) {
            throw new IllegalArgumentException("invalid table name: " + string);
        }
        if (n3 == -1) {
            throw new IllegalArgumentException("invalid index of " + string);
        }
        if (this.getEntriesOffsetsTTC()[n2][n3] == -1) {
            throw new IOException("Font tabel " + string + " not found");
        }
        int n4 = this.getEntriesOffsetsTTC()[n2][n3];
        return n4;
    }

    private int k(int n2) throws IOException {
        int n3 = 0;
        int n4 = this.a(n2, "cmap");
        this.p.seek(n4);
        int n5 = this.p.readUnsignedShort();
        int n6 = this.p.readUnsignedShort();
        block8: for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = this.p.readUnsignedShort();
            int n8 = this.p.readUnsignedShort();
            this.m(4);
            block0 : switch (n7) {
                case 3: {
                    if (n8 != 0) continue block8;
                    n3 |= 1;
                    continue block8;
                }
                case 0: {
                    switch (n8) {
                        case 0: {
                            n3 |= 2;
                            break block0;
                        }
                        case 3: {
                            n3 |= 2;
                        }
                    }
                }
            }
        }
        if (n3 != 0 && this.l(n2)) {
            n3 |= 4;
        }
        return n3;
    }

    private boolean l(int n2) throws IOException {
        int n3 = this.a(n2, "OS/2");
        this.p.seek(n3);
        int n4 = this.p.readUnsignedShort();
        this.m(76);
        if (n4 > 0) {
            int n5 = this.p.readInt();
            return (n5 & Integer.MIN_VALUE) != 0;
        }
        return true;
    }

    FontFactory a(int n2) {
        return this.d.get(n2);
    }

    private void m(int n2) throws IOException {
        if (this.p.skipBytes(n2) < n2) {
            throw new IOException("expected longer font file");
        }
    }

    void a(String string) {
        this.b = string;
    }

    public String getFontPath() {
        return this.b;
    }

    String[][] a() {
        return this.f;
    }

    int[][] b() {
        return this.r;
    }

    int[] c() {
        return this.s;
    }

    int[] d() {
        return this.t;
    }

    int[] e() {
        return this.u;
    }

    int[] f() {
        return this.v;
    }

    int[] g() {
        return this.w;
    }

    int[] h() {
        return this.y;
    }

    int[] i() {
        return this.z;
    }

    int[] j() {
        return this.C;
    }

    int[] k() {
        return this.D;
    }

    public int[] getCffIndexesInTTC() {
        return this.G;
    }

    public int[][] getEntriesOffsetsTTC() {
        return this.O;
    }

    public int[][] getEntriesLengthsTTC() {
        return this.P;
    }

    public int[][] getEntriesCheckSumTTC() {
        return this.Q;
    }

    String[][] l() {
        return this.R;
    }

    private boolean a(int n2, CharGlyphMap[] charGlyphMapArray) {
        try {
            int n3;
            int n4 = this.getEntriesOffsetsTTC()[n2][this.c()[n2]];
            this.p.seek(n4);
            int n5 = this.p.readUnsignedShort();
            if (n5 != 0) {
                LogManager.getApplicationLogger().info("cmap version " + n5);
            }
            if ((n3 = this.p.readUnsignedShort()) == 0) {
                LogManager.getApplicationLogger().info("no cmap subtables found");
                return false;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                int n6 = this.p.readUnsignedShort();
                int n7 = this.p.readUnsignedShort();
                int n8 = this.p.readInt();
                this.aa[n2].a(n6, n7, n8);
                if (n6 != 3 || n7 != 10) continue;
                long l2 = this.p.getFilePointer();
                this.p.seek(n4 + n8);
                int n9 = this.p.readUnsignedShort();
                if (n9 == 12) {
                    charGlyphMapArray[0] = TTFontData.a(this.p);
                }
                this.p.seek(l2);
            }
            return this.aa[n2].a() != null;
        }
        catch (IOException iOException) {
            LogManager.getApplicationLogger().error(iOException);
            return false;
        }
    }

    public CmapSubTableInfo getPreferredSubTableInfo(int indexInTTC) {
        return this.aa[indexInTTC].a();
    }

    public String getFamilyClass(int ttcFontIndex) {
        return this.ab[ttcFontIndex];
    }

    private void a(boolean bl) {
        this.ac = bl;
    }

    public boolean isType1() {
        return this.ac;
    }

    public String getPostscriptName() {
        return this.j;
    }

    public boolean isProblematic() {
        return this.ad;
    }

    static {
        Locale locale = Locale.getDefault();
        W = FontLanguageID.a(locale);
    }
}

