/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fieldgroups;

import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.base.LoginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fieldgroups.FieldPanelDefinition;
import com.inet.usersandgroups.api.user.UserAccountType;
import java.util.List;

public class LoginsFieldPanelDefinition
extends FieldPanelDefinition {
    public static final String FIELD_PANEL_KEY = "logins";

    public LoginsFieldPanelDefinition() {
        this(UserAccountType.Standard);
    }

    public LoginsFieldPanelDefinition(UserAccountType accountType) {
        super(Type.user, accountType.name(), FIELD_PANEL_KEY, 150, true, false);
    }

    @Override
    public String getEmptyHint() {
        return UsersAndGroups.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.logins.emptyHint", new Object[0]);
    }

    @Override
    public String getDisplayName() {
        return UsersAndGroups.MSG.getMsg("usersandgroupsmanager.fieldPanelDefinition.logins.name", new Object[0]);
    }

    @Override
    public boolean isAvailable() {
        List<AuthenticationDescription> list = LoginManager.getAllAuthenticationDescriptions();
        for (AuthenticationDescription authenticationDescription : list) {
            if ("guest".equalsIgnoreCase(authenticationDescription.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRequiredPermissionForViewing(boolean showingOwnUserData) {
        return showingOwnUserData ? 0 : 2;
    }

    @Override
    public int getRequiredPermissionForEditing(boolean showingOwnUserData) {
        return showingOwnUserData ? 0 : 3;
    }
}

