/*
 * Decompiled with CFR 0.152.
 */
package com.inet.permissions;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.i18n.DisplayableKey;
import com.inet.lib.i18n.DisplayableMapCache;
import com.inet.permissions.PermissionCategory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

@InternalApi
public class Permission
implements DisplayableKey<String>,
Serializable {
    private static final ConcurrentHashMap<String, Permission> a = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, PermissionCategory> b = new ConcurrentHashMap<String, PermissionCategory>(){
        {
            this.put(PermissionCategory.DEFAULT.a(), PermissionCategory.DEFAULT);
        }
    };
    private String c;
    private int d;
    private boolean e;
    private final String f;
    private final transient Object g;
    private final String h;
    private final String i;
    @Nonnull
    public static final Permission CONFIGURATION = new Permission("configuration", "administration", null, 6500, false, "com.inet.permissions.i18n.Translations", Permission.class);

    private Permission() {
        this("");
    }

    public Permission(String key) {
        this.c = key;
        this.h = PermissionCategory.DEFAULT.a();
        this.i = null;
        this.f = null;
        this.g = null;
        this.d = 10000;
    }

    Permission(String key, String categoryKey, String parentKey, int sortId, boolean isPlusLicense, String resourceBundleName, Object caller) {
        if (a.containsKey(key)) {
            throw new IllegalStateException("Key already exists: " + key);
        }
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (key.contains("\"") || key.contains(",")) {
            throw new IllegalArgumentException("Key must not contain \" or ,");
        }
        if (!b.containsKey(categoryKey)) {
            PermissionCategory permissionCategory = new PermissionCategory(categoryKey, resourceBundleName, caller);
            b.put(permissionCategory.a(), permissionCategory);
        }
        a.put(key, this);
        this.c = key;
        this.h = categoryKey;
        this.i = parentKey;
        this.d = sortId;
        this.e = isPlusLicense;
        this.f = resourceBundleName;
        this.g = caller;
    }

    @Nonnull
    public static Permission[] values() {
        return a.values().toArray(new Permission[0]);
    }

    @Nonnull
    public static Permission valueOf(String key) throws IllegalArgumentException {
        Permission permission = a.get(key);
        if (permission == null) {
            throw new IllegalArgumentException("No Permission " + key);
        }
        return permission;
    }

    @Nonnull
    public static Permission valueOfExistingOrCreate(String key) {
        Permission permission = a.get(key);
        if (permission == null) {
            return new Permission(key);
        }
        return permission;
    }

    @Override
    public String getDisplayName() {
        if (this.f != null && this.g != null) {
            try {
                ResourceBundle resourceBundle = LoaderUtils.getBundle(this.f, ClientLocale.getThreadLocale(), this.g);
                return resourceBundle.getString("Permissions." + this.c);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return this.c;
    }

    public static Map<String, String> getDisplayNameMap() {
        return DisplayableMapCache.getMap(a.values(), Permission.class, a.size());
    }

    public String getCategoryKey() {
        return this.h;
    }

    public PermissionCategory getCategory() {
        return b.get(this.h);
    }

    public String getParentKey() {
        return this.i;
    }

    public String getCategoryDisplayName() {
        PermissionCategory permissionCategory = b.get(this.h);
        return permissionCategory.b();
    }

    public boolean isPlusLicense() {
        return this.e;
    }

    @Override
    public String getKey() {
        return this.c;
    }

    public int getSortId() {
        return this.d;
    }

    public String toString() {
        return this.c;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.c.equals(((Permission)obj).c);
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    public static void createCategory(String categoryKey, int sortId, @Nonnull Class<?> caller) {
        Object object = caller.getName();
        int n2 = ((String)object).lastIndexOf(46);
        object = ((String)object).substring(0, n2 + 1) + "structure.i18n.ConfigStructure";
        Permission.createCategory(categoryKey, sortId, (String)object, caller);
    }

    public static void createCategory(String categoryKey, int sortId, String resourceBundle, @Nonnull Class<?> caller) {
        if (categoryKey == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (categoryKey.contains("\"") || categoryKey.contains(",")) {
            throw new IllegalArgumentException("categoryKey must not contain \" or ,");
        }
        PermissionCategory permissionCategory = new PermissionCategory(categoryKey, sortId, resourceBundle, caller);
        b.put(permissionCategory.a(), permissionCategory);
    }

    public static Set<Permission> filterOutPermissionsWithoutGrantedAncestorPermissions(Set<Permission> permissions) {
        HashSet<Permission> hashSet = new HashSet<Permission>();
        for (Permission permission : permissions) {
            boolean bl = true;
            String string = permission.getParentKey();
            while (string != null) {
                Permission permission2 = Permission.valueOfExistingOrCreate(string);
                if (!permissions.contains(permission2)) {
                    bl = false;
                    break;
                }
                string = permission2.getParentKey();
            }
            if (!bl) continue;
            hashSet.add(permission);
        }
        return hashSet;
    }
}

