/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationManagerImplBase;
import com.inet.config.LicenseInfo;
import com.inet.config.PreferencesProvider;
import com.inet.config.PreferencesProviderImpl;
import com.inet.config.internal.NodeRestarter;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.logging.LogID;
import com.inet.logging.LogManager;
import com.inet.persistence.Persistence;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.FeatureLicenseInformation;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.utils.Version;
import com.inet.thread.ThreadUtils;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.prefs.BackingStoreException;
import javax.crypto.Cipher;

public class ConfigurationManagerImpl
extends ConfigurationManagerImplBase {
    private boolean a;
    private a b = new a();

    public ConfigurationManagerImpl() {
        this(new PreferencesProviderImpl("/com/inet/report/config/cc"), "/com/inet/report/config/cc");
    }

    private ConfigurationManagerImpl(PreferencesProvider prefProvider, String prefNodePath) {
        super(prefProvider, prefNodePath);
        this.b.start();
        ISINIT = true;
    }

    @Override
    public void stopImpl() {
        this.a = true;
        ThreadUtils.stopThread(this.b);
    }

    void b() {
        try {
            ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
            serverPluginManager.waitOnInitState(300);
            if (CoreSystemStructureProvider.isDesigner() || ConfigurationManager.isRecoveryMode()) {
                return;
            }
            ApplicationDescription applicationDescription = ApplicationDescription.get();
            String string = applicationDescription.getApplicationName();
            int n2 = applicationDescription.getVersion().getMajor();
            Configuration configuration = this.getCurrent();
            String string2 = configuration.get(ConfigKey.LICENSEKEY);
            List<LicenseInfo> list = ConfigKeyParser.getAll();
            String string3 = string2;
            if (!string2.equals(string3 = ConfigurationManagerImpl.a(true, list, string, n2, string3))) {
                configuration.put(ConfigKey.LICENSEKEY, string3);
                string2 = string3;
                list = ConfigKeyParser.getAll();
            }
            if (ConfigKeyParser.getCurrent().isValid()) {
                for (FeatureLicenseInformation featureLicenseInformation : ServerPluginManager.getInstance().get(FeatureLicenseInformation.class)) {
                    string3 = ConfigurationManagerImpl.a(false, list, featureLicenseInformation.getFeature(), n2, string3);
                }
                if (!string2.equals(string3)) {
                    configuration.put(ConfigKey.LICENSEKEY, string3);
                }
            }
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error(throwable);
        }
    }

    private static String a(boolean bl, List<LicenseInfo> list, String string, int n2, String object) throws Throwable {
        if (ConfigKeyParser.hasValidLicenseFor(string)) {
            return object;
        }
        for (LicenseInfo licenseInfo : list) {
            String string2;
            Map<String, String> map = licenseInfo.getAttributes();
            if (!bl ? (string2 = map.get("features")) == null || !Arrays.asList(string2.split(",")).contains(string) : !string.equals(map.get("app"))) continue;
            if (!licenseInfo.isTrial()) {
                return object;
            }
            string2 = map.get("version");
            if (string2 == null) {
                return object;
            }
            int n3 = new Version(string2).getMajor();
            if (n2 != n3) continue;
            return object;
        }
        String string3 = CoreSystemStructureProvider.requestTrialLicenseKey(string);
        if (!((String)object).contains(string3)) {
            object = ((String)object).isEmpty() ? string3 : (String)string3 + "," + (String)object;
        }
        return object;
    }

    private class a
    extends Thread {
        a() {
            super("Configuration change monitor");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            AccessController.doPrivileged(() -> {
                Configuration configuration;
                LogID.setID("ConfMon");
                try {
                    Cipher.getInstance("RSA");
                    ServerPluginManager.getInstance().waitOnInitState(30);
                    if (ServerPluginManager.getInstance().getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
                        LogManager.getConfigLogger().error("Server start takes too long");
                    }
                    if ((configuration = ConfigurationManagerImpl.this.currentConfig) != null) {
                        ConfigKeyParser.getCurrent();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ForkJoinPool.commonPool().execute(() -> ConfigurationManagerImpl.this.b());
                Persistence.getInstance().registerListener(new NodeRestarter());
                while (true) {
                    String string;
                    long l2;
                    String string2;
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!ConfigurationManagerImpl.this.a) {
                            LogManager.getConfigLogger().warn(interruptedException);
                        }
                        return null;
                    }
                    if (ConfigurationManagerImpl.this.a) {
                        return null;
                    }
                    configuration = (com.inet.config.a)ConfigurationManagerImpl.this.currentConfig;
                    if (configuration == null) continue;
                    try {
                        ((com.inet.config.a)configuration).a();
                    }
                    catch (BackingStoreException backingStoreException) {
                        LogManager.getConfigLogger().warn(backingStoreException);
                    }
                    catch (SecurityException securityException) {
                        LogManager.getConfigLogger().error(securityException);
                    }
                    if ((string2 = ((com.inet.config.a)configuration).get("timestamp")) == null || ConfigurationManagerImpl.this.timestamp == (l2 = Long.valueOf(string2).longValue())) continue;
                    LogManager.getConfigLogger().debug("timestamp has changed ... fetching new configuration");
                    ConfigurationManagerImpl.this.timestamp = l2;
                    int n2 = ((com.inet.config.a)configuration).getScope();
                    Configuration configuration2 = ConfigurationManagerImpl.this.getFromBackingStore(n2, string = ((com.inet.config.a)configuration).getName());
                    if (configuration2 == null) continue;
                    Class<?> clazz = ConfigurationManagerImpl.this.getClass();
                    synchronized (clazz) {
                        ConfigurationManagerImpl.this.currentConfig = configuration2;
                    }
                    ConfigurationManagerImpl.this.fireConfigurationChangeEvent(configuration2, 0);
                }
            });
        }
    }
}

