/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.base;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.RemoteLoginProcessor;
import com.inet.http.servlet.NopHttpServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class BasicAuthenticationProvider
implements AuthenticationProvider {
    @Override
    @Nullable
    public LoginProcessor createLoginProcessor(@Nonnull AuthenticationDescription description, @Nullable String authorization, HttpServletRequest request, boolean isApplication) {
        if (authorization == null || description.getBasicSupport() == AuthenticationDescription.BasicSupport.No) {
            return null;
        }
        if (authorization.startsWith("Basic ")) {
            RemoteLoginProcessor remoteLoginProcessor = (RemoteLoginProcessor)this.create(description);
            remoteLoginProcessor.transferClientLoginData(request, new NopHttpServletResponse());
            return remoteLoginProcessor;
        }
        return null;
    }

    @Override
    @Nullable
    public AuthenticationDescription getAuthenticationDescription(@Nonnull Map<String, String> settings, boolean isApplication, boolean isProxy) {
        return new AuthenticationDescription(this, settings, this.name(), AuthenticationDescription.BasicSupport.Only);
    }
}

