/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.message;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.generator.message.Chunk;
import com.inet.pdfc.generator.message.PageData;
import com.inet.pdfc.textselection.TextInfoImpl;
import java.util.ArrayList;
import java.util.List;

@JsonData
@InternalApi
public class PageDataImpl
implements PageData {
    private int pageIndex;
    private boolean first;
    private float height = 0.0f;
    private float width = 0.0f;
    private List<TextInfoImpl> textInfos = new ArrayList<TextInfoImpl>();

    public PageDataImpl(int pageIndex, boolean first, float width, float height) {
        this.pageIndex = pageIndex;
        this.first = first;
        this.width = width;
        this.height = height;
    }

    public PageDataImpl(int pageIndex, boolean first, List<TextInfoImpl> infos) {
        this.pageIndex = pageIndex;
        this.first = first;
        if (infos != null) {
            this.textInfos.addAll(infos);
        }
    }

    private PageDataImpl() {
    }

    @Override
    public boolean isFirst() {
        return this.first;
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPage(float width, float height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public List<TextInfoImpl> getTextInfos() {
        return this.textInfos;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public Chunk.ChunkType getType() {
        return this.width > 0.0f || this.height > 0.0f ? Chunk.ChunkType.pageParsed : Chunk.ChunkType.textInfoUpdate;
    }
}

