# Session Datasource Plugin

If you create a datasource in i-net Clear Reports then normally, all users see the same data with it. If you want different users to see different data for the same report then you can filter the data of a report in the record selection formula depending on the logged in user. Or you could set your server to use a database login and use the class "LoginDatabase" which causes your report to use the same database connection as the one for the current user.

Another solution are session datasources. A session datasource exists only during the runtime of the logged in user.

This sample demonstrates a `jakarta.servlet.Filter` which creates a session datasource with the name *datasource*, pointing to a MySQL database. The URL request parameters user, password, host, port and database must be set and will be used to create the datasource.

 Use this sample only inside a backend server which is protected from a frontend server. It would be unsafe to be injecting these credentials from outside of your intranet.

## Activate the included plugin

In order to test this plugin, you need to copy the plugin ZIP file `sessiondatasource.zip` into the plugins folder of your installation or upload the plugin using Drag & Drop in the Store application. Afterwards the server needs to be restarted. You can check if the plugin was loaded in the dialog Store application. If there are problems, then check the log file of the server for more details.

If you want to write your own filter then you need to create an instance of `jakarta.servlet.Filter` similar to the one in the sample. For more information please see the source files of this sample and the chapter `Platform Programming Guide | Plugins` in the Help of the SDK.

## Server Plugin

In the next step you write your own server plugin. It must implement the interface `com.inet.plugin.ServerPlugin` and have an empty public constructor for loading. In the method `registerExtension` you must register both of your classes. This can look like:

```java
public void registerExtension( ServerPluginManager spm ) {
    spm.register( Filter.class, new MyFilter() );
}
```

Please refer to the sample `com.inet.session.datasource.SessionDatasourcePlugin` to see how this is done there.

## Build the plugin

The following steps need to be taken if changes are made to the plugin code.

The `plugin.properties` and server plugin class are preconfigured to be used without modifications. If the sample is the basis for a custom plugin or just needs some adaptions, please refer to the platform programming guide for detailed instructions.

### Collect the required jar files

In order to build this plugin the following jar files are required at minimum:

  * `inetcore.jar` (included in the `core` directory)
  * `jakarta.servlet-api.jar` (included in the `core` directory)
  * `reporting.jar` (included in the `plugins/reporting.zip` file)

These files are part of the SDK but will also be loaded from our public maven server when using the packaged `build.gradle`.

### Build the plugin

The plugin must be compiled into a jar file that is named like the id of the plugin. In this example it is `sessiondatasource.jar`. It also must contain the compiled sources as well as required language resources and images.

The target plugin is a zip file, named `sessiondatasource.zip` in this example. It contains the compiled jar file and the `plugin.properties` which configures the custom plugin.

The provided `build.gradle` in the sample can be used to build the plugin as well as any other build system.

## Deploying

Copy the ZIP file of the plugin into the plugins directory of the server or Drag & Drop the plugin into the Store application of the server for sideloading. Then restart the server. If there are problems, then check the log file of the server for more details. The "Config" logger is used to log plugin registration issues.

