/*
 * Decompiled with CFR 0.152.
 */
package com.inet.samples.session.datasource;

import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;

public class UserInjection
implements Filter {
    private static final String DS_NAME = "datasource";

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest req = (HttpServletRequest)request;
        String user = request.getParameter("user");
        if (!UserInjection.isEmpty(user)) {
            String password = request.getParameter("password");
            String host = request.getParameter("host");
            String port = request.getParameter("port");
            String database = request.getParameter("database");
            if (!(DataSourceConfigurationManager.exists((String)DS_NAME, (int)6) || UserInjection.isEmpty(password) || UserInjection.isEmpty(host) || UserInjection.isEmpty(port) || UserInjection.isEmpty(database))) {
                DataSourceConfiguration dsc = DataSourceConfigurationManager.createDataSourceConfiguration((String)DS_NAME, (int)6);
                dsc.setUser(user);
                dsc.setDriverClassname("com.mysql.cj.jdbc.Driver");
                dsc.setUrl("jdbc:mysql://{host}:{port}/{database}");
                dsc.setPassword(password);
                dsc.addProperty("host", host);
                dsc.addProperty("port", port);
                dsc.addProperty("database", database);
                dsc.save();
            }
            req.getSession(true).setAttribute(this.getClass().getName(), (Object)new InjectedPrincipal(user));
        }
        request = new HttpServletRequestWrapper(req){

            public Principal getUserPrincipal() {
                return (Principal)req.getSession(true).getAttribute(UserInjection.this.getClass().getName());
            }
        };
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    static class InjectedPrincipal
    implements Principal,
    Serializable {
        private final String user;

        InjectedPrincipal(String user) {
            this.user = user;
        }

        @Override
        public String getName() {
            return this.user;
        }
    }
}

