/*
 * Decompiled with CFR 0.152.
 */
package com.inet.designer.sampledatabase.adhoc;

import com.inet.designer.sampledatabase.adhoc.c;
import com.inet.error.ErrorCode;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Fields;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.renderer.AbstractFormatableColumn;
import com.inet.report.adhoc.server.api.renderer.DataField;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.SortOrder;
import com.inet.report.adhoc.server.api.renderer.SummaryOperation;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
extends c {
    private static final Map<String, List<TemplateDataViewDefaults.Column>> c = Map.of("bowlingResults", Stream.concat(Stream.concat(Stream.concat(Stream.of(new TemplateDataViewDefaults.Column("bowlingResults.player", "Player Name", 11), new TemplateDataViewDefaults.Column("bowlingResults.date", "Date and Time", 15)), IntStream.rangeClosed(1, 10).boxed().flatMap(n -> Stream.of(new TemplateDataViewDefaults.Column("bowlingResults.s" + n + "_1", "Split " + n + "/1", 6), new TemplateDataViewDefaults.Column("bowlingResults.s" + n + "_2", "Split " + n + "/2", 6)))), Stream.of(new TemplateDataViewDefaults.Column("bowlingResults.s10_3", "Split 10/3", 6))), IntStream.rangeClosed(1, 10).boxed().flatMap(n -> Stream.of(new TemplateDataViewDefaults.Column("@frame" + n + "_score", "Frame Score " + n, 6)))).collect(Collectors.toList()));

    public a() {
        super(c);
    }

    @Nonnull
    public String getExtensionName() {
        return "Player Frame Performance";
    }

    @Nullable
    public String getDescription() {
        return "A Bowling Sample View";
    }

    @Override
    @Nullable
    public <T> T get(@Nonnull RendererPropertyKey<T> key) {
        if (key == TABLE_COLUMNS) {
            return (T)key.cast(this.getAvailableColumns().stream().filter(column -> !column.getKey().startsWith("@") && !"bowlingResults.date".equals(column.getKey())).map(column -> new TableColumnData(column.getKey())).toArray(TableColumnData[]::new));
        }
        if (key == TABLE_GROUPS) {
            return (T)key.cast((Object)new GroupData[]{new GroupData("bowlingResults.date", SortOrder.ASCENDING)});
        }
        if (key == CHART_CATEGORY) {
            return (T)key.cast((Object)new GroupData("bowlingResults.player", SortOrder.ASCENDING));
        }
        if (key == CHART_DATA_FIELDS) {
            return (T)key.cast(IntStream.rangeClosed(1, 10).boxed().flatMap(n -> Stream.of(new DataField("bowlingResults.s" + n + "_1", new SummaryOperation(1, 0, null), AbstractFormatableColumn.ValueFormat.NUMBER_FORMAT_INTEGER), new DataField("bowlingResults.s" + n + "_2", new SummaryOperation(1, 0, null), AbstractFormatableColumn.ValueFormat.NUMBER_FORMAT_INTEGER))).toArray(DataField[]::new));
        }
        if (key == CROSSTAB_COLUMNS) {
            return (T)key.cast((Object)new GroupData[]{new GroupData("@frame1_score", SortOrder.ASCENDING), new GroupData("@frame2_score", SortOrder.ASCENDING)});
        }
        if (key == CROSSTAB_ROWS) {
            return (T)key.cast((Object)new GroupData[]{new GroupData("@frame1_score", SortOrder.ASCENDING), new GroupData("@frame2_score", SortOrder.ASCENDING)});
        }
        if (key == CROSSTAB_DATA) {
            return (T)key.cast((Object)new DataField[]{new DataField("@frame1_score", new SummaryOperation(1, 0, null), AbstractFormatableColumn.ValueFormat.UNFORMATTED), new DataField("@frame2_score", new SummaryOperation(1, 0, null), AbstractFormatableColumn.ValueFormat.UNFORMATTED)});
        }
        return super.get(key);
    }

    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSource((String)"Sample Database");
            if (dataSourceConfiguration == null) {
                throw new IllegalStateException();
            }
            DatabaseTables databaseTables = engine.getDatabaseTables();
            Datasource datasource = databaseTables.getDatasource(0);
            datasource.setDataSourceConfiguration(dataSourceConfiguration);
            for (Map.Entry<String, List<TemplateDataViewDefaults.Column>> object2 : c.entrySet()) {
                String string = object2.getKey();
                List<TemplateDataViewDefaults.Column> list = object2.getValue();
                TableSource tableSource = datasource.createTableSource(string);
                for (TemplateDataViewDefaults.Column column2 : list) {
                    String string2 = column2.getKey();
                    if (string2.startsWith(string + ".")) {
                        string2 = string2.substring(string.length() + 1);
                    }
                    tableSource.addColumn(string2, column2.getDataType());
                }
            }
            Fields fields = engine.getFields();
            IntStream.rangeClosed(1, 9).forEach(n -> fields.addFormulaField("frame" + n + "_score", "{bowlingResults.s" + n + "_1} + {bowlingResults.s" + n + "_2}", 0));
            fields.addFormulaField("frame10_score", "{bowlingResults.s10_1} + {bowlingResults.s10_2} + {bowlingResults.s10_3}", 0);
            fields.addFormulaField("total_score", "{@frame1_score} + {@frame2_score} + {@frame3_score} + {@frame4_score} + {@frame5_score} + {@frame6_score} + {@frame7_score} + {@frame8_score} + {@frame9_score} + {@frame10_score}", 0);
            this.setSelectionFormula(engine, filter);
            List<@Nonnull T> list = this.getAvailableColumns().stream().map(column -> column).collect(Collectors.toList());
            return new SimpleDataView(list, engine);
        }
        catch (ReportException reportException) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)reportException);
        }
    }
}

