/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import smallsql.database.Columns;
import smallsql.database.Database;
import smallsql.database.ForeignKey;
import smallsql.database.ForeignKeys;
import smallsql.database.IndexDescription;
import smallsql.database.IndexDescriptions;
import smallsql.database.Lobs;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.StoreImpl;
import smallsql.database.StorePageLink;
import smallsql.database.TableStorePage;
import smallsql.database.TableStorePageInsert;
import smallsql.database.TableView;
import smallsql.database.Utils;

class Table
extends TableView {
    private static final int INDEX = 1;
    final Database database;
    FileChannel raFile;
    private Lobs lobs;
    long firstPage;
    private final HashMap locks = new HashMap();
    private SSConnection tabLockConnection;
    private int tabLockCount;
    private final ArrayList locksInsert = new ArrayList();
    private final HashMap serializeConnections = new HashMap();
    final IndexDescriptions indexes;
    final ForeignKeys references;

    Table(Database database, SSConnection sSConnection, String string, FileChannel fileChannel, long l, int n) throws Exception {
        super(string, new Columns());
        int n2;
        this.database = database;
        this.raFile = fileChannel;
        this.firstPage = l;
        StoreImpl storeImpl = this.getStore(sSConnection, this.firstPage, 200);
        if (storeImpl == null) {
            throw SmallSQLException.create("SS-0197", this.getFile(database));
        }
        int n3 = storeImpl.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            this.columns.add(storeImpl.readColumn(n));
        }
        this.indexes = new IndexDescriptions();
        this.references = new ForeignKeys();
        while ((n2 = storeImpl.readInt()) != 0) {
            int n4 = storeImpl.getCurrentOffsetInPage();
            int n5 = storeImpl.readInt();
            switch (n2) {
                case 1: {
                    this.indexes.add(IndexDescription.load(database, this, storeImpl));
                }
            }
            storeImpl.setCurrentOffsetInPage(n4 + n5);
        }
        this.firstPage = storeImpl.getNextPagePos();
    }

    Table(Database database, SSConnection sSConnection, String string, Columns columns, IndexDescriptions indexDescriptions, ForeignKeys foreignKeys) throws Exception {
        this(database, sSConnection, string, columns, null, indexDescriptions, foreignKeys);
    }

    Table(Database database, SSConnection sSConnection, String string, Columns columns, IndexDescriptions indexDescriptions, IndexDescriptions indexDescriptions2, ForeignKeys foreignKeys) throws Exception {
        super(string, columns);
        this.database = database;
        this.references = foreignKeys;
        indexDescriptions2.create(sSConnection, database, this);
        if (indexDescriptions == null) {
            this.indexes = indexDescriptions2;
        } else {
            this.indexes = indexDescriptions;
            indexDescriptions.add(indexDescriptions2);
        }
        this.write(sSConnection);
        for (int i = 0; i < foreignKeys.size(); ++i) {
            ForeignKey foreignKey = foreignKeys.get(i);
            Table table = (Table)database.getTableView(sSConnection, foreignKey.pkTable);
            table.references.add(foreignKey);
        }
    }

    Table(Database database, String string) {
        super(string, null);
        this.database = database;
        this.indexes = null;
        this.references = null;
    }

    static void drop(Database database, String string) throws Exception {
        boolean bl = new File(Utils.createTableViewFileName(database, string)).delete();
        if (!bl) {
            throw SmallSQLException.create("SS-0191", string);
        }
    }

    void drop(SSConnection sSConnection) throws Exception {
        boolean bl;
        TableStorePage tableStorePage = this.requestLock(sSConnection, 205, -1L);
        if (tableStorePage == null) {
            throw SmallSQLException.create("SS-0192", this.name);
        }
        sSConnection.rollbackFile(this.raFile);
        this.close();
        if (this.lobs != null) {
            this.lobs.drop(sSConnection);
        }
        if (this.indexes != null) {
            this.indexes.drop(this.database);
        }
        if (!(bl = this.getFile(this.database).delete())) {
            throw SmallSQLException.create("SS-0191", this.name);
        }
    }

    void close() throws Exception {
        if (this.indexes != null) {
            this.indexes.close();
        }
        this.raFile.close();
        this.raFile = null;
        if (this.lobs != null) {
            this.lobs.close();
            this.lobs = null;
        }
    }

    private void write(SSConnection sSConnection) throws Exception {
        int n;
        this.raFile = this.createFile(sSConnection, this.database);
        this.firstPage = 8L;
        StoreImpl storeImpl = this.getStore(sSConnection, this.firstPage, 205);
        int n2 = this.columns.size();
        storeImpl.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            storeImpl.writeColumn(this.columns.get(n));
        }
        for (n = 0; n < this.indexes.size(); ++n) {
            IndexDescription indexDescription = this.indexes.get(n);
            storeImpl.writeInt(1);
            int n3 = storeImpl.getCurrentOffsetInPage();
            storeImpl.setCurrentOffsetInPage(n3 + 4);
            indexDescription.save(storeImpl);
            int n4 = storeImpl.getCurrentOffsetInPage();
            storeImpl.setCurrentOffsetInPage(n3);
            storeImpl.writeInt(n4 - n3);
            storeImpl.setCurrentOffsetInPage(n4);
        }
        storeImpl.writeInt(0);
        storeImpl.writeFinsh(null);
        this.firstPage = storeImpl.getNextPagePos();
    }

    void writeMagic(FileChannel fileChannel) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putInt(1397836884);
        byteBuffer.putInt(2);
        byteBuffer.position(0);
        fileChannel.write(byteBuffer);
    }

    StoreImpl getStore(SSConnection sSConnection, long l, int n) throws Exception {
        TableStorePage tableStorePage = this.requestLock(sSConnection, n, l);
        return StoreImpl.createStore(this, tableStorePage, n, l);
    }

    StoreImpl getStore(TableStorePage tableStorePage, int n) throws Exception {
        return StoreImpl.recreateStore(this, tableStorePage, n);
    }

    StoreImpl getStoreInsert(SSConnection sSConnection) throws Exception {
        TableStorePage tableStorePage = this.requestLock(sSConnection, 1107, -1L);
        return StoreImpl.createStore(this, tableStorePage, 1107, -1L);
    }

    StoreImpl getStoreTemp(SSConnection sSConnection) throws Exception {
        TableStorePage tableStorePage = new TableStorePage(sSConnection, this, 0, -2L);
        return StoreImpl.createStore(this, tableStorePage, 1107, -2L);
    }

    StoreImpl getLobStore(SSConnection sSConnection, long l, int n) throws Exception {
        if (this.lobs == null) {
            this.lobs = new Lobs(this);
        }
        return this.lobs.getStore(sSConnection, l, n);
    }

    final long getFirstPage() {
        return this.firstPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getInserts(SSConnection sSConnection) {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            ArrayList<StorePageLink> arrayList = new ArrayList<StorePageLink>();
            if (sSConnection.isolationLevel <= 1) {
                for (int i = 0; i < this.locksInsert.size(); ++i) {
                    TableStorePageInsert tableStorePageInsert = (TableStorePageInsert)this.locksInsert.get(i);
                    arrayList.add(tableStorePageInsert.getLink());
                }
            } else {
                for (int i = 0; i < this.locksInsert.size(); ++i) {
                    TableStorePageInsert tableStorePageInsert = (TableStorePageInsert)this.locksInsert.get(i);
                    if (tableStorePageInsert.con != sSConnection) continue;
                    arrayList.add(tableStorePageInsert.getLink());
                }
            }
            return arrayList;
        }
    }

    final TableStorePage requestLock(SSConnection sSConnection, int n, long l) throws Exception {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            if (this.raFile == null) {
                throw SmallSQLException.create("SS-0194", this.name);
            }
            long l2 = 0L;
            while (true) {
                long l3;
                TableStorePage tableStorePage;
                if ((tableStorePage = this.requestLockImpl(sSConnection, n, l)) != null) {
                    return tableStorePage;
                }
                if (l2 == 0L) {
                    l2 = System.currentTimeMillis() + 5000L;
                }
                if ((l3 = l2 - System.currentTimeMillis()) <= 0L) {
                    throw SmallSQLException.create("SS-0195", this.name);
                }
                this.locks.wait(l3);
            }
        }
    }

    private final TableStorePage requestLockImpl(SSConnection sSConnection, int n, long l) throws SQLException {
        HashMap hashMap = this.locks;
        synchronized (hashMap) {
            if (this.tabLockConnection != null && this.tabLockConnection != sSConnection) {
                return null;
            }
            switch (sSConnection.isolationLevel) {
                case 8: {
                    this.serializeConnections.put(sSConnection, sSConnection);
                }
            }
            switch (n) {
                case 205: {
                    if (this.locks.size() > 0) {
                        for (TableStorePage tableStorePage : this.locks.values()) {
                            if (tableStorePage.con == sSConnection) continue;
                            return null;
                        }
                    }
                    for (int i = 0; i < this.locksInsert.size(); ++i) {
                        TableStorePage tableStorePage;
                        tableStorePage = (TableStorePageInsert)this.locksInsert.get(i);
                        if (((TableStorePageInsert)tableStorePage).con == sSConnection) continue;
                        return null;
                    }
                    if (this.serializeConnections.size() > 0) {
                        for (TableStorePage tableStorePage : this.locks.values()) {
                            if (tableStorePage.con == sSConnection) continue;
                            return null;
                        }
                    }
                    this.tabLockConnection = sSConnection;
                    ++this.tabLockCount;
                    TableStorePage tableStorePage = new TableStorePage(sSConnection, this, 4, l);
                    sSConnection.add(tableStorePage);
                    return tableStorePage;
                }
                case 207: {
                    if (this.locks.size() > 0 || this.locksInsert.size() > 0) {
                        return null;
                    }
                    if (this.serializeConnections.size() > 0) {
                        for (TableStorePage tableStorePage : this.locks.values()) {
                            if (tableStorePage.con == sSConnection) continue;
                            return null;
                        }
                    }
                    this.tabLockConnection = sSConnection;
                    ++this.tabLockCount;
                    TableStorePage tableStorePage = new TableStorePage(sSConnection, this, 4, l);
                    tableStorePage.rollback();
                    return tableStorePage;
                }
                case 1107: {
                    if (this.serializeConnections.size() > 1) {
                        return null;
                    }
                    if (this.serializeConnections.size() == 1 && this.serializeConnections.get(sSConnection) == null) {
                        return null;
                    }
                    TableStorePageInsert tableStorePageInsert = new TableStorePageInsert(sSConnection, this, 1);
                    this.locksInsert.add(tableStorePageInsert);
                    sSConnection.add(tableStorePageInsert);
                    return tableStorePageInsert;
                }
                case 200: 
                case 204: {
                    Long l2 = new Long(l);
                    TableStorePage tableStorePage = null;
                    TableStorePage tableStorePage2 = (TableStorePage)this.locks.get(l2);
                    TableStorePage tableStorePage3 = null;
                    while (tableStorePage2 != null) {
                        if (tableStorePage2.con == sSConnection || sSConnection.isolationLevel <= 1) {
                            tableStorePage3 = tableStorePage2;
                        } else if (tableStorePage2.lockType == 3) {
                            return null;
                        }
                        tableStorePage = tableStorePage2;
                        tableStorePage2 = tableStorePage2.nextLock;
                    }
                    if (tableStorePage3 != null) {
                        return tableStorePage3;
                    }
                    tableStorePage2 = new TableStorePage(sSConnection, this, 0, l);
                    if (sSConnection.isolationLevel >= 4 || n == 204) {
                        int n2 = tableStorePage2.lockType = n == 204 ? 3 : 2;
                        if (tableStorePage != null) {
                            tableStorePage.nextLock = tableStorePage2.nextLock;
                        } else {
                            this.locks.put(l2, tableStorePage2);
                        }
                        sSConnection.add(tableStorePage2);
                    }
                    return tableStorePage2;
                }
                case 313: {
                    return new TableStorePage(sSConnection, this, 1, -1L);
                }
            }
            throw new Error("pageOperation:" + n);
        }
    }

    TableStorePage requestWriteLock(SSConnection sSConnection, TableStorePage tableStorePage) throws SQLException {
        if (tableStorePage.lockType == 1) {
            TableStorePage tableStorePage2;
            tableStorePage.nextLock = tableStorePage2 = new TableStorePage(sSConnection, this, 1, -1L);
            sSConnection.add(tableStorePage2);
            return tableStorePage2;
        }
        Long l = new Long(tableStorePage.fileOffset);
        TableStorePage tableStorePage3 = null;
        TableStorePage tableStorePage4 = (TableStorePage)this.locks.get(l);
        while (tableStorePage4 != null) {
            if (tableStorePage4.con != sSConnection) {
                return null;
            }
            if (tableStorePage4.lockType < 3) {
                tableStorePage4.lockType = 3;
                return tableStorePage4;
            }
            tableStorePage3 = tableStorePage4;
            tableStorePage4 = tableStorePage4.nextLock;
        }
        tableStorePage4 = new TableStorePage(sSConnection, this, 3, tableStorePage.fileOffset);
        if (tableStorePage3 != null) {
            tableStorePage3.nextLock = tableStorePage4;
        } else {
            this.locks.put(l, tableStorePage4);
        }
        sSConnection.add(tableStorePage4);
        return tableStorePage4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void freeLock(TableStorePage tableStorePage) {
        int n = tableStorePage.lockType;
        long l = tableStorePage.fileOffset;
        HashMap hashMap = this.locks;
        // MONITORENTER : hashMap
        try {
            switch (n) {
                case 1: {
                    for (int i = 0; i < this.locksInsert.size(); ++i) {
                        TableStorePage tableStorePage2;
                        TableStorePage tableStorePage3 = tableStorePage2 = (TableStorePage)this.locksInsert.get(i);
                        while (tableStorePage2 != null) {
                            if (tableStorePage2 == tableStorePage) {
                                if (tableStorePage2 != tableStorePage3) {
                                    tableStorePage3.nextLock = tableStorePage2.nextLock;
                                    return;
                                }
                                if (tableStorePage2.nextLock == null) {
                                    this.locksInsert.remove(i--);
                                    return;
                                }
                                this.locksInsert.set(i, tableStorePage2.nextLock);
                                return;
                            }
                            tableStorePage3 = tableStorePage2;
                            tableStorePage2 = tableStorePage2.nextLock;
                        }
                    }
                    return;
                }
                case 2: 
                case 3: {
                    TableStorePage tableStorePage4;
                    Long l2 = new Long(l);
                    TableStorePage tableStorePage5 = tableStorePage4 = (TableStorePage)this.locks.get(l2);
                    while (tableStorePage4 != null) {
                        if (tableStorePage4 == tableStorePage) {
                            if (tableStorePage4 != tableStorePage5) {
                                tableStorePage5.nextLock = tableStorePage4.nextLock;
                                return;
                            }
                            if (tableStorePage4.nextLock == null) {
                                this.locks.remove(l2);
                                return;
                            }
                            this.locks.put(l2, tableStorePage4.nextLock);
                            return;
                        }
                        tableStorePage5 = tableStorePage4;
                        tableStorePage4 = tableStorePage4.nextLock;
                    }
                    return;
                }
                case 4: {
                    assert (tableStorePage.con == this.tabLockConnection) : "Internal Error with TabLock";
                    if (--this.tabLockCount != 0) return;
                    this.tabLockConnection = null;
                    return;
                }
                default: {
                    throw new Error();
                }
            }
        }
        finally {
            this.locks.notifyAll();
        }
    }
}

