/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expressions;
import smallsql.database.LongList;
import smallsql.database.RowSource;
import smallsql.database.SmallSQLException;

class Scrollable
extends RowSource {
    private final RowSource rowSource;
    private int rowIdx;
    private final LongList rowList = new LongList();

    Scrollable(RowSource rowSource) {
        this.rowSource = rowSource;
    }

    final boolean isScrollable() {
        return true;
    }

    void beforeFirst() throws Exception {
        this.rowIdx = -1;
        this.rowSource.beforeFirst();
    }

    boolean isBeforeFirst() {
        return this.rowIdx == -1 || this.rowList.size() == 0;
    }

    boolean isFirst() {
        return this.rowIdx == 0 && this.rowList.size() > 0;
    }

    boolean first() throws Exception {
        this.rowIdx = -1;
        return this.next();
    }

    boolean previous() throws Exception {
        if (this.rowIdx > -1) {
            --this.rowIdx;
            if (this.rowIdx > -1 && this.rowIdx < this.rowList.size()) {
                this.rowSource.setRowPosition(this.rowList.get(this.rowIdx));
                return true;
            }
        }
        this.rowSource.beforeFirst();
        return false;
    }

    boolean next() throws Exception {
        if (++this.rowIdx < this.rowList.size()) {
            this.rowSource.setRowPosition(this.rowList.get(this.rowIdx));
            return true;
        }
        boolean bl = this.rowSource.next();
        if (bl) {
            this.rowList.add(this.rowSource.getRowPosition());
            return true;
        }
        this.rowIdx = this.rowList.size();
        return false;
    }

    boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    boolean isLast() throws Exception {
        if (this.rowIdx + 1 != this.rowList.size()) {
            return false;
        }
        boolean bl = this.next();
        this.previous();
        return !bl && this.rowIdx + 1 == this.rowList.size() && this.rowList.size() > 0;
    }

    boolean isAfterLast() throws Exception {
        if (this.rowIdx >= this.rowList.size()) {
            return true;
        }
        if (this.isBeforeFirst() && this.rowList.size() == 0) {
            this.next();
            this.previous();
            if (this.rowList.size() == 0) {
                return true;
            }
        }
        return false;
    }

    void afterLast() throws Exception {
        if (this.rowIdx + 1 < this.rowList.size()) {
            this.rowIdx = this.rowList.size() - 1;
            this.rowSource.setRowPosition(this.rowList.get(this.rowIdx));
        }
        while (this.next()) {
        }
    }

    boolean absolute(int n) throws Exception {
        boolean bl;
        if (n == 0) {
            throw SmallSQLException.create("SS-0520");
        }
        if (n < 0) {
            this.afterLast();
            this.rowIdx = this.rowList.size() + n;
            if (this.rowIdx < 0) {
                this.beforeFirst();
                return false;
            }
            this.rowSource.setRowPosition(this.rowList.get(this.rowIdx));
            return true;
        }
        if (n <= this.rowList.size()) {
            this.rowIdx = n - 1;
            this.rowSource.setRowPosition(this.rowList.get(this.rowIdx));
            return true;
        }
        this.rowIdx = this.rowList.size() - 1;
        if (this.rowIdx >= 0) {
            this.rowSource.setRowPosition(this.rowList.get(this.rowIdx));
        }
        while ((bl = this.next()) && n - 1 > this.rowIdx) {
        }
        return bl;
    }

    boolean relative(int n) throws Exception {
        int n2 = n + this.rowIdx + 1;
        if (n2 <= 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(n2);
    }

    int getRow() throws Exception {
        if (this.rowIdx >= this.rowList.size()) {
            return 0;
        }
        return this.rowIdx + 1;
    }

    long getRowPosition() {
        return this.rowIdx;
    }

    void setRowPosition(long l) throws Exception {
        this.rowIdx = (int)l;
    }

    final boolean rowInserted() {
        return this.rowSource.rowInserted();
    }

    final boolean rowDeleted() {
        return this.rowSource.rowDeleted();
    }

    void nullRow() {
        this.rowSource.nullRow();
        this.rowIdx = -1;
    }

    void noRow() {
        this.rowSource.noRow();
        this.rowIdx = -1;
    }

    void execute() throws Exception {
        this.rowSource.execute();
        this.rowList.clear();
        this.rowIdx = -1;
    }

    boolean isExpressionsFromThisRowSource(Expressions expressions) {
        return this.rowSource.isExpressionsFromThisRowSource(expressions);
    }
}

