/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import smallsql.database.SQLToken;
import smallsql.database.SearchNode;
import smallsql.database.SmallSQLException;
import smallsql.database.Utils;

public class SQLTokenizer {
    private static final int NOT_COMMENT = 0;
    private static final int LINE_COMMENT = 1;
    private static final int MULTI_COMMENT = 2;
    static SearchNode searchTree;
    static Hashtable keywords;
    static final int VALUE = 0;
    static final int STRING = 3;
    static final int IDENTIFIER = 4;
    static final int NUMBERVALUE = 5;
    static final int PERCENT = 37;
    static final int BIT_AND = 38;
    static final int PARENTHESIS_L = 40;
    static final int PARENTHESIS_R = 41;
    static final int ASTERISK = 42;
    static final int PLUS = 43;
    static final int COMMA = 44;
    static final int MINUS = 45;
    static final int POINT = 46;
    static final int SLACH = 47;
    static final int LESSER = 60;
    static final int EQUALS = 61;
    static final int GREATER = 62;
    static final int QUESTION = 63;
    static final int BIT_XOR = 94;
    static final int ESCAPE_L = 123;
    static final int BIT_OR = 124;
    static final int ESCAPE_R = 125;
    static final int TILDE = 126;
    static final int LESSER_EQU = 160;
    static final int UNEQUALS = 161;
    static final int GREATER_EQU = 162;
    static final int SELECT = 200;
    static final int DELETE = 201;
    static final int INTO = 203;
    static final int UPDATE = 204;
    static final int CREATE = 205;
    static final int DROP = 206;
    static final int ALTER = 207;
    static final int SET = 208;
    static final int EXECUTE = 209;
    static final int FROM = 210;
    static final int WHERE = 211;
    static final int GROUP = 212;
    static final int BY = 213;
    static final int HAVING = 214;
    static final int ORDER = 215;
    static final int ASC = 216;
    static final int DESC = 217;
    static final int VALUES = 218;
    static final int AS = 219;
    static final int DEFAULT = 220;
    static final int IDENTITY = 221;
    static final int INNER = 222;
    static final int JOIN = 223;
    static final int ON = 224;
    static final int OUTER = 225;
    static final int FULL = 226;
    static final int CROSS = 227;
    static final int USE = 228;
    static final int TOP = 229;
    static final int ADD = 230;
    static final int LIMIT = 231;
    static final int DATABASE = 235;
    static final int TABLE = 236;
    static final int VIEW = 237;
    static final int INDEX = 238;
    static final int PROCEDURE = 239;
    static final int TRANSACTION = 240;
    static final int ISOLATION = 241;
    static final int LEVEL = 242;
    static final int READ = 243;
    static final int COMMITTED = 244;
    static final int UNCOMMITTED = 245;
    static final int REPEATABLE = 246;
    static final int SERIALIZABLE = 247;
    static final int CONSTRAINT = 250;
    static final int PRIMARY = 251;
    static final int FOREIGN = 252;
    static final int KEY = 253;
    static final int UNIQUE = 254;
    static final int CLUSTERED = 255;
    static final int NONCLUSTERED = 256;
    static final int REFERENCES = 257;
    static final int UNION = 260;
    static final int ALL = 261;
    static final int DISTINCT = 262;
    static final int CASE = 263;
    static final int WHEN = 264;
    static final int THEN = 265;
    static final int ELSE = 266;
    static final int END = 267;
    static final int SWITCH = 268;
    static final String DESC_STR = "DESC";
    static final int BIT = 300;
    static final int BOOLEAN = 301;
    static final int BINARY = 310;
    static final int VARBINARY = 311;
    static final int RAW = 312;
    static final int LONGVARBINARY = 313;
    static final int BLOB = 316;
    static final int TINYINT = 321;
    static final int SMALLINT = 322;
    static final int INT = 323;
    static final int COUNTER = 324;
    static final int BIGINT = 325;
    static final int SMALLMONEY = 330;
    static final int MONEY = 331;
    static final int DECIMAL = 332;
    static final int NUMERIC = 333;
    static final int REAL = 336;
    static final int FLOAT = 337;
    static final int DOUBLE = 338;
    static final int DATE = 340;
    static final int TIME = 341;
    static final int TIMESTAMP = 342;
    static final int SMALLDATETIME = 343;
    static final int CHAR = 350;
    static final int NCHAR = 352;
    static final int VARCHAR = 353;
    static final int NVARCHAR = 355;
    static final int SYSNAME = 357;
    static final int LONGVARCHAR = 359;
    static final int LONGNVARCHAR = 360;
    static final int LONG = 361;
    static final int CLOB = 362;
    static final int NCLOB = 363;
    static final int UNIQUEIDENTIFIER = 370;
    static final int JAVA_OBJECT = 371;
    static final int D = 400;
    static final int T = 401;
    static final int TS = 402;
    static final int FN = 403;
    static final int CALL = 404;
    static final int OJ = 405;
    static final int OR = 500;
    static final int AND = 501;
    static final int IS = 502;
    static final int NOT = 503;
    static final int NULL = 504;
    static final int TRUE = 505;
    static final int FALSE = 506;
    static final int BETWEEN = 507;
    static final int LIKE = 508;
    static final int IN = 509;
    static final int ABS = 1000;
    static final int ACOS = 1001;
    static final int ASIN = 1002;
    static final int ATAN = 1003;
    static final int ATAN2 = 1004;
    static final int CEILING = 1005;
    static final int COS = 1006;
    static final int COT = 1007;
    static final int DEGREES = 1008;
    static final int EXP = 1009;
    static final int FLOOR = 1010;
    static final int LOG = 1011;
    static final int LOG10 = 1012;
    static final int MOD = 1013;
    static final int PI = 1014;
    static final int POWER = 1015;
    static final int RADIANS = 1016;
    static final int RAND = 1017;
    static final int ROUND = 1018;
    static final int SIGN = 1019;
    static final int SIN = 1020;
    static final int SQRT = 1021;
    static final int TAN = 1022;
    static final int TRUNCATE = 1023;
    static final int ASCII = 1100;
    static final int BITLEN = 1101;
    static final int CHARLEN = 1102;
    static final int CHARACTLEN = 1103;
    static final int _CHAR = 1104;
    static final int CONCAT = 1105;
    static final int DIFFERENCE = 1106;
    static final int INSERT = 1107;
    static final int LCASE = 1108;
    static final int LEFT = 1109;
    static final int LENGTH = 1110;
    static final int LOCATE = 1111;
    static final int LTRIM = 1112;
    static final int OCTETLEN = 1113;
    static final int REPEAT = 1114;
    static final int REPLACE = 1115;
    static final int RIGHT = 1116;
    static final int RTRIM = 1117;
    static final int SOUNDEX = 1118;
    static final int SPACE = 1119;
    static final int SUBSTRING = 1120;
    static final int TRIM = 1121;
    static final int UCASE = 1122;
    static final int CURDATE = 1200;
    static final int CURRENTDATE = 1201;
    static final int CURTIME = 1202;
    static final int DAYNAME = 1203;
    static final int DAYOFMONTH = 1204;
    static final int DAYOFWEEK = 1205;
    static final int DAYOFYEAR = 1206;
    static final int DAY = 1207;
    static final int HOUR = 1208;
    static final int MILLISECOND = 1209;
    static final int MINUTE = 1210;
    static final int MONTH = 1211;
    static final int MONTHNAME = 1212;
    static final int NOW = 1213;
    static final int QUARTER = 1214;
    static final int SECOND = 1215;
    static final int TIMESTAMPADD = 1216;
    static final int TIMESTAMPDIFF = 1217;
    static final int WEEK = 1218;
    static final int YEAR = 1219;
    static final int SQL_TSI_FRAC_SECOND = 1250;
    static final int SQL_TSI_SECOND = 1251;
    static final int SQL_TSI_MINUTE = 1252;
    static final int SQL_TSI_HOUR = 1253;
    static final int SQL_TSI_DAY = 1254;
    static final int SQL_TSI_WEEK = 1255;
    static final int SQL_TSI_MONTH = 1256;
    static final int SQL_TSI_QUARTER = 1257;
    static final int SQL_TSI_YEAR = 1258;
    static final int IFNULL = 1301;
    static final int USER = 1302;
    static final int CONVERT = 1303;
    static final int CAST = 1304;
    static final int IIF = 1305;
    static final int SQL_BIGINT = 1350;
    static final int SQL_BINARY = 1351;
    static final int SQL_BIT = 1352;
    static final int SQL_CHAR = 1353;
    static final int SQL_DATE = 1354;
    static final int SQL_DECIMAL = 1355;
    static final int SQL_DOUBLE = 1356;
    static final int SQL_FLOAT = 1357;
    static final int SQL_INTEGER = 1358;
    static final int SQL_LONGVARBINARY = 1359;
    static final int SQL_LONGVARCHAR = 1360;
    static final int SQL_REAL = 1361;
    static final int SQL_SMALLINT = 1362;
    static final int SQL_TIME = 1363;
    static final int SQL_TIMESTAMP = 1364;
    static final int SQL_TINYINT = 1365;
    static final int SQL_VARBINARY = 1366;
    static final int SQL_VARCHAR = 1367;
    static final int COUNT = 1400;
    static final int MIN = 1401;
    static final int MAX = 1402;
    static final int SUM = 1403;
    static final int FIRST = 1404;
    static final int LAST = 1405;
    static final int AVG = 1406;

    /*
     * Unable to fully structure code
     */
    public static List parseSQL(char[] var0) throws SQLException {
        var1_1 = SQLTokenizer.searchTree;
        var2_2 = new ArrayList<SQLToken>();
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = true;
        var6_6 = 0;
        var7_7 = '\u0000';
        var8_8 = new StringBuffer();
        block12: for (var9_9 = 0; var9_9 < var0.length; ++var9_9) {
            var10_10 = var0[var9_9];
            switch (var10_10) {
                case '\"': 
                case '\'': {
                    if (var6_6 != 0) continue block12;
                    if (var7_7 == '\u0000') {
                        var7_7 = var10_10;
                        continue block12;
                    }
                    if (var7_7 == var10_10) {
                        if (var9_9 + 1 < var0.length && var0[var9_9 + 1] == var7_7) {
                            var8_8.append(var7_7);
                            ++var9_9;
                            continue block12;
                        }
                        var2_2.add(new SQLToken(var8_8.toString(), var7_7 == '\'' ? 3 : 4, var4_4, var9_9 + 1));
                        var8_8.setLength(0);
                        var7_7 = '\u0000';
                        var4_4 = var9_9 + 1;
                        var5_5 = true;
                        continue block12;
                    }
                    var8_8.append(var10_10);
                    continue block12;
                }
                case '.': {
                    if (var6_6 != 0) continue block12;
                    if (var7_7 == '\u0000') {
                        var11_11 = var4_4;
                        if (var11_11 == var9_9) {
                            if (var0.length > var11_11 + 1 && (var12_12 = var0[var11_11 + 1]) >= '0' && var12_12 <= '9') {
                                continue block12;
                            }
                        } else {
                            while (var11_11 < var9_9 && ((var12_12 = var0[var11_11]) == '-' || var12_12 == '$' || var12_12 >= '0') && var12_12 <= '9') {
                                ++var11_11;
                            }
                            if (var11_11 >= var9_9) continue block12;
                        }
                    }
                }
                case '-': {
                    if (var6_6 != 0) continue block12;
                    if (var10_10 != '-' || var9_9 + 1 >= var0.length || var0[var9_9 + 1] != '-') ** GOTO lbl55
                    if (!var5_5) {
                        var2_2.add(new SQLToken(var3_3, var4_4, var9_9));
                        var3_3 = 0;
                    }
                    var4_4 = ++var9_9 + 1;
                    var6_6 = 1;
                    ** GOTO lbl59
lbl55:
                    // 1 sources

                    if (var7_7 == '\u0000' && !var5_5) {
                        var11_11 = var0[var4_4];
                        var12_12 = var0[var9_9 - 1];
                        if ((var11_11 >= 48 && var11_11 <= 57 || var11_11 == 46) && (var12_12 == 'e' || var12_12 == 'E') || var11_11 == 36 && var4_4 + 1 == var9_9) continue block12;
                    }
                }
lbl59:
                // 5 sources

                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '^': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    if (var6_6 == 1) {
                        if (var10_10 == '\r' || var10_10 == '\n') {
                            var6_6 = 0;
                            var5_5 = true;
                        }
                        var4_4 = var9_9 + 1;
                        continue block12;
                    }
                    if (var6_6 == 2) {
                        if (var10_10 == '*' && var9_9 + 1 < var0.length && var0[var9_9 + 1] == '/') {
                            var6_6 = 0;
                            var5_5 = true;
                            ++var9_9;
                        }
                        var4_4 = var9_9 + 1;
                        continue block12;
                    }
                    if (var7_7 == '\u0000') {
                        if (!var5_5) {
                            var2_2.add(new SQLToken(var3_3, var4_4, var9_9));
                            var3_3 = 0;
                        }
                        switch (var10_10) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                break;
                            }
                            case '<': {
                                if (var9_9 + 1 < var0.length && var0[var9_9 + 1] == '>') {
                                    var2_2.add(new SQLToken(161, var9_9, var9_9 + 2));
                                    ++var9_9;
                                    break;
                                }
                            }
                            case '>': {
                                if (var9_9 + 1 < var0.length && var0[var9_9 + 1] == '=') {
                                    var2_2.add(new SQLToken(100 + var10_10, var9_9, var9_9 + 2));
                                    ++var9_9;
                                    break;
                                }
                            }
                            case '/': {
                                if (var9_9 + 1 < var0.length && var0[var9_9 + 1] == '*') {
                                    var4_4 = ++var9_9 + 1;
                                    var6_6 = 2;
                                    break;
                                }
                            }
                            default: {
                                var2_2.add(new SQLToken(var10_10, var9_9, var9_9 + 1));
                            }
                        }
                        var5_5 = true;
                        var4_4 = var9_9 + 1;
                        continue block12;
                    }
                    var8_8.append(var10_10);
                    continue block12;
                }
                default: {
                    if (var6_6 != 0) continue block12;
                    if (var7_7 == '\u0000') {
                        if (var5_5) {
                            var1_1 = SQLTokenizer.searchTree;
                        } else if (var1_1 == null) {
                            var3_3 = 0;
                            var5_5 = false;
                            continue block12;
                        }
                        var10_10 = (char)(var10_10 | 32);
                        while (var1_1 != null && var1_1.letter != var10_10) {
                            var1_1 = var1_1.nextEntry;
                        }
                        if (var1_1 != null) {
                            var3_3 = var1_1.value;
                            var1_1 = var1_1.nextLetter;
                        } else {
                            var3_3 = 0;
                            var1_1 = null;
                        }
                    } else {
                        var8_8.append(var10_10);
                    }
                    var5_5 = false;
                }
            }
        }
        if (var6_6 == 2) {
            throw SmallSQLException.create("SS-0623");
        }
        if (!var5_5) {
            var2_2.add(new SQLToken(var3_3, var4_4, var0.length));
        }
        return var2_2;
    }

    private static void addKeyWord(String string, int n) {
        keywords.put(Utils.getInteger(n), string);
        char[] cArray = string.toCharArray();
        if (searchTree == null) {
            searchTree = new SearchNode();
            SQLTokenizer.searchTree.letter = (char)(cArray[0] | 0x20);
        }
        SearchNode searchNode = null;
        SearchNode searchNode2 = searchTree;
        boolean bl = true;
        for (int i = 0; i < cArray.length; ++i) {
            char c = (char)(cArray[i] | 0x20);
            while (searchNode2 != null && searchNode2.letter != c) {
                searchNode = searchNode2;
                searchNode2 = searchNode2.nextEntry;
                bl = true;
            }
            if (searchNode2 == null) {
                searchNode2 = new SearchNode();
                searchNode2.letter = c;
                if (bl) {
                    searchNode.nextEntry = searchNode2;
                } else {
                    searchNode.nextLetter = searchNode2;
                }
                bl = false;
                searchNode = searchNode2;
                searchNode2 = null;
                continue;
            }
            searchNode = searchNode2;
            searchNode2 = searchNode2.nextLetter;
            bl = false;
        }
        searchNode.value = n;
    }

    static final String getKeyWord(int n) {
        return (String)keywords.get(Utils.getInteger(n));
    }

    static final int getSQLDataType(int n) {
        switch (n) {
            case 300: {
                return -7;
            }
            case 301: {
                return 16;
            }
            case 310: {
                return -2;
            }
            case 311: {
                return -3;
            }
            case 313: {
                return -4;
            }
            case 316: {
                return 2004;
            }
            case 321: {
                return -6;
            }
            case 322: {
                return 5;
            }
            case 323: {
                return 4;
            }
            case 325: {
                return -5;
            }
            case 330: 
            case 331: 
            case 332: {
                return 3;
            }
            case 333: {
                return 2;
            }
            case 336: {
                return 7;
            }
            case 337: {
                return 6;
            }
            case 338: {
                return 8;
            }
            case 340: {
                return 91;
            }
            case 341: {
                return 92;
            }
            case 342: 
            case 343: {
                return 93;
            }
            case 350: 
            case 352: {
                return 1;
            }
            case 353: 
            case 355: {
                return 12;
            }
            case 359: 
            case 360: {
                return -1;
            }
            case 362: 
            case 363: {
                return 2005;
            }
            case 371: {
                return 2000;
            }
            case 370: {
                return -11;
            }
            case 504: {
                return 0;
            }
        }
        throw new Error("DataType:" + n);
    }

    static {
        keywords = new Hashtable(337);
        keywords.put(new Integer(0), "<expression>");
        keywords.put(new Integer(4), "<identifier>");
        keywords.put(new Integer(5), "<number>");
        keywords.put(new Integer(160), "<=");
        keywords.put(new Integer(161), "<>");
        keywords.put(new Integer(162), ">=");
        SQLTokenizer.addKeyWord("SELECT", 200);
        SQLTokenizer.addKeyWord("DELETE", 201);
        SQLTokenizer.addKeyWord("INTO", 203);
        SQLTokenizer.addKeyWord("UPDATE", 204);
        SQLTokenizer.addKeyWord("CREATE", 205);
        SQLTokenizer.addKeyWord("DROP", 206);
        SQLTokenizer.addKeyWord("ALTER", 207);
        SQLTokenizer.addKeyWord("SET", 208);
        SQLTokenizer.addKeyWord("EXEC", 209);
        SQLTokenizer.addKeyWord("EXECUTE", 209);
        SQLTokenizer.addKeyWord("FROM", 210);
        SQLTokenizer.addKeyWord("WHERE", 211);
        SQLTokenizer.addKeyWord("GROUP", 212);
        SQLTokenizer.addKeyWord("BY", 213);
        SQLTokenizer.addKeyWord("HAVING", 214);
        SQLTokenizer.addKeyWord("ORDER", 215);
        SQLTokenizer.addKeyWord("ASC", 216);
        SQLTokenizer.addKeyWord(DESC_STR, 217);
        SQLTokenizer.addKeyWord("VALUES", 218);
        SQLTokenizer.addKeyWord("AS", 219);
        SQLTokenizer.addKeyWord("DEFAULT", 220);
        SQLTokenizer.addKeyWord("AUTO_INCREMENT", 221);
        SQLTokenizer.addKeyWord("IDENTITY", 221);
        SQLTokenizer.addKeyWord("INNER", 222);
        SQLTokenizer.addKeyWord("JOIN", 223);
        SQLTokenizer.addKeyWord("ON", 224);
        SQLTokenizer.addKeyWord("OUTER", 225);
        SQLTokenizer.addKeyWord("FULL", 226);
        SQLTokenizer.addKeyWord("CROSS", 227);
        SQLTokenizer.addKeyWord("USE", 228);
        SQLTokenizer.addKeyWord("TOP", 229);
        SQLTokenizer.addKeyWord("ADD", 230);
        SQLTokenizer.addKeyWord("LIMIT", 231);
        SQLTokenizer.addKeyWord("DATABASE", 235);
        SQLTokenizer.addKeyWord("TABLE", 236);
        SQLTokenizer.addKeyWord("VIEW", 237);
        SQLTokenizer.addKeyWord("INDEX", 238);
        SQLTokenizer.addKeyWord("PROCEDURE", 239);
        SQLTokenizer.addKeyWord("TRANSACTION", 240);
        SQLTokenizer.addKeyWord("ISOLATION", 241);
        SQLTokenizer.addKeyWord("LEVEL", 242);
        SQLTokenizer.addKeyWord("READ", 243);
        SQLTokenizer.addKeyWord("COMMITTED", 244);
        SQLTokenizer.addKeyWord("UNCOMMITTED", 245);
        SQLTokenizer.addKeyWord("REPEATABLE", 246);
        SQLTokenizer.addKeyWord("SERIALIZABLE", 247);
        SQLTokenizer.addKeyWord("CONSTRAINT", 250);
        SQLTokenizer.addKeyWord("PRIMARY", 251);
        SQLTokenizer.addKeyWord("FOREIGN", 252);
        SQLTokenizer.addKeyWord("KEY", 253);
        SQLTokenizer.addKeyWord("UNIQUE", 254);
        SQLTokenizer.addKeyWord("CLUSTERED", 255);
        SQLTokenizer.addKeyWord("NONCLUSTERED", 256);
        SQLTokenizer.addKeyWord("REFERENCES", 257);
        SQLTokenizer.addKeyWord("UNION", 260);
        SQLTokenizer.addKeyWord("ALL", 261);
        SQLTokenizer.addKeyWord("DISTINCT", 262);
        SQLTokenizer.addKeyWord("CASE", 263);
        SQLTokenizer.addKeyWord("WHEN", 264);
        SQLTokenizer.addKeyWord("THEN", 265);
        SQLTokenizer.addKeyWord("ELSE", 266);
        SQLTokenizer.addKeyWord("END", 267);
        SQLTokenizer.addKeyWord("SWITCH", 268);
        SQLTokenizer.addKeyWord("BIT", 300);
        SQLTokenizer.addKeyWord("BOOLEAN", 301);
        SQLTokenizer.addKeyWord("BINARY", 310);
        SQLTokenizer.addKeyWord("VARBINARY", 311);
        SQLTokenizer.addKeyWord("RAW", 312);
        SQLTokenizer.addKeyWord("IMAGE", 313);
        SQLTokenizer.addKeyWord("LONGVARBINARY", 313);
        SQLTokenizer.addKeyWord("BLOB", 316);
        SQLTokenizer.addKeyWord("BYTE", 321);
        SQLTokenizer.addKeyWord("TINYINT", 321);
        SQLTokenizer.addKeyWord("SMALLINT", 322);
        SQLTokenizer.addKeyWord("INTEGER", 323);
        SQLTokenizer.addKeyWord("INT", 323);
        SQLTokenizer.addKeyWord("SERIAL", 324);
        SQLTokenizer.addKeyWord("COUNTER", 324);
        SQLTokenizer.addKeyWord("BIGINT", 325);
        SQLTokenizer.addKeyWord("SMALLMONEY", 330);
        SQLTokenizer.addKeyWord("MONEY", 331);
        SQLTokenizer.addKeyWord("NUMBER", 332);
        SQLTokenizer.addKeyWord("VARNUM", 332);
        SQLTokenizer.addKeyWord("DECIMAL", 332);
        SQLTokenizer.addKeyWord("NUMERIC", 333);
        SQLTokenizer.addKeyWord("REAL", 336);
        SQLTokenizer.addKeyWord("FLOAT", 337);
        SQLTokenizer.addKeyWord("DOUBLE", 338);
        SQLTokenizer.addKeyWord("DATE", 340);
        SQLTokenizer.addKeyWord("TIME", 341);
        SQLTokenizer.addKeyWord("DATETIME", 342);
        SQLTokenizer.addKeyWord("TIMESTAMP", 342);
        SQLTokenizer.addKeyWord("SMALLDATETIME", 343);
        SQLTokenizer.addKeyWord("CHARACTER", 350);
        SQLTokenizer.addKeyWord("CHAR", 350);
        SQLTokenizer.addKeyWord("NCHAR", 352);
        SQLTokenizer.addKeyWord("VARCHAR2", 353);
        SQLTokenizer.addKeyWord("VARCHAR", 353);
        SQLTokenizer.addKeyWord("NVARCHAR2", 355);
        SQLTokenizer.addKeyWord("NVARCHAR", 355);
        SQLTokenizer.addKeyWord("SYSNAME", 357);
        SQLTokenizer.addKeyWord("TEXT", 359);
        SQLTokenizer.addKeyWord("LONGVARCHAR", 359);
        SQLTokenizer.addKeyWord("NTEXT", 360);
        SQLTokenizer.addKeyWord("LONGNVARCHAR", 360);
        SQLTokenizer.addKeyWord("LONG", 361);
        SQLTokenizer.addKeyWord("CLOB", 362);
        SQLTokenizer.addKeyWord("NCLOB", 363);
        SQLTokenizer.addKeyWord("UNIQUEIDENTIFIER", 370);
        SQLTokenizer.addKeyWord("SQL_VARIANT", 371);
        SQLTokenizer.addKeyWord("JAVA_OBJECT", 371);
        SQLTokenizer.addKeyWord("D", 400);
        SQLTokenizer.addKeyWord("T", 401);
        SQLTokenizer.addKeyWord("TS", 402);
        SQLTokenizer.addKeyWord("FN", 403);
        SQLTokenizer.addKeyWord("CALL", 404);
        SQLTokenizer.addKeyWord("OJ", 405);
        SQLTokenizer.addKeyWord("OR", 500);
        SQLTokenizer.addKeyWord("AND", 501);
        SQLTokenizer.addKeyWord("IS", 502);
        SQLTokenizer.addKeyWord("NOT", 503);
        SQLTokenizer.addKeyWord("NULL", 504);
        SQLTokenizer.addKeyWord("YES", 505);
        SQLTokenizer.addKeyWord("TRUE", 505);
        SQLTokenizer.addKeyWord("NO", 506);
        SQLTokenizer.addKeyWord("FALSE", 506);
        SQLTokenizer.addKeyWord("BETWEEN", 507);
        SQLTokenizer.addKeyWord("LIKE", 508);
        SQLTokenizer.addKeyWord("IN", 509);
        SQLTokenizer.addKeyWord("ABS", 1000);
        SQLTokenizer.addKeyWord("ACOS", 1001);
        SQLTokenizer.addKeyWord("ASIN", 1002);
        SQLTokenizer.addKeyWord("ATAN", 1003);
        SQLTokenizer.addKeyWord("ATN2", 1004);
        SQLTokenizer.addKeyWord("ATAN2", 1004);
        SQLTokenizer.addKeyWord("CEILING", 1005);
        SQLTokenizer.addKeyWord("COS", 1006);
        SQLTokenizer.addKeyWord("COT", 1007);
        SQLTokenizer.addKeyWord("DEGREES", 1008);
        SQLTokenizer.addKeyWord("EXP", 1009);
        SQLTokenizer.addKeyWord("FLOOR", 1010);
        SQLTokenizer.addKeyWord("LOG", 1011);
        SQLTokenizer.addKeyWord("LOG10", 1012);
        SQLTokenizer.addKeyWord("MOD", 1013);
        SQLTokenizer.addKeyWord("PI", 1014);
        SQLTokenizer.addKeyWord("POWER", 1015);
        SQLTokenizer.addKeyWord("RADIANS", 1016);
        SQLTokenizer.addKeyWord("RAND", 1017);
        SQLTokenizer.addKeyWord("ROUND", 1018);
        SQLTokenizer.addKeyWord("SIGN", 1019);
        SQLTokenizer.addKeyWord("SIN", 1020);
        SQLTokenizer.addKeyWord("SQRT", 1021);
        SQLTokenizer.addKeyWord("TAN", 1022);
        SQLTokenizer.addKeyWord("TRUNCATE", 1023);
        SQLTokenizer.addKeyWord("ASCII", 1100);
        SQLTokenizer.addKeyWord("BIT_LENGTH", 1101);
        SQLTokenizer.addKeyWord("CHAR_LENGTH", 1102);
        SQLTokenizer.addKeyWord("CHARACTER_LENGTH", 1103);
        keywords.put(new Integer(1104), "CHAR");
        SQLTokenizer.addKeyWord("CONCAT", 1105);
        SQLTokenizer.addKeyWord("DIFFERENCE", 1106);
        SQLTokenizer.addKeyWord("STUFF", 1107);
        SQLTokenizer.addKeyWord("INSERT", 1107);
        SQLTokenizer.addKeyWord("LCASE", 1108);
        SQLTokenizer.addKeyWord("LEFT", 1109);
        SQLTokenizer.addKeyWord("DATALENGTH", 1110);
        SQLTokenizer.addKeyWord("LEN", 1110);
        SQLTokenizer.addKeyWord("LENGTH", 1110);
        SQLTokenizer.addKeyWord("CHARINDEX", 1111);
        SQLTokenizer.addKeyWord("LOCATE", 1111);
        SQLTokenizer.addKeyWord("LTRIM", 1112);
        SQLTokenizer.addKeyWord("OCTET_LENGTH", 1113);
        SQLTokenizer.addKeyWord("REPEAT", 1114);
        SQLTokenizer.addKeyWord("REPLACE", 1115);
        SQLTokenizer.addKeyWord("RIGHT", 1116);
        SQLTokenizer.addKeyWord("RTRIM", 1117);
        SQLTokenizer.addKeyWord("SOUNDEX", 1118);
        SQLTokenizer.addKeyWord("SPACE", 1119);
        SQLTokenizer.addKeyWord("SUBSTRING", 1120);
        SQLTokenizer.addKeyWord("TRIM", 1121);
        SQLTokenizer.addKeyWord("UCASE", 1122);
        SQLTokenizer.addKeyWord("CURDATE", 1200);
        SQLTokenizer.addKeyWord("CURTIME", 1202);
        SQLTokenizer.addKeyWord("CURRENT_DATE", 1201);
        SQLTokenizer.addKeyWord("DAYNAME", 1203);
        SQLTokenizer.addKeyWord("DAYOFMONTH", 1204);
        SQLTokenizer.addKeyWord("DAYOFWEEK", 1205);
        SQLTokenizer.addKeyWord("DAYOFYEAR", 1206);
        SQLTokenizer.addKeyWord("DAY", 1207);
        SQLTokenizer.addKeyWord("HOUR", 1208);
        SQLTokenizer.addKeyWord("MILLISECOND", 1209);
        SQLTokenizer.addKeyWord("MINUTE", 1210);
        SQLTokenizer.addKeyWord("MONTH", 1211);
        SQLTokenizer.addKeyWord("MONTHNAME", 1212);
        SQLTokenizer.addKeyWord("GETDATE", 1213);
        SQLTokenizer.addKeyWord("NOW", 1213);
        SQLTokenizer.addKeyWord("QUARTER", 1214);
        SQLTokenizer.addKeyWord("SECOND", 1215);
        SQLTokenizer.addKeyWord("DATEADD", 1216);
        SQLTokenizer.addKeyWord("TIMESTAMPADD", 1216);
        SQLTokenizer.addKeyWord("DATEDIFF", 1217);
        SQLTokenizer.addKeyWord("TIMESTAMPDIFF", 1217);
        SQLTokenizer.addKeyWord("WEEK", 1218);
        SQLTokenizer.addKeyWord("YEAR", 1219);
        SQLTokenizer.addKeyWord("MS", 1250);
        SQLTokenizer.addKeyWord("SQL_TSI_FRAC_SECOND", 1250);
        SQLTokenizer.addKeyWord("S", 1251);
        SQLTokenizer.addKeyWord("SS", 1251);
        SQLTokenizer.addKeyWord("SQL_TSI_SECOND", 1251);
        SQLTokenizer.addKeyWord("MI", 1252);
        SQLTokenizer.addKeyWord("N", 1252);
        SQLTokenizer.addKeyWord("SQL_TSI_MINUTE", 1252);
        SQLTokenizer.addKeyWord("HH", 1253);
        SQLTokenizer.addKeyWord("SQL_TSI_HOUR", 1253);
        SQLTokenizer.addKeyWord("DD", 1254);
        SQLTokenizer.addKeyWord("SQL_TSI_DAY", 1254);
        SQLTokenizer.addKeyWord("WK", 1255);
        SQLTokenizer.addKeyWord("WW", 1255);
        SQLTokenizer.addKeyWord("SQL_TSI_WEEK", 1255);
        SQLTokenizer.addKeyWord("M", 1256);
        SQLTokenizer.addKeyWord("MM", 1256);
        SQLTokenizer.addKeyWord("SQL_TSI_MONTH", 1256);
        SQLTokenizer.addKeyWord("Q", 1257);
        SQLTokenizer.addKeyWord("QQ", 1257);
        SQLTokenizer.addKeyWord("SQL_TSI_QUARTER", 1257);
        SQLTokenizer.addKeyWord("YY", 1258);
        SQLTokenizer.addKeyWord("YYYY", 1258);
        SQLTokenizer.addKeyWord("SQL_TSI_YEAR", 1258);
        SQLTokenizer.addKeyWord("ISNULL", 1301);
        SQLTokenizer.addKeyWord("IFNULL", 1301);
        SQLTokenizer.addKeyWord("USER", 1302);
        SQLTokenizer.addKeyWord("CONVERT", 1303);
        SQLTokenizer.addKeyWord("CAST", 1304);
        SQLTokenizer.addKeyWord("IIF", 1305);
        SQLTokenizer.addKeyWord("SQL_BIGINT", 1350);
        SQLTokenizer.addKeyWord("SQL_BINARY", 1351);
        SQLTokenizer.addKeyWord("SQL_BIT", 1352);
        SQLTokenizer.addKeyWord("SQL_CHAR", 1353);
        SQLTokenizer.addKeyWord("SQL_DATE", 1354);
        SQLTokenizer.addKeyWord("SQL_DECIMAL", 1355);
        SQLTokenizer.addKeyWord("SQL_DOUBLE", 1356);
        SQLTokenizer.addKeyWord("SQL_FLOAT", 1357);
        SQLTokenizer.addKeyWord("SQL_INTEGER", 1358);
        SQLTokenizer.addKeyWord("SQL_LONGVARBINARY", 1359);
        SQLTokenizer.addKeyWord("SQL_LONGVARCHAR", 1360);
        SQLTokenizer.addKeyWord("SQL_REAL", 1361);
        SQLTokenizer.addKeyWord("SQL_SMALLINT", 1362);
        SQLTokenizer.addKeyWord("SQL_TIME", 1363);
        SQLTokenizer.addKeyWord("SQL_TIMESTAMP", 1364);
        SQLTokenizer.addKeyWord("SQL_TINYINT", 1365);
        SQLTokenizer.addKeyWord("SQL_VARBINARY", 1366);
        SQLTokenizer.addKeyWord("SQL_VARCHAR", 1367);
        SQLTokenizer.addKeyWord("COUNT", 1400);
        SQLTokenizer.addKeyWord("MIN", 1401);
        SQLTokenizer.addKeyWord("MAX", 1402);
        SQLTokenizer.addKeyWord("SUM", 1403);
        SQLTokenizer.addKeyWord("FIRST", 1404);
        SQLTokenizer.addKeyWord("LAST", 1405);
        SQLTokenizer.addKeyWord("AVG", 1406);
    }
}

